/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfUtils;

public class DeleteFinishHiActInstTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(DeleteFinishHiActInstTask.class);
    private static final String WFCONFCENTER = "wf_confcenter";
    private static final String VALUE = "value";
    private static final String VALUE_STARTINGTIME = "startingTime";
    private static final String VALUE_STARTINGDATE = "startingDate";
    private static final String VALUE_MAXCLEANDATE = "maxCleanDate";
    private static final String VALUE_RETENTIONTIME = "retentionTime";
    private static final String VALUE_LIMITQUANTITY = "limitQuantity";
    private static final String VALUE_STEPLIMITQUANTITY = "stepLimitQuantity";
    private static final String VALUE_STEPLENGTH = "stepLength";
    private static final String KEY_DELETEFINISHHIACTINST = "workflow.schedule.DeleteFinishHiActInst";

    public void execute(RequestContext ctx, Map<String, Object> param) throws KDException {
        Map<String, Object> params = this.getTaskParam();
        if (params == null) {
            return;
        }
        this.findAndCleanData(params);
        this.saveParams(params);
    }

    private void findAndCleanData(Map<String, Object> params) {
        int limitQuantity = (Integer)params.get(VALUE_LIMITQUANTITY);
        int stepLimitQuantity = (Integer)params.get(VALUE_STEPLIMITQUANTITY);
        int stepLength = (Integer)params.get(VALUE_STEPLENGTH);
        int cleanCount = 0;
        int loopCount = 0;
        Date maxCleanDate = (Date)params.get(VALUE_MAXCLEANDATE);
        Date startingDate = (Date)params.get(VALUE_STARTINGDATE);
        do {
            int disposeTotal = this.executeEverySegment(params, stepLimitQuantity, stepLength, startingDate, maxCleanDate);
            startingDate = (Date)params.get(VALUE_STARTINGDATE);
            cleanCount = disposeTotal + cleanCount;
        } while (!startingDate.equals(maxCleanDate) && !startingDate.after(maxCleanDate) && cleanCount < limitQuantity && ++loopCount <= 50);
    }

    private int executeEverySegment(Map<String, Object> params, int stepLimitQuantity, int stepLength, Date startingDate, Date maxCleanDate) {
        Date endingDate = this.getTargetTime(startingDate, stepLength);
        if (endingDate.after(maxCleanDate)) {
            endingDate = maxCleanDate;
        }
        log.debug(String.format(String.format("\u5220\u9664\u4e1a\u52a1\u6d41\u5df2\u7ed3\u675f\u7684\u6d3b\u52a8\u5b9e\u4f8b\u6570\u636eTask-\u6267\u884c\u4e2d\uff0c\u51c6\u5907\u5220\u9664[%s-%s]\u4e4b\u95f4\u7684\u6570\u636e\uff0c ", startingDate.toString(), endingDate.toString()), new Object[0]));
        String orderBys = String.format("%s asc", "endTime");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("endTime", "<", (Object)endingDate));
        filters.add(new QFilter("endTime", ">=", (Object)startingDate));
        filters.add(new QFilter("processtype", "=", (Object)ProcessType.BizFlow.name()));
        String selectFieldStr = String.format("%s,%s", "id", "endTime");
        ArrayList<Object> procInstIds = new ArrayList<Object>(10);
        int i = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DefaultRegularTimeCleaner.executeEverySegment", (String)"wf_hiprocinst", (String)selectFieldStr, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)stepLimitQuantity);){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                procInstIds.add(row.get("id"));
                startingDate = row.getDate("endTime");
                if (++i % 200 != 0) continue;
                this.disposePartData(procInstIds);
                procInstIds.clear();
            }
            if (stepLimitQuantity > i) {
                startingDate = endingDate;
            }
            if (i % 200 > 0) {
                this.disposePartData(procInstIds);
            }
        }
        params.put(VALUE_STARTINGDATE, startingDate);
        log.debug(String.format("\u5220\u9664\u4e1a\u52a1\u6d41\u5df2\u7ed3\u675f\u7684\u6d3b\u52a8\u5b9e\u4f8b\u6570\u636eTask-\u6267\u884c\u4e2d\uff0c\u5df2\u5220\u9664\u5230\u6d41\u7a0b\u7ed3\u675f\u65f6\u95f4\u4e3a[%s]\u7684\u6570\u636e\uff0c ", startingDate.toString()));
        return i;
    }

    private void disposePartData(List<Object> procInstIds) {
        DeleteServiceHelper.delete((String)"wf_hiactinst", (QFilter[])new QFilter[]{new QFilter("processInstanceId", "in", procInstIds)});
    }

    private Map<String, Object> getTaskParam() {
        Date startingDate = null;
        QFilter selectValueFilter = new QFilter("key", "=", (Object)KEY_DELETEFINISHHIACTINST);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject value = QueryServiceHelper.queryOne((String)WFCONFCENTER, (String)VALUE, (QFilter[])selectValueFilters);
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        if (value == null) {
            params.put(VALUE_RETENTIONTIME, 30);
            params.put(VALUE_LIMITQUANTITY, 200000);
            params.put(VALUE_STEPLIMITQUANTITY, 5000);
            params.put(VALUE_STEPLENGTH, 3);
        } else {
            params.putAll((Map)SerializationUtils.fromJsonString((String)value.get(VALUE).toString(), Map.class));
            params.putIfAbsent(VALUE_RETENTIONTIME, 30);
            params.putIfAbsent(VALUE_LIMITQUANTITY, 200000);
            params.putIfAbsent(VALUE_STEPLIMITQUANTITY, 5000);
            params.putIfAbsent(VALUE_STEPLENGTH, 3);
            log.debug(String.format("%s_%s \u5bf9\u5e94\u53c2\u6570\uff1a%s", WFCONFCENTER, KEY_DELETEFINISHHIACTINST, ((Object)params).toString()));
        }
        int retentionTime = (Integer)params.get(VALUE_RETENTIONTIME);
        Date maxCleanDate = this.getTargetTime(WfUtils.now(), -retentionTime);
        params.put(VALUE_MAXCLEANDATE, maxCleanDate);
        if (params.get(VALUE_STARTINGTIME) != null) {
            startingDate = new Date((Long)params.get(VALUE_STARTINGTIME));
        } else {
            startingDate = this.getStartingDate(maxCleanDate);
            if (startingDate == null) {
                log.debug("\u5220\u9664\u4e1a\u52a1\u6d41\u5df2\u7ed3\u675f\u7684\u6d3b\u52a8\u5b9e\u4f8b\u6570\u636eTask\u7b2c\u4e00\u6b21\u6267\u884c\u67e5\u8be2\u8d77\u59cb\u65e5\u671f\uff0c\u6ca1\u6709\u8bb0\u5f55\uff0c\u8c03\u5ea6\u7ed3\u675f ");
                return null;
            }
            log.debug(String.format("\u5220\u9664\u4e1a\u52a1\u6d41\u5df2\u7ed3\u675f\u7684\u6d3b\u52a8\u5b9e\u4f8b\u6570\u636eTask\u7b2c\u4e00\u6b21\u6267\u884c\u67e5\u5230\u7684\u8d77\u59cb\u65e5\u671f\uff0c startingDate :%s ", startingDate.toString()));
        }
        params.put(VALUE_STARTINGDATE, startingDate);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveParams(Map<String, Object> params) {
        params.remove(VALUE_MAXCLEANDATE);
        Date startingDate = (Date)params.remove(VALUE_STARTINGDATE);
        Long startingTiming = startingDate.getTime();
        params.put(VALUE_STARTINGTIME, startingTiming);
        try (TXHandle handle = TX.requiresNew();){
            QFilter selectValueFilter = new QFilter("key", "=", (Object)KEY_DELETEFINISHHIACTINST);
            QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
            DynamicObject value = BusinessDataServiceHelper.loadSingle((String)WFCONFCENTER, (String)"id,value", (QFilter[])selectValueFilters);
            if (value == null) {
                value = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WFCONFCENTER));
                value.set("key", (Object)KEY_DELETEFINISHHIACTINST);
            }
            value.set(VALUE, (Object)JSONObject.toJSONString(params));
            DynamicObject[] dynObjs = new DynamicObject[]{value};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    private Date getStartingDate(Date maxDeleteDate) {
        String orderBys = String.format("%s asc", "endTime");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("endTime", "<=", (Object)maxDeleteDate));
        filters.add(new QFilter("processtype", "=", (Object)ProcessType.BizFlow.name()));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DefaultRegularTimeCleaner.getRealStartingDate", (String)"wf_hiprocinst", (String)"endTime", (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)1);){
            if (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                Date date = row.getDate("endTime");
                return date;
            }
        }
        return null;
    }

    private Date getTargetTime(Date dateTime, int scope) {
        Calendar c = Calendar.getInstance();
        c.setTime(dateTime);
        c.add(5, scope);
        return c.getTime();
    }
}

