/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;

public class DeleteTimerJobTask
extends AbstractTask {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String KEY_DELETECLOSEDJOB = "workflow.schedule.DeleteJobDatasTask";
    private static final String FINISHPRO_JOBS_LIMIT = "finishProJobsLimit";
    private static final String TIMINGJOBS_LIMIT = "timingJobsLimit";
    private static final String JOB_HANDLER_TYPES = "jobHandlerTypes";
    private static final String DELJOB_SINCEDATE = "delJobSinceDate";
    private static final String TIMINGJOBS_DELDAYS = "timingJobsDelDays";
    private static final String WFCONFCENTER = "wf_confcenter";
    private static final String DELJOBTASK_START_PROCINSTID = "delJobtaskStartProcinstId";
    private static final String DELJOBTASK_START_JOBID = "delJobtaskStartJobId";
    private static final String DELJOBTASK_START_TIMEVALUE = "delJobtaskStartTimeValue";
    private static final String DELJOBTASK_RETENTION = "delJobtaskRetention";
    private static final String ENDTIME = "endtime";
    private static final String VALUE = "value";
    private Long nextStartDeleteIndex = null;

    public void execute(RequestContext ctx, Map<String, Object> param) throws KDException {
        this.log.debug(String.format("key:[%s]\uff0c\u6e05\u7406Job\u8c03\u5ea6\u5f00\u59cb\uff01\u8868\u540d\uff1aT_WF_JOBRECORD", KEY_DELETECLOSEDJOB));
        int finishProJobsLimit = 1000;
        int timingJobslimit = 10000;
        String jobHandlerTypes = "async-timing";
        Date delJobSinceDate = null;
        int timingJobsDelDays = 15;
        if (param != null && !param.isEmpty()) {
            if (param.get(FINISHPRO_JOBS_LIMIT) != null) {
                finishProJobsLimit = Integer.parseInt(param.get(FINISHPRO_JOBS_LIMIT).toString());
            }
            if (param.get(TIMINGJOBS_LIMIT) != null) {
                timingJobslimit = Integer.parseInt(param.get(TIMINGJOBS_LIMIT).toString());
            }
            if (param.get(JOB_HANDLER_TYPES) != null) {
                jobHandlerTypes = param.get(JOB_HANDLER_TYPES).toString();
            }
            if (param.get(DELJOB_SINCEDATE) != null) {
                String delJobSinceDateStr = param.get(DELJOB_SINCEDATE).toString();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    delJobSinceDate = dateFormat.parse(delJobSinceDateStr);
                }
                catch (ParseException e) {
                    this.log.debug(String.format("\u8c03\u5ea6key[%s],delJobSinceDate\u53c2\u6570\u683c\u5f0f\u8f93\u5165\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a yyyy-MM-dd\uff01 %s", KEY_DELETECLOSEDJOB, WfUtils.getExceptionStacktrace((Throwable)e)));
                    return;
                }
            }
            if (param.get(TIMINGJOBS_DELDAYS) != null) {
                timingJobsDelDays = Integer.parseInt(param.get(TIMINGJOBS_DELDAYS).toString());
            }
        }
        this.log.debug(String.format("key:[%s]\uff0c\u8c03\u5ea6\u8f93\u5165\u53c2\u6570\uff1a[%s]", KEY_DELETECLOSEDJOB, param));
        this.deleteTimingJobs(timingJobslimit, jobHandlerTypes, timingJobsDelDays);
        this.log.debug(String.format("key:[%s]\uff0c\u6e05\u7406[%s]\u5904\u7406\u7c7b\u578b\u7684jobrecord\u6570\u636e\u6210\u529f\uff01\u8868\u540d\uff1aT_WF_JOBRECORD", KEY_DELETECLOSEDJOB, jobHandlerTypes));
        if (WfConfigurationUtil.isDirectlyClearJob()) {
            this.deletefinishProJobs(finishProJobsLimit, delJobSinceDate);
            this.log.debug(String.format("key:[%s]\uff0c\u6df1\u5ea6\u6e05\u7406jobrecord\u548cevtjob\u6570\u636e\u6210\u529f\uff01", KEY_DELETECLOSEDJOB));
        }
    }

    private void deleteTimingJobs(int timingJobslimit, String jobHandlerTypes, int timingJobsDelDays) {
        String[] jobHandlerArray = jobHandlerTypes.split(",");
        Object startDeleteIndexObj = WfConfigurationUtil.getConfigCenterVal((String)DELJOBTASK_START_JOBID);
        Long startDeleteIndex = startDeleteIndexObj != null ? Long.parseLong(startDeleteIndexObj.toString()) : 0L;
        String[] states = new String[]{JobStateEnum.COMPLETED.getNumber(), JobStateEnum.ERRORED.getNumber()};
        Object startDeleteDateObj = WfConfigurationUtil.getConfigCenterVal((String)DELJOBTASK_START_TIMEVALUE);
        Object retention = WfConfigurationUtil.getConfigCenterVal((String)DELJOBTASK_RETENTION);
        Date maxLastLockexptime = null;
        if (retention == null) {
            maxLastLockexptime = this.getTargetTime(WfUtils.now().getTime(), -365);
        } else {
            String retentionStr = String.valueOf(retention);
            maxLastLockexptime = this.getTargetTime(WfUtils.now().getTime(), -Integer.parseInt(retentionStr));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("id", ">", (Object)startDeleteIndex));
        filters.add(new QFilter("state", "in", (Object)states));
        if (!"all".equals(jobHandlerTypes)) {
            filters.add(new QFilter("jobHandlerType", "in", (Object)jobHandlerArray));
        }
        if (startDeleteDateObj != null) {
            Long startDeleteTimeValue = Long.parseLong(startDeleteDateObj.toString());
            Date lastLockexptime = this.getTargetTime(startDeleteTimeValue, timingJobsDelDays);
            if (lastLockexptime.before(maxLastLockexptime)) {
                maxLastLockexptime = lastLockexptime;
            } else {
                return;
            }
        }
        filters.add(new QFilter("lockExpirationTime", "<=", (Object)maxLastLockexptime));
        String selectFields = String.format("%s,%s", "id", "lockExpirationTime");
        ArrayList<Object> jobIds = new ArrayList<Object>(10);
        Date lastDeleteDate = null;
        Long limitDeleteIndex = null;
        boolean isEmpty = true;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"wf_jobrecord.deleteTimingJobs", (String)"wf_job", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)String.format("%s asc", "id"), (int)timingJobslimit);){
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                isEmpty = false;
                Row row = (Row)iterator.next();
                Long id = row.getLong("id");
                jobIds.add(id);
                if (jobIds.size() >= 2000) {
                    this.executeTimingJobBatchDelete(jobIds);
                    jobIds.clear();
                }
                lastDeleteDate = row.getDate("lockExpirationTime");
                limitDeleteIndex = id;
            }
        }
        if (isEmpty) {
            this.log.debug(String.format("key:[%s]\uff0c\u6e05\u7406TimingJob\uff0c\u6ca1\u6709\u67e5\u8be2\u5230[%s]\u5904\u7406\u7c7b\u578b\u7684\u6570\u636e\uff01\u8868\u540d\uff1aT_WF_JOBRECORD", KEY_DELETECLOSEDJOB, jobHandlerTypes));
            return;
        }
        this.executeTimingJobBatchDelete(jobIds);
        this.updateConfCenterValue(DELJOBTASK_START_JOBID, limitDeleteIndex);
        this.updateConfCenterValue(DELJOBTASK_START_TIMEVALUE, lastDeleteDate != null ? lastDeleteDate.getTime() : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTimingJobBatchDelete(List<Object> jobIds) {
        try (TXHandle handle = TX.requiresNew();){
            String sql = "DELETE FROM T_WF_JOBRECORD WHERE FID IN (?);";
            WfDBUtils.executeBatchDeleteByIn((String)sql, jobIds, (Integer)500, (boolean)true);
            this.log.debug(String.format("key:[%s]\uff0c\u6e05\u7406TimingJob\uff0c\u6267\u884c\u67e5\u8be2\u540e\u7684\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1aT_WF_JOBRECORD", KEY_DELETECLOSEDJOB));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletefinishProJobs(int finishProJobsLimit, Date delJobSinceDate) {
        List<Object> bksQueryResultList = this.getFinishedProcBusinissKeys(finishProJobsLimit, delJobSinceDate);
        if (WfUtils.isEmptyForCollection(bksQueryResultList)) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            String sql = "DELETE FROM T_WF_EVTLOG WHERE FBUSINESSKEY in (?);";
            WfDBUtils.executeBatchDeleteByIn((String)sql, bksQueryResultList, (Integer)500, (boolean)true);
            this.log.debug(String.format("key:[%s]\uff0c\u6e05\u7406closedJob\uff0c\u6267\u884c\u67e5\u8be2\u540e\u7684\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_evtlog", KEY_DELETECLOSEDJOB));
            sql = "DELETE FROM T_WF_JOBRECORD WHERE FBUSINESSKEY in (?) AND FSTATE IN ('" + JobStateEnum.COMPLETED.getNumber() + "','" + JobStateEnum.ERRORED.getNumber() + "');";
            WfDBUtils.executeBatchDeleteByIn((String)sql, bksQueryResultList, (Integer)500, (boolean)true);
            this.log.debug(String.format("key:[%s]\uff0c\u6e05\u7406closedJob\uff0c\u6267\u884c\u67e5\u8be2\u540e\u7684\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_jobrecord", KEY_DELETECLOSEDJOB));
            this.updateConfCenterValue(DELJOBTASK_START_PROCINSTID, this.nextStartDeleteIndex);
        }
    }

    private List<Object> getFinishedProcBusinissKeys(int finishProJobsLimit, Date delJobSinceDate) {
        String selectFields = String.format("%s,%s", "businessKey", "id");
        Object startDeleteIndexObj = WfConfigurationUtil.getConfigCenterVal((String)DELJOBTASK_START_PROCINSTID);
        Long startDeleteIndex = startDeleteIndexObj != null ? Long.parseLong(startDeleteIndexObj.toString()) : 0L;
        QFilter[] filters = null;
        filters = WfUtils.isEmpty((Long)startDeleteIndex) && delJobSinceDate != null ? new QFilter[]{new QFilter(ENDTIME, "is not null", null), new QFilter(ENDTIME, ">", (Object)delJobSinceDate)} : new QFilter[]{new QFilter(ENDTIME, "is not null", null), new QFilter("id", ">", (Object)startDeleteIndex)};
        DynamicObjectCollection queryResults = QueryServiceHelper.query((String)"wf_historicalprocesses", (String)selectFields, (QFilter[])filters, (String)String.format("%s asc", "id"), (int)finishProJobsLimit);
        if (null == queryResults || queryResults.isEmpty()) {
            return new ArrayList<Object>(0);
        }
        HashSet<String> businessKeySet = new HashSet<String>(queryResults.size());
        for (DynamicObject ret : queryResults) {
            businessKeySet.add(ret.getString("businessKey"));
        }
        DynamicObject lastDyn = (DynamicObject)queryResults.get(queryResults.size() - 1);
        this.nextStartDeleteIndex = lastDyn.getLong("id");
        QFilter filter02 = new QFilter("businessKey", "in", businessKeySet);
        QFilter filter12 = new QFilter(ENDTIME, "is null", null);
        QFilter[] filters2 = new QFilter[]{filter02, filter12};
        DynamicObjectCollection idsRemove = QueryServiceHelper.query((String)"wf_historicalprocesses", (String)"businessKey", (QFilter[])filters2);
        HashSet<String> idsReSet = new HashSet<String>(idsRemove.size());
        for (DynamicObject dynamicObject : idsRemove) {
            String businessKey = dynamicObject.getString("businessKey");
            idsReSet.add(businessKey);
        }
        Iterator idsIterator = businessKeySet.iterator();
        if (!idsReSet.isEmpty()) {
            while (idsIterator.hasNext()) {
                String businessKey = (String)idsIterator.next();
                if (!idsReSet.contains(businessKey)) continue;
                idsIterator.remove();
            }
        }
        return new ArrayList<Object>(businessKeySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfCenterValue(String key, Object value) {
        try (TXHandle handle = TX.requiresNew();){
            QFilter selectValueFilter = new QFilter("key", "=", (Object)key);
            QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
            DynamicObject dnyObj = BusinessDataServiceHelper.loadSingle((String)WFCONFCENTER, (String)"id,value", (QFilter[])selectValueFilters);
            if (dnyObj == null) {
                dnyObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WFCONFCENTER));
                dnyObj.set("key", (Object)key);
            }
            dnyObj.set(VALUE, value);
            DynamicObject[] dynObjs = new DynamicObject[]{dnyObj};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    private Date getTargetTime(Long time, int scope) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.add(6, scope);
        return c.getTime();
    }
}

