/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.task;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.support.model.HistoryRepairTaskParam;
import kd.bos.workflow.support.model.HistoryRepairTaskResult;
import kd.bos.workflow.support.model.RepairTaskState;
import kd.bos.workflow.support.task.RecordRepeatUserNameScheduleTask;
import org.apache.commons.lang.ArrayUtils;

public class HistoryRepairTaskScheduleTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(HistoryRepairTaskScheduleTask.class);
    private static final String WF_REPAIRTASK = "wf_repairtask";
    private static final String WF_REPAIRLOG = "wf_repairlog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        log.debug("starting HistoryRepairTaskScheduleTask");
        RecordRepeatUserNameScheduleTask task = new RecordRepeatUserNameScheduleTask();
        task.execute(arg0, arg1);
        if (!ProcessEngines.isInitialized()) {
            return;
        }
        if (WfUtils.isNotEmpty((String)WfCacheHelper.getRepairTaskCache())) {
            log.debug("HistoryRepairTaskScheduleTask inCache return");
            return;
        }
        int limitSize = 10;
        try {
            Object sizeValue = WfConfigurationUtil.getConfigCenterVal((String)"support.history.repairTaskStep");
            if (WfUtils.isNotEmptyString((Object)sizeValue) && (limitSize = Integer.parseInt(sizeValue.toString())) > 10) {
                limitSize = 10;
            }
        }
        catch (Exception e) {
            log.debug("HistoryRepairTaskScheduleTask get limitSize from confcenter error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        QFilter qf1 = new QFilter("state", "in", Arrays.asList("TOHANDLE", "RUNNING"));
        QFilter qf2 = new QFilter("retry", "<", (Object)3);
        QFilter qf3 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        String selectFields = "id,number,name,businessobj,state,limitsize,times,startdate,enddate,retry,params,priority,enable";
        DynamicObject[] retList = BusinessDataServiceHelper.load((String)WF_REPAIRTASK, (String)selectFields, (QFilter[])new QFilter[]{qf1, qf2, qf3}, (String)"priority desc", (int)limitSize);
        ArrayList<Object[]> errorInfos = new ArrayList<Object[]>();
        if (retList != null) {
            try {
                WfCacheHelper.putRepairTaskCache();
                for (DynamicObject entity : retList) {
                    log.debug("the number of repairTask is:" + entity.get("number"));
                    try {
                        String bizObj = entity.getString("businessobj");
                        if (!WfUtils.isNotEmpty((String)bizObj)) continue;
                        HistoryRepairTaskParam input = new HistoryRepairTaskParam();
                        input.setLimitSize(entity.getInt("limitsize"));
                        input.setTimes(entity.getInt("times"));
                        if (WfUtils.isNotEmpty((String)entity.getString("params"))) {
                            Map valueMap = (Map)SerializationUtils.fromJsonString((String)entity.getString("params"), Map.class);
                            input.setRequire(valueMap);
                        }
                        if (entity.getDate("startdate") == null) {
                            entity.set("startdate", (Object)new Date());
                        }
                        log.debug("repairTask startTime" + new Date());
                        Object ret = ReflectUtil.invoke((Object)TypesContainer.createInstance((String)bizObj), (String)"execute", (Object[])new Object[]{input});
                        log.debug("repairTask endTime" + new Date());
                        if (ret != null) {
                            HistoryRepairTaskResult output = (HistoryRepairTaskResult)ret;
                            RepairTaskState state = output.getState();
                            if (RepairTaskState.FINISHED == state) {
                                entity.set("enddate", (Object)new Date());
                            } else {
                                entity.set("enddate", null);
                            }
                            entity.set("state", (Object)output.getState().toString());
                            if (RepairTaskState.ERRORED == state) continue;
                            entity.set("retry", (Object)0);
                            if (output.getRequire() == null) continue;
                            entity.set("params", (Object)SerializationUtils.toJsonString(output.getRequire()));
                            continue;
                        }
                        log.debug("HistoryRepairTaskScheduleTask result is null from " + bizObj);
                    }
                    catch (Exception e) {
                        String msg = null;
                        msg = e instanceof WFEngineException && ((WFEngineException)e).getCause() instanceof InvocationTargetException ? WfUtils.getExceptionStacktrace((Throwable)((InvocationTargetException)((WFEngineException)e).getCause()).getTargetException()) : WfUtils.getExceptionStacktrace((Throwable)e);
                        int retry = entity.getInt("retry");
                        if (retry > 1) {
                            entity.set("state", (Object)RepairTaskState.ERRORED.toString());
                        } else {
                            entity.set("state", (Object)RepairTaskState.RUNNING.toString());
                        }
                        entity.set("retry", (Object)(retry + 1));
                        errorInfos.add(new Object[]{entity.getPkValue(), entity.getString("number"), entity.getString("name"), WfUtils.subStringForMax((String)msg, (int)2000), new Date()});
                    }
                }
            }
            catch (Exception e1) {
                log.debug("HistoryRepairTaskScheduleTask error:" + WfUtils.getExceptionStacktrace((Throwable)e1));
            }
            finally {
                this.updateTasks(retList, errorInfos);
                WfCacheHelper.removeRepairTaskCache();
            }
        }
    }

    private void updateTasks(DynamicObject[] tasks, List<Object[]> errorInfos) {
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])tasks);
            if (WfUtils.isNotEmptyForCollection(errorInfos)) {
                long[] ids = ORM.create().genLongIds(WF_REPAIRLOG, errorInfos.size());
                ArrayList<Object[]> inputs = new ArrayList<Object[]>(8);
                int i = 0;
                for (long id : ids) {
                    inputs.add(ArrayUtils.addAll((Object[])new Object[]{id}, (Object[])errorInfos.get(i)));
                    ++i;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("insert into t_wf_repairlog(fid,ftaskid,fnumber,fname,fexceptionmsg,fcreatedate) values (?,?,?,?,?,?);");
                WfDBUtils.executeBatch((String)sb.toString(), inputs, (Integer)10);
            }
        }
    }
}

