/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.task;

import com.google.common.base.Charsets;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class RecordRepeatUserNameScheduleTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(RecordRepeatUserNameScheduleTask.class);
    private static Integer defaultExpectedInsertions = 10000000;
    private static Double defaultFpp = 0.01;

    public void execute() {
        this.execute(null, null);
    }

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        log.debug("Starting recordRepeatUserName");
        Long beginTime = System.currentTimeMillis();
        DynamicObject obj = this.getLatestUserId("value");
        String updateDateStr = null == obj ? null : obj.getString("value");
        this.recordRepeatUserName(updateDateStr);
        Long cost = System.currentTimeMillis() - beginTime;
        log.debug("Ending recordRepeatUserName and cost: " + cost + "ms");
    }

    public void updateLatestUserId(String userId) {
        Long id;
        String sql;
        DynamicObject obj = this.getLatestUserId("id");
        if (obj != null) {
            sql = "update t_wf_confcenter set fvalue = ? where fid = ?";
            id = obj.getLong("id");
        } else {
            sql = "insert into t_wf_confcenter (fvalue, fid, ftype, fkey) values (?, ?, 'global', 'recordRepeatUserNameByLatestUserId')";
            id = DBServiceHelper.genGlobalLongId();
        }
        DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{userId, id});
    }

    private void recordRepeatUserName(String lastUserIdStr) {
        boolean exist;
        int limit = 5000;
        if (WfUtils.isNotEmpty((String)lastUserIdStr) && !(exist = QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)Long.parseLong(lastUserIdStr))}))) {
            return;
        }
        Object[] sqlParams = null;
        String trueName = null;
        BloomFilter bloomFilterForUser = null;
        BloomFilter bloomFilterForUserRepeat = null;
        String batchSql = "insert into t_wf_secuserrepeat (fpkid, flocaleid, ftruename) values (?,?,?)";
        ArrayList<Object[]> insertParamsList = null;
        Object[] insertParamsObj = null;
        Lang[] langs = WfMultiLangUtils.getSupportLangs();
        String sql = null;
        Long lastUserId = null;
        boolean isUpdate = false;
        for (Lang lang : langs) {
            bloomFilterForUser = this.getBloomFilterForUser();
            bloomFilterForUserRepeat = this.getBloomFilterForUserRepeat();
            this.loadBloomFilterForRepeat(lang, (BloomFilter<String>)bloomFilterForUserRepeat);
            int index = 0;
            int loopCount = 0;
            sqlParams = new Object[]{lang};
            while (loopCount < 10000) {
                ++loopCount;
                insertParamsList = new ArrayList<Object[]>(500);
                sql = "select top " + limit + "," + index + " flocaleid, fid, ftruename from t_sec_user_l where flocaleid = ?";
                try (DataSet ds = DB.queryDataSet((String)"recordRepeatUserName", (DBRoute)DBRoute.main, (String)sql, (Object[])sqlParams);){
                    if (null == ds || ds.isEmpty()) break;
                    Iterator iter = ds.iterator();
                    Row row = null;
                    while (iter.hasNext()) {
                        row = (Row)iter.next();
                        lastUserId = row.getLong("fid");
                        trueName = row.getString("ftruename");
                        if (null == trueName || trueName.isEmpty() || bloomFilterForUserRepeat.mightContain((Object)trueName)) continue;
                        if (!bloomFilterForUser.mightContain((Object)trueName)) {
                            bloomFilterForUser.put((Object)trueName);
                            continue;
                        }
                        bloomFilterForUserRepeat.put((Object)trueName);
                        insertParamsObj = new Object[]{DBServiceHelper.genStringId(), row.getString("flocaleid"), row.getString("ftruename")};
                        insertParamsList.add(insertParamsObj);
                        if (500 != insertParamsList.size()) continue;
                        isUpdate = true;
                        WfDBUtils.executeBatch((String)batchSql, insertParamsList, (Integer)500);
                        insertParamsList = new ArrayList(500);
                    }
                }
                catch (Exception e) {
                    log.debug("RecordRepeatUserNameScheduleTask getBloomFilterForRepeat exception is " + WfUtils.getExceptionStacktrace((Throwable)e));
                    break;
                }
                index += limit;
                if (insertParamsList.isEmpty()) continue;
                isUpdate = true;
                try {
                    WfDBUtils.executeBatch((String)batchSql, insertParamsList, (Integer)500);
                }
                catch (Exception e) {
                    log.debug("RecordRepeatUserNameScheduleTask getBloomFilterForRepeat exception is " + WfUtils.getExceptionStacktrace((Throwable)e));
                }
                insertParamsList.clear();
            }
            bloomFilterForUserRepeat = null;
            bloomFilterForUser = null;
        }
        if (null != lastUserId && isUpdate && WfUtils.isNotEmpty(lastUserId)) {
            this.updateLatestUserId(lastUserId.toString());
        }
    }

    private void loadBloomFilterForRepeat(Lang lang, BloomFilter<String> bloomFilterForUserRepeat) {
        String sql = "select ftruename from t_wf_secuserrepeat where flocaleid = ?";
        Object[] params = new Object[]{lang};
        String trueName = null;
        try (DataSet ds = DB.queryDataSet((String)"getBloomFilterForRepeat", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            if (null == ds || ds.isEmpty()) {
                return;
            }
            Iterator iter = ds.iterator();
            Row row = null;
            while (iter.hasNext()) {
                row = (Row)iter.next();
                trueName = row.getString("ftruename");
                if (WfUtils.isEmpty((String)trueName)) continue;
                bloomFilterForUserRepeat.put((Object)trueName);
            }
        }
        catch (Exception e) {
            log.debug("RecordRepeatUserNameScheduleTask getBloomFilterForRepeat exception is " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private BloomFilter getBloomFilterForUser() {
        return this.getBloomFilter(5000000, 0.01);
    }

    private BloomFilter getBloomFilterForUserRepeat() {
        return this.getBloomFilter(1000000, 0.01);
    }

    private BloomFilter getBloomFilter(Integer expectedInsertions, Double fpp) {
        if (null == expectedInsertions) {
            expectedInsertions = defaultExpectedInsertions;
        }
        if (null == fpp) {
            fpp = defaultFpp;
        }
        return BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.UTF_8), (int)expectedInsertions, (double)fpp);
    }

    private DynamicObject getLatestUserId(String selectFields) {
        QFilter filter = new QFilter("key", "=", (Object)"recordRepeatUserNameByLatestUserId");
        QFilter filter2 = new QFilter("type", "=", (Object)"global");
        return QueryServiceHelper.queryOne((String)"wf_confcenter", (String)selectFields, (QFilter[])new QFilter[]{filter, filter2});
    }
}

