/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.support.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class WfSupportUtil {
    private static final String CONF_KEY = "key";
    private static final String CONF_VALUE = "value";
    private static final String CONF_TYPE = "type";
    private static final String CONF_DESCRIPTION = "description";
    private static final String SELECT_FIELD = "id,key,value,type,description";
    private static final String WF_CONFCENTER = "wf_confcenter";
    public static final String WF_CONF_REAL_KEY = "workflow.isCompleteRepairApproveDuration";

    private WfSupportUtil() {
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(n);
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    public static String getWfConfCenterInfo(String key) {
        DynamicObject valueObj = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter(CONF_KEY, "=", (Object)key)});
        if (valueObj == null) {
            valueObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WF_CONFCENTER));
            valueObj.set(CONF_KEY, (Object)key);
        }
        return null == valueObj.get(CONF_VALUE) ? "" : (String)valueObj.get(CONF_VALUE);
    }

    public static void writeWfConfCenterInfo(String key, String value, String type, String description) {
        DynamicObject valueObj = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter(CONF_KEY, "=", (Object)key)});
        if (valueObj == null) {
            valueObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WF_CONFCENTER));
            valueObj.set(CONF_KEY, (Object)key);
        }
        valueObj.set(CONF_KEY, (Object)key);
        valueObj.set(CONF_VALUE, (Object)value);
        valueObj.set(CONF_TYPE, (Object)type);
        valueObj.set(CONF_DESCRIPTION, (Object)description);
        DynamicObject[] dynObjs = new DynamicObject[]{valueObj};
        SaveServiceHelper.save((DynamicObject[])dynObjs);
    }

    public static String calcDurations(String t1, String t2) {
        String seconds = "";
        if (WfUtils.isEmpty((String)t1) || WfUtils.isEmpty((String)t2)) {
            return seconds;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        try {
            long startTime = sdf.parse(t1).getTime();
            long endTime = sdf.parse(t2).getTime();
            if (endTime > startTime) {
                float f = (float)(endTime - startTime) / 1000.0f;
                DecimalFormat df = new DecimalFormat("0.0");
                seconds = df.format(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return seconds;
    }

    public static String desensitizeIP(String ip) {
        String ret = "";
        try {
            if (WfUtils.isNotEmpty((String)ip)) {
                int first = ip.indexOf(".");
                int last = ip.lastIndexOf(".");
                ret = ip.substring(0, first) + ".*.*." + ip.substring(last + 1, ip.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static void updateWfConfCenterInfo(String type, String key, String value, String desc) {
        QFilter filter = new QFilter(CONF_KEY, "=", (Object)key);
        QFilter filter2 = new QFilter(CONF_TYPE, "=", (Object)type);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)"id,type,key,value,description", (QFilter[])new QFilter[]{filter, filter2});
        if (dynamicObject == null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)WF_CONFCENTER);
            dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            dynamicObject.set(CONF_TYPE, (Object)type);
            dynamicObject.set(CONF_KEY, (Object)key);
            dynamicObject.set(CONF_VALUE, (Object)value);
            dynamicObject.set(CONF_DESCRIPTION, (Object)desc);
        } else {
            dynamicObject.set(CONF_VALUE, (Object)value);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}

