/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.msg.info.ParticipantInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.bos.workflow.task.service.TaskRuntimeService;

public class TestBillPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        this.bizTask(key);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setStatus(OperationStatus.EDIT);
    }

    private void bizTask(String type) {
        TaskRuntimeService taskRuntimeService = TaskRuntimeService.create();
        String result = "";
        if ("create".equals(type)) {
            String billno = (String)this.getModel().getValue("billno");
            QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billno)};
            DynamicObject[] testbills = BusinessDataServiceHelper.load((String)"wf_hrtask", (String)"id, billno", (QFilter[])filters);
            if (testbills == null || testbills.length == 0) {
                this.getView().showErrorNotification("not find entity[" + billno + "]");
                return;
            }
            String pkId = testbills[0].getString("id");
            TaskEntityInfo taskEntityInfo = new TaskEntityInfo();
            String msg = ResManager.loadKDString((String)"HRCS_\u6211\u7684\u4efb\u52a1[{0}]", (String)"TestBillPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[]{billno});
            taskEntityInfo.setName((ILocaleString)new LocaleString(msg));
            String msg2 = ResManager.loadKDString((String)"\u6211\u7684\u4efb\u52a1\u63cf\u8ff0", (String)"TestBillPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]);
            taskEntityInfo.setDescription((ILocaleString)new LocaleString(msg2));
            taskEntityInfo.setNumber("hrcs_activitymodel");
            String msg3 = ResManager.loadKDString((String)"HRCS_\u6211\u7684\u4efb\u52a1-\u4e3b\u9898[{0}]", (String)"TestBillPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[]{billno});
            taskEntityInfo.setSubject((ILocaleString)new LocaleString(msg3));
            taskEntityInfo.setStarterId(Long.valueOf(RequestContext.get().getCurrUserId()));
            taskEntityInfo.setEntityNumber("wf_hrtask");
            taskEntityInfo.setBusinessKey(pkId);
            taskEntityInfo.setBillNo(billno);
            ArrayList<ParticipantInfo> participantInfos = new ArrayList<ParticipantInfo>();
            DynamicObjectCollection participants = (DynamicObjectCollection)this.getModel().getValue("participant");
            for (DynamicObject participant : participants) {
                participantInfos.add(new ParticipantInfo(participant.getDynamicObject("fbasedataid").getLong("id"), 0));
            }
            if (participantInfos.isEmpty()) {
                this.getView().showTipNotification("participant is null");
                return;
            }
            taskEntityInfo.setParticipantInfos(participantInfos);
            taskEntityInfo.setAllowSendTodo(true);
            TaskInfo taskInfo = taskRuntimeService.createBizTask(taskEntityInfo);
            this.getView().showMessage(taskInfo.getId() + "");
        } else if ("complete".equals(type) || "delete".equals(type) || "transfer".equals(type) || "admintransfer".equals(type) || "circulate".equals(type)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long taskId = 0L;
            if (customParams.containsKey("taskId")) {
                taskId = (Long)customParams.get("taskId");
            }
            if (taskId == 0L) {
                String billno = (String)this.getModel().getValue("billno");
                QFilter[] filters = new QFilter[]{new QFilter("subject", "like", (Object)("%" + billno + "%"))};
                DynamicObject[] task = BusinessDataServiceHelper.load((String)"wf_task", (String)"id, subject", (QFilter[])filters);
                if (task == null || task.length == 0) {
                    this.getView().showErrorNotification("not find task[" + billno + "]");
                    return;
                }
                taskId = task[0].getLong("id");
            }
            ArrayList<Long> taskIds = new ArrayList<Long>();
            taskIds.add(taskId);
            ILocaleString opinion = (ILocaleString)this.getModel().getValue("opinion");
            if ("complete".equals(type)) {
                String auditnumber = (String)this.getModel().getValue("auditnumber");
                CompleteOperationParam completeOperationParam = new CompleteOperationParam();
                completeOperationParam.setTaskIds(taskIds);
                completeOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                completeOperationParam.setAuditMessage(opinion.getLocaleValue());
                completeOperationParam.setDecOptionNumber(auditnumber);
                completeOperationParam.setVariables(new HashMap());
                BatchOperateResult batchOperateResult = taskRuntimeService.completeBizTask(completeOperationParam);
                result = SerializationUtils.toJsonString((Object)batchOperateResult);
            } else if ("delete".equals(type)) {
                DeleteOperationParam deleteOperationParam = new DeleteOperationParam();
                deleteOperationParam.setTaskIds(taskIds);
                deleteOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                BatchOperateResult batchOperateResult = taskRuntimeService.deleteBizTask(deleteOperationParam);
                result = SerializationUtils.toJsonString((Object)batchOperateResult);
            } else if ("transfer".equals(type)) {
                DynamicObject transfer = (DynamicObject)this.getModel().getValue("transferid");
                long transferId = transfer.getLong("id");
                TransferOperationParam transferOperationParam = new TransferOperationParam();
                transferOperationParam.setTaskIds(taskIds);
                transferOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                transferOperationParam.setTransfererId(Long.valueOf(transferId));
                transferOperationParam.setTransferOpinion(opinion);
                transferOperationParam.setTransferSubscribe(true);
                BatchOperateResult batchOperateResult = taskRuntimeService.transferBizTask(transferOperationParam);
                result = SerializationUtils.toJsonString((Object)batchOperateResult);
            } else if ("admintransfer".equals(type)) {
                UpdateParticipantParam updateParticipantParam = new UpdateParticipantParam();
                ArrayList<Long> participantIds = new ArrayList<Long>();
                DynamicObjectCollection participants = (DynamicObjectCollection)this.getModel().getValue("participant");
                for (DynamicObject participant : participants) {
                    participantIds.add(participant.getDynamicObject("fbasedataid").getLong("id"));
                }
                updateParticipantParam.setTaskIds(taskIds);
                updateParticipantParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                updateParticipantParam.setTransferOpinion(opinion);
                updateParticipantParam.setParticipantIds(participantIds);
                BatchOperateResult batchOperateResult = taskRuntimeService.updateParticipant(updateParticipantParam);
                result = SerializationUtils.toJsonString((Object)batchOperateResult);
            } else if ("circulate".equals(type)) {
                ArrayList<Long> userIds = new ArrayList<Long>();
                DynamicObjectCollection participants = (DynamicObjectCollection)this.getModel().getValue("participant");
                for (DynamicObject participant : participants) {
                    userIds.add(participant.getDynamicObject("fbasedataid").getLong("id"));
                }
                CirculateOperationParam circulateOperationParam = new CirculateOperationParam();
                circulateOperationParam.setTaskIds(taskIds);
                circulateOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                circulateOperationParam.setCirculateMsg(opinion);
                circulateOperationParam.setCirculateUserIds(userIds);
                BatchOperateResult batchOperateResult = taskRuntimeService.circulateBizTask(circulateOperationParam);
                result = SerializationUtils.toJsonString((Object)batchOperateResult);
            }
            this.getView().showMessage(result);
        }
    }
}

