/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.testcase.model.TestcaseRunningResults;
import kd.bos.workflow.unittest.util.TestingPlanUtil;

public class WorkflowTestcaseResultPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener {
    private static final String RESULTENTITY = "entryentity";
    private static final String CASEID = "caseid";
    private static final String CASENAME = "casename";
    private static final String CASENUMBER = "casenumber";
    private static final String RUNRESULT = "runresult";
    private static final String TESTPLANS = "testplans";
    private static final String SUCCESSPLANS = "successplans";
    private static final String FAILEDPLANS = "failedplans";
    private static final String RUNNINGPLANS = "runningplans";
    private static final String PLANSUCCESSRATE = "plansuccessrate";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String DURATION = "duration";
    private static final String DETAIL = "detail";
    private static final String STATUS = "status";
    private static final String CASECOUNT = "casecount";
    private static final String SUCCESSCOUNT = "successcount";
    private static final String FAILEDCOUNT = "failedcount";
    private static final String ALLSUCCESSRATE = "allsuccessrate";
    private static final String ALLSTARTTIME = "allstarttime";
    private static final String ALLENDTIME = "allendtime";
    private static final String ALLDURATION = "allduration";
    private static final String TIPPANEL = "tippanel";
    private static final String TITLEPANEL = "titlepanel";
    private static final String TOOLBAR = "toolbarap";
    private static final String BTN_REFRESH = "btnrefresh";
    private static final String STATUS_RUNNING = "running";
    private static final String STATUS_FINISHED = "finished";
    private static final String STATUS_NOT_RUNNING = "notrunning";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl(RESULTENTITY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBAR);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initCasesResult();
    }

    private void initCasesResult() {
        List<TestcaseRunningResults> results = TestingPlanUtil.getCaseRunningResults();
        int size = results.size();
        if (size < 1) {
            this.log.debug("\u6ca1\u6709\u67e5\u5230\u6848\u4f8b\u6d4b\u8bd5\u8ba1\u5212\u8fd0\u884c\u6570\u636e\uff01");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TIPPANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TITLEPANEL});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TITLEPANEL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TIPPANEL});
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(RESULTENTITY, size);
        TestcaseRunningResults result = null;
        int successedCases = 0;
        int failedCases = 0;
        long endTime = 0L;
        long startTime = System.currentTimeMillis();
        int running = 0;
        int notRunning = 0;
        for (int i = 0; i < size; ++i) {
            result = results.get(i);
            model.setValue(CASEID, (Object)result.getCaseId(), i);
            model.setValue(CASENAME, (Object)result.getCaseName(), i);
            model.setValue(CASENUMBER, (Object)result.getCaseNumber(), i);
            model.setValue(RUNRESULT, (Object)result.getResult(), i);
            model.setValue(TESTPLANS, (Object)result.getCount(), i);
            model.setValue(SUCCESSPLANS, (Object)result.getSuccessed(), i);
            model.setValue(FAILEDPLANS, (Object)result.getFailed(), i);
            model.setValue(RUNNINGPLANS, (Object)result.getRunning(), i);
            if ("successed".equals(result.getResult())) {
                ++successedCases;
            } else if ("failed".equals(result.getResult())) {
                ++failedCases;
            } else if (STATUS_NOT_RUNNING.equals(result.getResult())) {
                ++notRunning;
            }
            if (result.getCount() == result.getSuccessed() + result.getFailed()) {
                model.setValue(PLANSUCCESSRATE, (Object)result.getRate(), i);
                model.setValue(STARTTIME, (Object)result.getStartTime(), i);
                model.setValue(ENDTIME, (Object)result.getEndTime(), i);
                model.setValue(DURATION, (Object)result.getDuration(), i);
            }
            if (result.getStartTime() != null && result.getStartTime().getTime() < startTime) {
                startTime = result.getStartTime().getTime();
            }
            if (result.getEndTime() != null && result.getEndTime().getTime() > endTime) {
                endTime = result.getEndTime().getTime();
            }
            running += result.getRunning();
        }
        model.setValue(CASECOUNT, (Object)size);
        if (notRunning == size) {
            model.setValue(STATUS, (Object)STATUS_NOT_RUNNING);
            this.clearTitleFileds();
        }
        if (running > 0) {
            model.setValue(STATUS, (Object)STATUS_RUNNING);
            this.clearTitleFileds();
        }
        model.setValue(STATUS, (Object)STATUS_FINISHED);
        model.setValue(SUCCESSCOUNT, (Object)successedCases);
        model.setValue(FAILEDCOUNT, (Object)failedCases);
        model.setValue(ALLSUCCESSRATE, (Object)TestingPlanUtil.getSuccessRate(size, successedCases));
    }

    private void clearTitleFileds() {
        IDataModel model = this.getModel();
        model.setValue(SUCCESSCOUNT, null);
        model.setValue(FAILEDCOUNT, null);
        model.setValue(ALLSUCCESSRATE, null);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_REFRESH.contentEquals(key)) {
            this.getModel().deleteEntryData(RESULTENTITY);
            this.initCasesResult();
        } else {
            super.itemClick(evt);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (DETAIL.equals(evt.getFieldName())) {
            Long caseId = (Long)this.getModel().getValue(CASEID, evt.getRowIndex());
            TestingPlanUtil.openCaseReport(this.getView(), caseId);
        }
    }
}

