/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingCaseEntity;

public class WorkflowTestingCasePlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btnok";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_KEYWORDS = "keywords";
    private static final String FIELD_SCENE = "scene";
    private static final String FIELD_MAINPOINT = "mainpoint";
    private static final String FIELD_TESTPOINT = "testpoint";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    private void init() {
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        if (WfUtils.isNotEmpty((Long)id)) {
            TestingCaseEntity testingCase = (TestingCaseEntity)this.getRepositoryService().findEntityById(id, "wf_cases");
            this.getModel().setValue(FIELD_NAME, (Object)testingCase.getName());
            this.getModel().setValue(FIELD_NUMBER, (Object)testingCase.getNumber());
            this.getModel().setValue(FIELD_KEYWORDS, (Object)testingCase.getKeywords());
            this.getModel().setValue(FIELD_MAINPOINT, (Object)testingCase.getMainpoint());
            this.getModel().setValue(FIELD_SCENE, (Object)testingCase.getScene());
            this.getModel().setValue(FIELD_TESTPOINT, (Object)testingCase.getTestpoint());
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        String result = this.requiredValidate();
        if (result != null) {
            this.getView().showTipNotification(result);
            return;
        }
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        if (WfUtils.isNotEmpty((Long)id)) {
            TestingCaseEntity testingCase = (TestingCaseEntity)this.getRepositoryService().findEntityById(id, "wf_cases");
            IDataModel model = this.getModel();
            testingCase.setName((ILocaleString)model.getValue(FIELD_NAME));
            testingCase.setKeywords((String)model.getValue(FIELD_KEYWORDS));
            testingCase.setScene((String)model.getValue(FIELD_SCENE));
            testingCase.setMainpoint((String)model.getValue(FIELD_MAINPOINT));
            testingCase.setTestpoint((String)model.getValue(FIELD_TESTPOINT));
            this.getRepositoryService().saveOrUpdateEntity((Entity)testingCase);
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6848\u4f8b\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002\u6ca1\u6709\u6848\u4f8bID\u3002", (String)"WorkflowTestingCasePlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private String requiredValidate() {
        LinkedHashMap<String, String> tipMap = new LinkedHashMap<String, String>();
        tipMap.put(FIELD_NAME, ResManager.loadKDString((String)"\u6848\u4f8b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowTestingCasePlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
        tipMap.put(FIELD_KEYWORDS, ResManager.loadKDString((String)"\u573a\u666f\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowTestingCasePlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
        tipMap.put(FIELD_SCENE, ResManager.loadKDString((String)"\u573a\u666f\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowTestingCasePlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
        tipMap.put(FIELD_MAINPOINT, ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u7f6e\u8981\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowTestingCasePlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
        tipMap.put(FIELD_TESTPOINT, ResManager.loadKDString((String)"\u6d4b\u8bd5\u8981\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowTestingCasePlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
        Object value = null;
        for (Map.Entry entry : tipMap.entrySet()) {
            value = entry.getValue();
            if (value != null && (!(value instanceof String) || !WfUtils.isEmpty((String)value))) continue;
            return (String)entry.getValue();
        }
        return null;
    }
}

