/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowTestingDecisionModPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_OK = "btnok";
    private static final String KEY_SCHEME_ID = "scheme_id";
    private static final String KEY_TESTING_DECISIONS = "testingDecisions";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_NODEID = "nodeid";
    private static final String ENTRY_DECISIONS = "decisions";
    private static final String SCHEMEID = "schemeId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, ENTRY_DECISIONS});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String schemeId = (String)parameter.getCustomParam(SCHEMEID);
        String decisions = (String)parameter.getCustomParam(KEY_TESTING_DECISIONS);
        this.getPageCache().put(KEY_SCHEME_ID, schemeId);
        this.initPage(Long.parseLong(schemeId), decisions);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btnok": {
                this.closeWin();
                break;
            }
            case "decisions": {
                this.showVariables();
                break;
            }
        }
    }

    private void initPage(Long schemeId, String decisions) {
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        List elements = bpmnModel.getMainProcess().getFlowElementList();
        if (WfUtils.isNotEmpty((String)decisions)) {
            List listObjectFir = (List)JSONArray.parse((String)decisions);
            int size = listObjectFir.size();
            if (size > 0) {
                IDataModel model = this.getModel();
                model.batchCreateNewEntryRow(ENTRYENTITY, size);
                int i = 0;
                for (Map m : listObjectFir) {
                    model.setValue(ENTRY_NODEID, m.get(ENTRY_NODEID), i);
                    model.setValue(ENTRY_DECISIONS, m.get(ENTRY_DECISIONS), i);
                    ++i;
                }
            }
        } else {
            ArrayList pathItems = new ArrayList();
            ArrayList cycleDecisions = new ArrayList();
            HashMap<String, String> defaultDecision = new HashMap<String, String>();
            defaultDecision.put("cyclenum", "1");
            defaultDecision.put("decisionnum", "Consent");
            defaultDecision.put("bizurl", "");
            cycleDecisions.add(defaultDecision);
            String defaultStr = JSON.toJSONString(cycleDecisions);
            for (FlowElement element : elements) {
                if (!(element instanceof UserTask) || "UserTask".equals(element.getType())) continue;
                HashMap<String, String> m = new HashMap<String, String>();
                m.put(element.getId(), defaultStr);
                pathItems.add(m);
            }
            int totaleSize = pathItems.size();
            if (totaleSize > 0) {
                IDataModel model = this.getModel();
                model.batchCreateNewEntryRow(ENTRYENTITY, totaleSize);
                for (int i = 0; i < pathItems.size(); ++i) {
                    Map item = (Map)pathItems.get(i);
                    Object key = item.keySet().toArray()[0];
                    model.setValue(ENTRY_NODEID, (Object)((String)key), i);
                    model.setValue(ENTRY_DECISIONS, item.get(key), i);
                }
            }
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (FlowElement element : elements) {
            if (!(element instanceof UserTask) || "UserTask".equals(element.getType())) continue;
            items.add(new ComboItem(new LocaleString(element.getName()), element.getId()));
        }
        ComboEdit nodeName = (ComboEdit)this.getControl(ENTRY_NODEID);
        nodeName.setComboItems(items);
    }

    private void closeWin() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        if (datas != null) {
            ArrayList retData = new ArrayList();
            for (DynamicObject data : datas) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put(ENTRY_NODEID, data.getString(ENTRY_NODEID));
                item.put(ENTRY_DECISIONS, data.getString(ENTRY_DECISIONS));
                retData.add(item);
            }
            this.getView().returnDataToParent((Object)JSON.toJSONString(retData));
        }
        this.getView().close();
    }

    private void showVariables() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int focusRow = grid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"WorkflowTestingPlanPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject selectOne = model.getEntryRowEntity(ENTRYENTITY, focusRow);
        String decisions = (String)selectOne.get(ENTRY_DECISIONS);
        String nodeId = (String)selectOne.get(ENTRY_NODEID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingdecision_vars");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTING_DECISIONS));
        parameter.setCustomParam("variables_value", (Object)decisions);
        parameter.setCustomParam(SCHEMEID, this.getView().getFormShowParameter().getCustomParam(SCHEMEID));
        parameter.setCustomParam("nodeId", (Object)nodeId);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "testingDecisions": {
                this.updateVariables(e.getReturnData());
                break;
            }
        }
    }

    private void updateVariables(Object returnData) {
        if (WfUtils.isNotEmptyString((Object)returnData)) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = grid.getEntryState().getFocusRow();
            this.getModel().setValue(ENTRY_DECISIONS, (Object)((String)returnData), focusRow);
        }
    }
}

