/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowTestingDecisionVarsPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btnok";
    private static final String ENTRYENTITY = "variablesentry";
    private static final String ENTRY_CYCLE_NUM = "cyclenum";
    private static final String ENTRY_DECISION_NUM = "decisionnum";
    private static final String ENTRY_BIZ_URL = "bizurl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey().toLowerCase();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String value = (String)parameter.getCustomParam("variables_value");
        String schemeId = (String)parameter.getCustomParam("schemeId");
        String nodeId = (String)parameter.getCustomParam("nodeId");
        this.initDecisionDropdown(Long.parseLong(schemeId), nodeId);
        if (WfUtils.isNotEmpty((String)value)) {
            this.initVariableEntry(value);
        }
    }

    private void initVariableEntry(String value) {
        List listObjectFir = (List)JSONArray.parse((String)value);
        int size = listObjectFir.size();
        if (size > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            int i = 0;
            for (Map m : listObjectFir) {
                model.setValue(ENTRY_CYCLE_NUM, m.get(ENTRY_CYCLE_NUM), i);
                model.setValue(ENTRY_DECISION_NUM, m.get(ENTRY_DECISION_NUM), i);
                model.setValue(ENTRY_BIZ_URL, m.get(ENTRY_BIZ_URL), i);
                ++i;
            }
        }
    }

    private void initDecisionDropdown(Long schemeId, String nodeId) {
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        FlowElement element = bpmnModel.getMainProcess().getFlowElement(nodeId);
        if (element instanceof UserTask) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            List decisions = element.getDecisionOptions();
            if (null != decisions && !decisions.isEmpty()) {
                for (DecisionOption dOption : decisions) {
                    items.add(new ComboItem(new LocaleString(dOption.getName()), dOption.getNumber()));
                }
            }
            ComboEdit decisionNum = (ComboEdit)this.getControl(ENTRY_DECISION_NUM);
            decisionNum.setComboItems(items);
        }
    }

    private void confirm() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        if (datas != null) {
            ArrayList retData = new ArrayList();
            for (DynamicObject data : datas) {
                HashMap<String, String> variable = new HashMap<String, String>();
                variable.put(ENTRY_CYCLE_NUM, data.getString(ENTRY_CYCLE_NUM));
                variable.put(ENTRY_DECISION_NUM, data.getString(ENTRY_DECISION_NUM));
                variable.put(ENTRY_BIZ_URL, data.getString(ENTRY_BIZ_URL));
                retData.add(variable);
            }
            this.getView().returnDataToParent((Object)JSON.toJSONString(retData));
        }
        this.getView().close();
    }
}

