/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.PathItem;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.unittest.util.TestingPlanUtil;

public class WorkflowTestingInputPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_AUTOTEST = "btnautotest";
    private static final String BTN_DECISION = "btndecision";
    private static final String BTN_COPY_BILL = "btncopybill";
    private static final String PANEL_BILL_CONTAINER = "billcontainer";
    private static final String KEY_ENTITYNUMBER = "entitynumber";
    private static final String KEY_BUSINESSKEY = "businesskey";
    private static final String KEY_BILL_PAGEID = "bill_pageId";
    private static final String KEY_SCHEME_ID = "scheme_id";
    private static final String KEY_MODEL_ID = "model_id";
    private static final String KEY_TESTING_DECISIONS = "testingDecisions";
    private static final String KEY_TESTING_DESCRIPTION = "testingDescription";
    private static final String KEY_TESTING_DECISION_MOD = "testing_decision_mod";
    private static final String AUTO_TESTING_KEY = "testing";
    private static final String DISABLE_PREVIOUS_KEY = "disablePrevious";
    private static final String SOURCE_PAGE_WORKFLOW_DESINGER = "workflowDesinger";
    private static final String SOURCE_PAGE_DYNAMIC_SCHEME = "dynamicScheme";
    private static final String KEY_STOP_RUNNING_PLAN = "keystoprunningplan";
    RepositoryService service = this.getRepositoryService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)parameter.getCustomParam("schemeId");
        String modelId = (String)parameter.getCustomParam("modelId");
        this.initPage(schemeId, modelId);
        if (SOURCE_PAGE_DYNAMIC_SCHEME.equals(this.getResourcePageFlag())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_DECISION});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_COPY_BILL});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btnautotest": {
                this.autoTest();
                break;
            }
            case "btncopybill": {
                this.copyBill();
                break;
            }
            case "btndecision": {
                this.showDecisionPage();
                break;
            }
        }
    }

    private void initPage(Long schemeId, String modelId) {
        String entityNumber = "";
        if (null != schemeId) {
            this.getPageCache().put(KEY_SCHEME_ID, schemeId.toString());
            BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
            entityNumber = bpmnModel.getMainProcess().getEntraBill();
        }
        if (null != modelId) {
            this.getPageCache().put(KEY_MODEL_ID, modelId);
            ModelEntity model = (ModelEntity)this.getRepositoryService().getModel(Long.valueOf(Long.parseLong(modelId)));
            entityNumber = model.getEntraBill();
        }
        this.getPageCache().put(KEY_ENTITYNUMBER, entityNumber);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(entityNumber);
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(PANEL_BILL_CONTAINER);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.addCustPlugin("kd.bos.workflow.testcase.plugin.WfHideBillTitilePanelPlugin");
        String appId = WfUtils.getAppIdForEntity((String)entityNumber);
        if (WfUtils.isNotEmpty((String)appId)) {
            parameter.getCustomParams().put("ServiceAppId", appId);
        }
        parameter.setAppId("a479ec06000000ac");
        this.showForm((FormShowParameter)parameter);
        this.getPageCache().put(KEY_BILL_PAGEID, parameter.getPageId());
    }

    private void autoTest() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processdefinition", (String)"1//JGEENPGO0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6a21\u62df\u6d4b\u8bd5\u7684\u6743\u9650\u3002", (String)"WorkflowTestingInputPlugin_11", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        if (SOURCE_PAGE_WORKFLOW_DESINGER.equals(this.getResourcePageFlag()) && this.publishOrUpdateModel()) {
            String modelId = this.getPageCache().get(KEY_MODEL_ID);
            List<TestingPlanEntity> runningPlan = this.findRunningTestingPlans(modelId);
            if (null != runningPlan && !runningPlan.isEmpty()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u7ec8\u6b62\u6b63\u5728\u8fd0\u884c\u7684\u6d4b\u8bd5\u8ba1\u5212\uff1f", (String)"WorkflowTestingInputPlugin_9", (String)"bos-wf-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_STOP_RUNNING_PLAN));
                return;
            }
            this.createTestingPlanAndRun();
        }
        if (SOURCE_PAGE_DYNAMIC_SCHEME.equals(this.getResourcePageFlag())) {
            this.getPageCache().put(KEY_TESTING_DESCRIPTION, ResManager.loadKDString((String)"\u9ed8\u8ba4\u6d4b\u8bd5\u573a\u666f", (String)"WorkflowTestingInputPlugin_10", (String)"bos-wf-unittest", (Object[])new Object[0]));
            this.createTestingPlanAndRun();
        }
    }

    private void copyBill() {
        String pageId = this.getPageCache().get(KEY_BILL_PAGEID);
        IFormView billView = this.getView().getViewNoPlugin(pageId);
        if (null == billView) {
            this.getView().showErrorNotification(WFMultiLangConstants.getBillNotExistTip());
            return;
        }
        String businessKey = this.getPageCache().get(KEY_BUSINESSKEY);
        String entityNumber = this.getPageCache().get(KEY_ENTITYNUMBER);
        if (!WfUtils.exist((String)entityNumber, (Object)businessKey)) {
            this.getView().showErrorNotification(WFMultiLangConstants.getBillNotExistTip());
            return;
        }
        this.invokeBillOperation(pageId, "copy", new HashMap<String, String>());
        this.getPageCache().put(KEY_BILL_PAGEID, billView.getPageId());
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_AUTOTEST});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_COPY_BILL});
        this.getView().updateView();
    }

    private void createTestingPlanAndRun() {
        TestingPlanEntity testingPlan;
        boolean jumpFlag;
        Object businessKey;
        String entityNumber;
        block11: {
            entityNumber = this.getPageCache().get(KEY_ENTITYNUMBER);
            String pageId = this.getPageCache().get(KEY_BILL_PAGEID);
            String schemeId = this.getPageCache().get(KEY_SCHEME_ID);
            String sceneDes = this.getPageCache().get(KEY_TESTING_DESCRIPTION);
            if (WfUtils.isEmptyString((Object)schemeId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u52a8\u6001\u914d\u7f6e\u65b9\u6848\uff0c\u4e0d\u53ef\u6d4b\u8bd5\u3002", (String)"WorkflowTestingInputPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            if (null == pageId) {
                this.getView().showErrorNotification(WFMultiLangConstants.getBillNotExistTip());
                return;
            }
            IFormView billView = this.getView().getViewNoPlugin(pageId);
            if (null == billView) {
                this.getView().showErrorNotification(WFMultiLangConstants.getBillNotExistTip());
                return;
            }
            OperationResult ret = this.invokeBillOperation(pageId, "save", new HashMap<String, String>());
            if (ret == null || ret.getSuccessPkIds().isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WorkflowTestingInputPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return;
            }
            businessKey = ret.getSuccessPkIds().get(0);
            this.getPageCache().put(KEY_BUSINESSKEY, businessKey.toString());
            jumpFlag = false;
            testingPlan = null;
            HashMap<String, String> param = new HashMap<String, String>();
            String paths = this.buildPath(Long.parseLong(schemeId));
            String decisions = this.getPageCache().get(KEY_TESTING_DECISIONS);
            param.put("paths", paths);
            param.put("decisions", decisions);
            param.put("testingplandes", sceneDes);
            try {
                testingPlan = this.service.convertSchemeToCase(Long.valueOf(Long.parseLong(schemeId)), Long.valueOf(Long.parseLong(businessKey.toString())), param);
                if (null != testingPlan) {
                    Long caseId;
                    List planList;
                    if (SOURCE_PAGE_WORKFLOW_DESINGER.equals(this.getResourcePageFlag()) && null != (planList = this.service.getTestingPlanEntitysByTestingCaseId(caseId = testingPlan.getCaseId())) && !planList.isEmpty()) {
                        for (TestingPlanEntity plan : planList) {
                            if (testingPlan.getId().equals(plan.getId()) || plan.isPassed() || !plan.isAutoTest()) continue;
                            this.service.deleteAllTestingPlanRunningDatasByTestingPlanId(plan.getId());
                        }
                    }
                    TestingPlanUtil.runTestingPlan(testingPlan.getId(), false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"WorkflowTestingInputPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
                    jumpFlag = true;
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                this.logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
                if (null == testingPlan) break block11;
                this.service.deleteAllTestingPlanRunningDatasByTestingPlanId(testingPlan.getId());
            }
        }
        if (jumpFlag) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wf_testingplanrecord");
            parameter.setCustomParam("sp", (Object)this.getResourcePageFlag());
            parameter.setCustomParam("withProcess", (Object)true);
            parameter.setCustomParam("testingPlanId", (Object)testingPlan.getId().toString());
            parameter.setClientParam("testingPlanId", (Object)testingPlan.getId().toString());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.showForm(parameter);
            BillShowParameter billparam = new BillShowParameter();
            billparam.setFormId(entityNumber);
            billparam.setShowTitle(false);
            billparam.getOpenStyle().setShowType(ShowType.InContainer);
            billparam.getOpenStyle().setTargetKey(PANEL_BILL_CONTAINER);
            billparam.setPkId(businessKey);
            billparam.addCustPlugin("kd.bos.workflow.testcase.plugin.WfHideBillTitilePanelPlugin");
            String appId = WfUtils.getAppIdForEntity((String)entityNumber);
            if (WfUtils.isNotEmpty((String)appId)) {
                billparam.getCustomParams().put("ServiceAppId", appId);
            }
            billparam.setAppId("a479ec06000000ac");
            this.getView().showForm((FormShowParameter)billparam);
            this.getPageCache().put(KEY_BILL_PAGEID, billparam.getPageId());
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_AUTOTEST});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_COPY_BILL});
            this.getView().updateView();
        }
    }

    private String buildPath(Long schemeId) {
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        ArrayList<PathItem> pathItems = new ArrayList<PathItem>();
        List allNodes = bpmnModel.getMainProcess().getFlowElementList();
        if (null != allNodes && !allNodes.isEmpty()) {
            for (FlowElement element : allNodes) {
                if (null == element) continue;
                HashSet<Boolean> resultSet = new HashSet<Boolean>();
                resultSet.add("UserTask".equals(element.getType()));
                resultSet.add("AuditTask".equals(element.getType()));
                resultSet.add("YunzhijiaTask".equals(element.getType()));
                resultSet.add("SSCApprove".equals(element.getType()));
                resultSet.add("SSCImageUpload".equals(element.getType()));
                resultSet.add("SSCImageUploadNew".equals(element.getType()));
                if (!resultSet.contains(Boolean.TRUE)) continue;
                PathItem item = this.getPathItem(element);
                pathItems.add(item);
            }
        }
        return JSON.toJSONString(pathItems);
    }

    private PathItem getPathItem(FlowElement element) {
        ParticipantModelEntityImpl participantModelEntityImpl;
        List participant;
        PathItem item = new PathItem();
        item.setNodeId(element.getId());
        item.setNodeName(element.getName());
        item.setActivityType(element.getType());
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (null != element.getDecisionOptions() && !element.getDecisionOptions().isEmpty()) {
            if ("UserTask".equals(element.getType())) {
                DecisionOption dOption = (DecisionOption)element.getDecisionOptions().get(0);
                varMap.put("auditNumber", dOption.getNumber());
                varMap.put("auditName", dOption.getName());
            } else {
                String firstApproveOptNum = BpmnModelUtil.getFirstApproveOptNum((FlowElement)element);
                varMap.put("auditNumber", firstApproveOptNum);
                for (Object op : element.getDecisionOptions()) {
                    String dOptionNum = ((DecisionOption)op).getNumber();
                    if (null == firstApproveOptNum || !firstApproveOptNum.equals(dOptionNum)) continue;
                    varMap.put("auditName", ((DecisionOption)op).getName());
                    break;
                }
            }
        }
        item.setVariables(varMap);
        UserTask userTask = (UserTask)element;
        ParticipatantModel participantModel = userTask.getParticipant();
        if (null != participantModel && null != (participant = participantModel.getParticipant()) && !participant.isEmpty() && null != (participantModelEntityImpl = (ParticipantModelEntityImpl)participant.get(0))) {
            List userList;
            Map roleObject;
            String roleId;
            RoleEntity dynObject;
            String personsStr;
            String[] persons;
            DynamicObject dynamicObject = participantModelEntityImpl.getDynamicObject();
            String type = participantModelEntityImpl.getType();
            if ("person".equals(type) && null != (persons = (personsStr = dynamicObject.getString("value")).split(",")) && persons.length > 0) {
                String assigneeId = persons[0];
                item.setAssigneeId(Long.valueOf(Long.parseLong(assigneeId)));
            }
            if ("role".equals(type) && null != (dynObject = (RoleEntity)this.service.findEntityById(Long.valueOf(Long.parseLong(roleId = dynamicObject.getString("roleId"))), "wf_role")) && null != (roleObject = (Map)dynObject.getPersistentState()) && null != (userList = (List)roleObject.get("roleentry")) && !userList.isEmpty()) {
                for (Map userObject : userList) {
                    DynamicObject user = (DynamicObject)userObject.get("user");
                    if (null == user) continue;
                    Long userId = (Long)user.get("id");
                    item.setAssigneeId(userId);
                    break;
                }
            }
        }
        return item;
    }

    private void showDecisionPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingdecision_mod");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTING_DECISION_MOD));
        parameter.setCustomParam("schemeId", (Object)this.getPageCache().get(KEY_SCHEME_ID));
        parameter.setCustomParam(KEY_TESTING_DECISIONS, (Object)this.getPageCache().get(KEY_TESTING_DECISIONS));
        this.getView().showForm(parameter);
    }

    private void showSceneDescriptionPage() {
        String sceneDes = this.getPageCache().get(KEY_TESTING_DESCRIPTION);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingplan_des");
        if (WfUtils.isNotEmpty((String)sceneDes)) {
            parameter.setCustomParam("testingPlanDes", (Object)sceneDes);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTING_DESCRIPTION));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "testing_decision_mod": {
                this.updateDecisions(e.getReturnData());
                break;
            }
            case "testingDescription": {
                this.updateDescription(e.getReturnData());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        switch (evt.getCallBackId()) {
            case "keystoprunningplan": {
                this.stopRunningPlans();
                break;
            }
        }
    }

    private void updateDecisions(Object retData) {
        if (WfUtils.isNotEmptyString((Object)retData)) {
            this.getPageCache().put(KEY_TESTING_DECISIONS, (String)retData);
        }
    }

    private void updateDescription(Object retData) {
        if (null != retData && retData instanceof Map) {
            String des = (String)((Map)retData).get("data");
            this.getPageCache().put(KEY_TESTING_DESCRIPTION, des);
            String op = (String)((Map)retData).get("op");
            if ("ok".equals(op)) {
                this.createTestingPlanAndRun();
            }
        }
    }

    private boolean publishOrUpdateModel() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelId = (String)parameter.getCustomParam("modelId");
        if (modelId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6d41\u7a0b\u3002", (String)"WorkflowTestingInputPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        Long procDefId = this.getTestingProcDefId(Long.parseLong(modelId));
        try {
            if (null == procDefId) {
                if (WfUtils.isNotEmpty((String)modelId)) {
                    ModelEntity model = (ModelEntity)this.service.getModel(Long.valueOf(modelId));
                    if (model.getKey().matches("^\\d+.+")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ee5\u6570\u5b57\u5f00\u5934\u7684\u6d41\u7a0b\u4e0d\u5141\u8bb8\u6d4b\u8bd5\u3002", (String)"WorkflowTestingInputPlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
                        return false;
                    }
                    if (model.isDiscard()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u5e9f\u5f03\uff0c\u8bf7\u6062\u590d\u540e\u518d\u6d4b\u8bd5\u3002", (String)"WorkflowTestingInputPlugin_7", (String)"bos-wf-unittest", (Object[])new Object[0]));
                        return false;
                    }
                    HashMap deploymentProperties = new HashMap();
                    HashMap<String, Boolean> deploymentProperty = new HashMap<String, Boolean>();
                    deploymentProperty.put(DISABLE_PREVIOUS_KEY, false);
                    deploymentProperties.put(modelId, deploymentProperty);
                    HashMap<String, String> testingProperty = new HashMap<String, String>();
                    testingProperty.put(AUTO_TESTING_KEY, AUTO_TESTING_KEY);
                    deploymentProperties.put(AUTO_TESTING_KEY, testingProperty);
                    this.service.publish(new Long[]{model.getId()}, deploymentProperties);
                    procDefId = this.getTestingProcDefId(model.getId());
                }
            } else {
                ResourceEntity resourceEntity = this.service.getResourceByProcDefId(procDefId);
                ModelEntity model = (ModelEntity)this.service.getModel(Long.valueOf(Long.parseLong(modelId)));
                ResourceEntity modelResource = (ResourceEntity)this.service.findEntityById(model.getBPMNXMLID(), "wf_resource");
                resourceEntity.setData(modelResource.getData());
                this.service.saveOrUpdateEntity((Entity)resourceEntity);
                List configSchemes = this.service.getDynamicConfigSchemeEntitysByProcessdefineId(procDefId);
                ManagementService managementService = this.getManagementService();
                if (null != configSchemes && !configSchemes.isEmpty()) {
                    for (DynamicConfigSchemeEntity cs : configSchemes) {
                        managementService.removeBPMNModelCacheByScheme(cs.getId());
                    }
                }
            }
            if (null != procDefId) {
                Long schemeId = this.getDefaultSchemeId(procDefId);
                this.getPageCache().put(KEY_SCHEME_ID, String.valueOf(schemeId));
            }
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u51fa\u9519\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s", (String)"WorkflowTestingInputPlugin_8", (String)"bos-wf-unittest", (Object[])new Object[0]), e.getMessage()));
            return false;
        }
        return true;
    }

    private Long getTestingProcDefId(Long modelId) {
        ProcessDefinitionEntity newestItem;
        Long retId = null;
        if (null == modelId) {
            return retId;
        }
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "=", (Object)modelId), new QFilter("enable", "=", (Object)AUTO_TESTING_KEY)};
        List defList = this.getRepositoryService().findEntitiesByFilters("wf_processdefinition", filters);
        if (null != defList && !defList.isEmpty() && null != (newestItem = (ProcessDefinitionEntity)defList.get(0))) {
            retId = newestItem.getId();
        }
        return retId;
    }

    private Long getDefaultSchemeId(Long procDefId) {
        DynamicConfigSchemeEntity schemeItem;
        Long retId = null;
        if (null == procDefId) {
            return retId;
        }
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        List schemeList = this.getManagementService().getDynamicConfigSchemeByFilters(filters);
        if (null != schemeList && !schemeList.isEmpty() && null != (schemeItem = (DynamicConfigSchemeEntity)schemeList.get(0))) {
            retId = schemeItem.getId();
        }
        return retId;
    }

    private String getResourcePageFlag() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("sp");
    }

    private List<TestingPlanEntity> findRunningTestingPlans(String modelId) {
        List ret = null;
        Long procDefId = this.getTestingProcDefId(Long.parseLong(modelId));
        Long schemeId = this.getDefaultSchemeId(procDefId);
        QFilter[] filters = new QFilter[]{new QFilter("newschemeid", "=", (Object)schemeId), new QFilter("state", "=", (Object)"running")};
        ret = this.service.findEntitiesByFilters("wf_testingplan", filters);
        return ret;
    }

    private void stopRunningPlans() {
        String modelId = this.getPageCache().get(KEY_MODEL_ID);
        List<TestingPlanEntity> runningPlan = this.findRunningTestingPlans(modelId);
        if (null != runningPlan && !runningPlan.isEmpty()) {
            for (TestingPlanEntity plan : runningPlan) {
                plan.setState("failed");
                this.service.saveOrUpdateEntity((Entity)plan);
            }
        }
        this.createTestingPlanAndRun();
    }

    private OperationResult invokeBillOperation(String billPageId, String operation, Map<String, String> variable) {
        String appId = this.getView().getServiceAppId(billPageId);
        this.logger.debug("WorkflowTestingInputPlugin invokeBillOperation : " + operation + "_" + appId);
        if (WfUtils.isEmptyForMap(variable)) {
            variable = new HashMap<String, String>();
        }
        variable.put("WF", "TRUE");
        variable.put(KEY_ENTITYNUMBER, this.getPageCache().get(KEY_ENTITYNUMBER));
        variable.put("ignoreAssignPerson", "true");
        variable.put("ishasright", String.valueOf(Boolean.TRUE));
        Object result = DispatchServiceHelper.invokeBOSService((String)appId, (String)FormService.class.getSimpleName(), (String)"invokeOperationFromService", (Object[])new Object[]{billPageId, operation, variable});
        if (result instanceof Map) {
            Object objectResult;
            Map map = (Map)result;
            try {
                List actionResult = (List)map.get("actionResult");
                if (actionResult != null && actionResult.size() > 0) {
                    HashMap<String, Object> arg = new HashMap<String, Object>();
                    arg.put("pageId", billPageId);
                    arg.put("actions", actionResult);
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("sendDynamicFormAction", arg);
                }
            }
            catch (Exception e) {
                this.logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            }
            String operationResult = (String)map.get("operationResult");
            if (WfUtils.isNotEmpty((String)operationResult) && (objectResult = DataEntitySerializer.deSerializerFromString((String)operationResult, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class))) != null && OperationResult.class.isInstance(objectResult)) {
                return (OperationResult)objectResult;
            }
        }
        return null;
    }
}

