/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.lang.math.RandomUtils;

public class WorkflowTestingPlanBillPlugin
extends AbstractBillPlugIn
implements ClickListener {
    Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String AMOUNT = "amount";
    private static final String REASON = "reason";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "batchadd": {
                this.batchSubmit();
                break;
            }
        }
    }

    private void batchSubmit() {
        try {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"wf_testingplanbill");
            BigDecimal amount = (BigDecimal)this.getModel().getValue(AMOUNT);
            int len = amount.intValue();
            long start = System.currentTimeMillis();
            DynamicObject[] objs = new DynamicObject[len];
            for (int i = 0; i < len; ++i) {
                DynamicObject obj = new DynamicObject((DynamicObjectType)type);
                obj.set("applier", (Object)RequestContext.get().getUserId());
                obj.set("costdept", (Object)RequestContext.get().getOrgId());
                obj.set("applydate", (Object)WfUtils.now());
                int num = RandomUtils.nextInt((int)1000000);
                obj.set("billno", (Object)(i + 1 + "[" + len + "]" + RequestContext.get().getUserId() + "_" + num));
                obj.set(AMOUNT, (Object)num);
                obj.set("applyphone", (Object)num);
                obj.set(REASON, (Object)(num % 2 == 0 ? ResManager.loadKDString((String)"\u81ea\u52a8--\u51fa\u5dee\u62dc\u8bbf\u5ba2\u6237\u3002", (String)"WorkflowTestingPlanBillPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u52a8--\u5ba2\u6237\u9879\u76ee\u652f\u6301\u3002", (String)"WorkflowTestingPlanBillPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0])));
                objs[i] = obj;
            }
            OperationServiceHelper.executeOperate((String)"submit", (String)"wf_testingplanbill", (DynamicObject[])objs, (OperateOption)OperateOption.create());
            long end = System.currentTimeMillis();
            this.getModel().setValue(REASON, (Object)(String.valueOf(this.getModel().getValue(REASON)) + "__" + (end - start)));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW) {
            String userId = RequestContext.get().getUserId();
            this.getModel().setValue("applier", (Object)userId);
            this.getModel().setValue("costdept", (Object)RequestContext.get().getOrgId());
            this.getModel().setValue("applydate", (Object)WfUtils.now());
            int num = RandomUtils.nextInt((int)1000);
            this.getModel().setValue("billno", (Object)(userId + "_" + num));
            this.getModel().setValue(AMOUNT, (Object)num);
            this.getModel().setValue("applyphone", (Object)num);
            this.getModel().setValue(REASON, (Object)(num % 2 == 0 ? ResManager.loadKDString((String)"\u51fa\u5dee\u62dc\u8bbf\u5ba2\u6237\u3002", (String)"WorkflowTestingPlanBillPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba2\u6237\u9879\u76ee\u652f\u6301\u3002", (String)"WorkflowTestingPlanBillPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0])));
        }
        this.logger.debug("\u5355\u636e\u9875\u9762\u52a0\u8f7d\u7ed3\u675f\uff1a" + Calendar.getInstance().getTimeInMillis());
    }
}

