/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowTestingPlanDesPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CLOSE = "btnclose";
    private static final String DES = "des";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CLOSE});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String des = (String)parameter.getCustomParam("testingPlanDes");
        if (WfUtils.isNotEmpty((String)des)) {
            this.getModel().setValue(DES, (Object)des);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey().toLowerCase();
        if (BTN_OK.equals(key)) {
            this.confirm();
        }
        if (BTN_CLOSE.equals(key)) {
            this.closeWin();
        }
    }

    private void closeWin() {
        HashMap<String, String> retData = new HashMap<String, String>();
        retData.put("op", "close");
        retData.put("data", (String)this.getModel().getValue(DES));
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    private void confirm() {
        HashMap<String, String> retData = new HashMap<String, String>();
        retData.put("op", "ok");
        retData.put("data", (String)this.getModel().getValue(DES));
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }
}

