/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowTestingPlanExpPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String INSERTFIELD = "insertfield";
    private static final String VALUEFIELD = "valuefield";
    private static final String CONTENT = "content";
    public static final String NUMBERMAPNAME = "numberMapName";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        if (WfUtils.isEmptyString((Object)entityNumber)) {
            return;
        }
        this.setFieldComboItems(entityNumber);
    }

    private void setFieldComboItems(String entityNumber) {
        MainEntityType entityType;
        HashMap<String, String> numberMapName = new HashMap<String, String>();
        MainEntityType mainType = entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = mainType.getAllFields().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (iter.hasNext()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (!(fieldProp instanceof IFieldHandle) || WfUtils.isNotEmpty((String)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName())) continue;
            if (!(fieldProp instanceof BasedataProp) && !(fieldProp instanceof AttachmentProp)) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
                numberMapName.put(item.getValue(), item.getCaption().toString());
            }
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERTFIELD);
        this.getPageCache().put(NUMBERMAPNAME, SerializationUtils.toJsonString(numberMapName));
        fieldCombo.setComboItems(items);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey().toLowerCase();
        if (BTN_OK.equals(key)) {
            this.confirm();
        }
        if (BTN_CANCEL.equals(key)) {
            this.closeWin();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName().toLowerCase();
        if (propertyName.equals(INSERTFIELD) || propertyName.equals(VALUEFIELD)) {
            if (propertyName.equals(INSERTFIELD)) {
                this.getModel().setValue(VALUEFIELD, (Object)"");
            }
            String content = "";
            Object insertField = this.getModel().getValue(INSERTFIELD);
            Object valueField = this.getModel().getValue(VALUEFIELD);
            if (null != insertField) {
                content = "{" + insertField + "==" + valueField + "}";
            }
            this.getModel().setValue(CONTENT, (Object)content);
        }
    }

    private void confirm() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put(CONTENT, this.getModel().getValue(CONTENT));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void closeWin() {
        this.getView().close();
    }
}

