/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.unittest.util.TestingPlanUtil;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;

public class WorkflowTestingPlanListPlugin
extends AbstractListPlugin {
    protected static Log logger = LogFactory.getLog(WorkflowTestingPlanListPlugin.class);
    private static final String BTN_ADDNEW = "btnaddnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndelete";
    private static final String COLUMN_NUMBER = "number";
    private static final String BTN_RUNTESTPLAN = "runtestingplan";
    private static final String BTN_RUNWITHEXTRACTED = "runwithextracted";
    private static final String BTN_VIEW_TESTINGPLAN_RESULT = "viewtestingplanresult";
    private static final String BTN_SHOWERROR = "btnshowerror";
    private static final String BTN_ABORT = "btnabort";
    private static final String BTN_MARK = "btnmark";
    private static final String KEY_TESTING_PLAN = "testing_plan";
    private static final String CONFIRM_CALLBACK_DELETE = "delete_confirm";
    private static final String CONFIRM_CALLBACK_REPUBLISH = "republish_confirm";
    private static final String OPENED_RECORD_IDS = "record_ids";
    WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "btnaddnew": {
                this.addNew();
                break;
            }
            case "btnedit": {
                this.edit(rows);
                break;
            }
            case "btndelete": {
                this.delete(rows);
                break;
            }
            case "btnmark": {
                this.markPassed(rows);
                break;
            }
            case "btnabort": {
                this.abortRunningPlan(rows);
                break;
            }
            case "runtestingplan": {
                this.runTestingPlan(rows);
                break;
            }
            case "runwithextracted": {
                this.runTestPlanWithExtractedProc(rows);
                break;
            }
            case "viewtestingplanresult": {
                this.viewTestingPlanResult(rows, null);
                break;
            }
            case "btnshowerror": {
                this.showErrorPage(rows);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ABORT, BTN_VIEW_TESTINGPLAN_RESULT, BTN_SHOWERROR});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ABORT, BTN_VIEW_TESTINGPLAN_RESULT, BTN_SHOWERROR});
    }

    private void delete(ListSelectedRowCollection rows) {
        if (null != rows && !rows.isEmpty()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u6d4b\u8bd5\u8ba1\u5212\uff1f", (String)"WorkflowTestingPlanListPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_DELETE));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"WorkflowTestingPlanListPlugin_10", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private void markPassed(ListSelectedRowCollection rows) {
        if (null != rows) {
            for (ListSelectedRow row : rows) {
                Long id = (Long)row.getPrimaryKeyValue();
                if (null == this.checkTestingPlanExist(id, true)) {
                    return;
                }
                BpmnNodeValidateUtil.markTestingPlanPassed((Long)id, null);
            }
        }
    }

    private void abortRunningPlan(ListSelectedRowCollection rows) {
        if (null != rows) {
            for (ListSelectedRow row : rows) {
                Long id = (Long)row.getPrimaryKeyValue();
                if (null == this.checkTestingPlanExist(id, true)) {
                    return;
                }
                BpmnNodeValidateUtil.markTestingPlanTerminated((Long)id);
            }
            ((IListView)this.getView()).refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WorkflowTestingPlanListPlugin_9", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private void viewTestingPlanResult(ListSelectedRowCollection rows, Long pkId) {
        Long testingPlanId = null == pkId ? (Long)rows.get(0).getPrimaryKeyValue() : pkId;
        String ids = this.getPageCache().get(OPENED_RECORD_IDS);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(testingPlanId);
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(idStr);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)testingPlanId)};
        DynamicObject testPlan = QueryServiceHelper.queryOne((String)"wf_testingplan", (String)"newbusinesskey,autotest", (QFilter[])filters);
        if (null == testPlan) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"WorkflowTestingPlanListPlugin_11", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        Object autoTest = testPlan.get("autotest");
        if (null != autoTest && ((Boolean)autoTest).booleanValue()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wf_testingplanrecord");
            parameter.setCustomParam("testingPlanId", (Object)testingPlanId.toString());
            parameter.setClientParam("testingPlanId", (Object)testingPlanId.toString());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
            idsMap.put(idStr, parameter.getPageId());
            this.getPageCache().put(OPENED_RECORD_IDS, SerializationUtils.toJsonString(idsMap));
        } else {
            String businessKey = testPlan.getString("newbusinesskey");
            if (WfUtils.isEmpty((String)businessKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fd0\u884c\u8be5\u6d4b\u8bd5\u8ba1\u5212\u3002", (String)"WorkflowTestingPlanListPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (this.service.getRepositoryService().countHisActivitiInstanceByBusinessKey(businessKey) > 0L) {
                FormShowParameter parameter = new FormShowParameter();
                Object tabView = null;
                parameter.setFormId("wf_testingplanresult");
                parameter.setCustomParam("testingPlanId", (Object)testingPlanId.toString());
                parameter.setClientParam("testingPlanId", (Object)testingPlanId.toString());
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
                idsMap.put(idStr, parameter.getPageId());
                this.getPageCache().put(OPENED_RECORD_IDS, SerializationUtils.toJsonString(idsMap));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u6570\u636e\u8fd8\u672a\u751f\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowTestingPlanListPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        }
    }

    private void showErrorPage(ListSelectedRowCollection rows) {
        if (rows != null) {
            Long planId = (Long)rows.get(0).getPrimaryKeyValue();
            TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.service.getRepositoryService().findEntityById(planId, "wf_testingplan");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("wf_testingplan_error");
            parameter.setCustomParam("testingPlanError", (Object)testingPlanEntity.getErrorInfo());
            this.getView().showForm(parameter);
        }
    }

    private void edit(ListSelectedRowCollection rows) {
        if (this.validateSelectOneItem(rows)) {
            Long id = (Long)rows.get(0).getPrimaryKeyValue();
            this.showTestingPlanPage(id);
        }
    }

    private void addNew() {
        this.showTestingPlanPage(null);
    }

    private void showTestingPlanPage(Long id) {
        FormShowParameter parameter = this.getFormShowParameter(id);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private void runTestingPlan(ListSelectedRowCollection rows) {
        this.runTestingPlan(rows, false);
    }

    private void runTestPlanWithExtractedProc(ListSelectedRowCollection rows) {
        if (this.validateSelectOneItem(rows)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u63d0\u53d6\u65f6\u7684\u6d41\u7a0b\u8fd0\u884c\u6d4b\u8bd5\u8ba1\u5212\u4f1a\u91cd\u65b0\u5bfc\u5165\u63d0\u53d6\u7684\u6d41\u7a0b\u548c\u65b9\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"WorkflowTestingPlanListPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_REPUBLISH));
        }
    }

    private void runTestingPlan(ListSelectedRowCollection rows, boolean republish) {
        try {
            if (null != rows && !rows.isEmpty()) {
                for (ListSelectedRow row : rows) {
                    Long testingPlanId = (Long)row.getPrimaryKeyValue();
                    if (null == this.checkTestingPlanExist(testingPlanId, true)) {
                        return;
                    }
                    TestingPlanUtil.runTestingPlan(testingPlanId, republish);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"WorkflowTestingPlanListPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"WorkflowTestingPlanListPlugin_10", (String)"bos-wf-unittest", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private boolean validateSelectOneItem(ListSelectedRowCollection rows) {
        if (rows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6d4b\u8bd5\u8ba1\u5212\u3002", (String)"WorkflowTestingPlanListPlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private TestingPlanEntity checkTestingPlanExist(Long testingPlanId, boolean showTip) {
        TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.service.getRepositoryService().findEntityById(testingPlanId, "wf_testingplan", "id");
        if (null == testingPlanEntity && showTip) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"WorkflowTestingPlanListPlugin_11", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        return testingPlanEntity;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if (CONFIRM_CALLBACK_DELETE.equals(callBackId)) {
            this.delete();
            ((IListView)this.getView()).refresh();
        } else if (CONFIRM_CALLBACK_REPUBLISH.equals(callBackId)) {
            this.runTestingPlan(((IListView)this.getView()).getSelectedRows(), true);
        }
    }

    private void delete() {
        try {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (null != rows && !rows.isEmpty()) {
                for (ListSelectedRow row : rows) {
                    Long testingPlanId = (Long)row.getPrimaryKeyValue();
                    if (null == this.checkTestingPlanExist(testingPlanId, true)) {
                        return;
                    }
                    WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                    service.getRepositoryService().deleteAllTestingPlanRunningDatasByTestingPlanId(testingPlanId);
                }
            }
            ((IListView)this.getView()).clearSelection();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkflowTestingPlanListPlugin_7", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WorkflowTestingPlanListPlugin_8", (String)"bos-wf-unittest", (Object[])new Object[0]), e.getMessage()));
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private FormShowParameter getFormShowParameter(Long id) {
        FormShowParameter parameter = new FormShowParameter();
        if (id != null) {
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("op", (Object)"save");
        }
        parameter.setFormId("wf_testingplan_edit");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTING_PLAN));
        return parameter;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        if (COLUMN_NUMBER.equals(evt.getFieldName())) {
            this.viewTestingPlanResult(null, (Long)((IListView)this.getView()).getFocusRowPkId());
            args.setCancel(true);
        } else {
            super.billListHyperLinkClick(args);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "testing_plan": {
                ((IListView)this.getView()).refresh();
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ABORT, BTN_VIEW_TESTINGPLAN_RESULT, BTN_SHOWERROR});
        if (rows != null && rows.size() == 1) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_VIEW_TESTINGPLAN_RESULT});
            Long planId = (Long)rows.get(0).getPrimaryKeyValue();
            if (null == this.checkTestingPlanExist(planId, false)) {
                return;
            }
            TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.service.getRepositoryService().findEntityById(planId, "wf_testingplan");
            if ("running".equals(testingPlanEntity.getState())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ABORT});
            }
            if (WfUtils.isNotEmpty((String)testingPlanEntity.getErrorInfo())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SHOWERROR});
            }
            if (!"notrunning".equals(testingPlanEntity.getState())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_VIEW_TESTINGPLAN_RESULT});
            }
        }
    }
}

