/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.PathItem;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.unittest.util.TestingPlanUtil;

public class WorkflowTestingPlanPlugin
extends AbstractWorkflowPlugin
implements TabSelectListener {
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_AUTOTEST = "btnautotest";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_TESTCASE = "testcase";
    private static final String FIELD_SCHEME = "scheme";
    private static final String FIELD_ENTITYNAME = "entityname";
    private static final String FIELD_ENTITYNUMBER = "entitynumber";
    private static final String FIELD_ENABLE = "enable";
    private static final String ENTRYENTITY = "pathentry";
    private static final String ENTRY_NODENAME = "nodename";
    private static final String ENTRY_NODEID = "nodeid";
    private static final String ENTRY_NODETYPE = "nodetype";
    private static final String ENTRY_ID = "id";
    private static final String ENTRY_EXECUTIONTYPE = "executiontype";
    private static final String ENTRY_VARIABLES = "variables";
    private static final String ENTRY_ASSIGNEE = "assignee";
    private static final String ENTRY_MODIFYEXP = "modifyexp";
    private static final String PANEL_PATH = "pathpanel";
    private static final String PANEL_BILL_CONTAINER = "billcontainer";
    private static final String TAB_BILL = "billtab";
    private static final String KEY_BILLID = "billId";
    private static final String KEY_ENTITYNUMBER = "entitynumber";
    private static final String KEY_TESTING_PLAN_VARIABLES = "testing_plan_variables";
    private static final String KEY_BILL_PAGEID = "bill_pageId";
    private static final String KEY_BILL_ADD_NEW = "bill_add_new";
    private static final String KEY_SCHEME_ID = "scheme_id";
    private static final String KEY_TESTINGPLAN_PATH = "testingplan_path";
    private static final String KEY_OPENED_PAGE_ID = "opened_page_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ENTRY_VARIABLES, ENTRY_MODIFYEXP});
        this.addItemClickListeners(new String[]{"toolbarap", BTN_AUTOTEST});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long id = (Long)parameter.getCustomParam(ENTRY_ID);
        Long schemeId = (Long)parameter.getCustomParam("schemeId");
        String op = (String)parameter.getCustomParam("op");
        if ("save".equals(op)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SAVE});
        }
        if ("autotest".equals(op)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_AUTOTEST});
        }
        if (WfUtils.isNotEmpty((Long)id)) {
            this.initTestingPlan(id);
        } else {
            this.init(schemeId);
        }
    }

    private void init(Long schemeId) {
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        this.getPageCache().put("entitynumber", bpmnModel.getMainProcess().getEntraBill());
        this.getPageCache().put(KEY_BILL_ADD_NEW, "0");
        this.getPageCache().put(KEY_SCHEME_ID, schemeId.toString());
        ArrayList<PathItem> pathItems = new ArrayList<PathItem>();
        List endEventList = bpmnModel.getMainProcess().findFlowElementsOfType(EndEvent.class);
        EndEvent endEvent = (EndEvent)endEventList.get(0);
        List allNodes = bpmnModel.getPreviousNodes(endEvent.getId());
        allNodes.add(endEvent);
        if (null != allNodes && !allNodes.isEmpty()) {
            for (FlowElement element : allNodes) {
                if (null == element) continue;
                PathItem item = this.getPathItem(element);
                pathItems.add(item);
            }
        }
        this.getPageCache().put(KEY_TESTINGPLAN_PATH, JSON.toJSONString(pathItems));
        this.initPathEntrySelect(schemeId);
        this.initTestingPathByModel(pathItems);
    }

    private PathItem getPathItem(FlowElement element) {
        PathItem item = new PathItem();
        item.setNodeId(element.getNumber());
        item.setNodeName(element.getName());
        item.setActivityType(element.getType());
        if ("UserTask".equals(element.getType()) || "AuditTask".equals(element.getType()) || "YunzhijiaTask".equals(element.getType())) {
            ParticipantModelEntityImpl participantModelEntityImpl;
            List participant;
            DecisionOption dOption = (DecisionOption)element.getDecisionOptions().get(0);
            HashMap<String, String> varMap = new HashMap<String, String>();
            varMap.put("auditNumber", dOption.getNumber());
            varMap.put("auditName", dOption.getName());
            item.setVariables(varMap);
            UserTask userTask = (UserTask)element;
            ParticipatantModel participantModel = userTask.getParticipant();
            if (null != participantModel && null != (participant = participantModel.getParticipant()) && !participant.isEmpty() && null != (participantModelEntityImpl = (ParticipantModelEntityImpl)participant.get(0))) {
                String personsStr;
                String[] persons;
                DynamicObject dynamicObject = participantModelEntityImpl.getDynamicObject();
                String type = participantModelEntityImpl.getType();
                if ("person".equals(type) && null != (persons = (personsStr = dynamicObject.getString("value")).split(",")) && persons.length > 0) {
                    String assigneeId = persons[0];
                    item.setAssigneeId(Long.valueOf(Long.parseLong(assigneeId)));
                }
            }
        }
        return item;
    }

    private void initTestingPlan(Long id) {
        TestingPlanEntity testingPlan = (TestingPlanEntity)this.getRepositoryService().findEntityById(id, "wf_testingplan");
        this.initSchemeSelect(testingPlan.getSchemeId());
        IDataModel model = this.getModel();
        model.setValue(FIELD_NAME, (Object)testingPlan.getName());
        model.setValue(FIELD_NUMBER, (Object)testingPlan.getNumber());
        model.setValue(FIELD_DESCRIPTION, (Object)testingPlan.getDescription());
        model.setValue(FIELD_ENTITYNAME, (Object)testingPlan.getEntityName());
        model.setValue("entitynumber", (Object)testingPlan.getEntityNumber());
        model.setValue(FIELD_TESTCASE, (Object)testingPlan.getCaseId());
        model.setValue(FIELD_SCHEME, (Object)testingPlan.getSchemeId());
        model.setValue(FIELD_ENABLE, (Object)testingPlan.isEnable());
        this.getPageCache().put("entitynumber", testingPlan.getEntityNumber());
        this.getPageCache().put(KEY_BILLID, testingPlan.getBusinesskey());
        this.initPathEntrySelect(testingPlan.getSchemeId());
        this.initTestingPath(id);
    }

    private void initSchemeSelect(Long schemeId) {
        QFilter[] filters = new QFilter[]{new QFilter(ENTRY_ID, "=", (Object)schemeId).or(new QFilter("parentschemeid", "=", (Object)schemeId))};
        List schemes = this.getManagementService().getDynamicConfigSchemeByFilters(filters);
        this.setSchemeSelectItems(schemes);
    }

    private void setSchemeSelectItems(List<DynamicConfigSchemeEntity> schemes) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(schemes.size());
        for (DynamicConfigSchemeEntity scheme : schemes) {
            items.add(new ComboItem(new LocaleString(scheme.getName().getLocaleValue()), String.valueOf(scheme.getId())));
            if (!scheme.isAcquiescence()) continue;
            this.getModel().setValue(FIELD_SCHEME, (Object)scheme.getId());
        }
        ComboEdit scheme = (ComboEdit)this.getControl(FIELD_SCHEME);
        scheme.setComboItems(items);
    }

    private void initPathEntrySelect(Long schemeId) {
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        List elements = bpmnModel.getMainProcess().getFlowElementList();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(elements.size());
        for (FlowElement element : elements) {
            if (element instanceof SequenceFlow) continue;
            items.add(new ComboItem(new LocaleString(element.getName()), element.getId()));
        }
        ComboEdit nodeName = (ComboEdit)this.getControl(ENTRY_NODENAME);
        nodeName.setComboItems(items);
        ComboEdit executionType = (ComboEdit)this.getControl(ENTRY_NODETYPE);
        executionType.setComboItems(this.getStencilTypeItems());
    }

    private List<ComboItem> getStencilTypeItems() {
        List configs = DesignerModelUtil.getStencilConfigs((String)"WorkflowModel", (boolean)true);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (StencilConfig config : configs) {
            if (!config.isVisible()) continue;
            items.add(new ComboItem(new LocaleString(config.getStencilName()), config.getId()));
        }
        return items;
    }

    private void initTestingPath(Long planId) {
        QFilter f = new QFilter("planid", "=", (Object)planId);
        List paths = this.getRepositoryService().findEntitiesByFilters("wf_testingpath", new QFilter[]{f});
        if (null == paths || paths.size() < 1) {
            return;
        }
        int size = paths.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRYENTITY, size);
        int i = 0;
        for (TestingPathEntity path : paths) {
            if ("SequenceFlow".equals(path.getActivityType())) continue;
            model.setValue(ENTRY_ID, (Object)path.getId(), i);
            model.setValue(ENTRY_NODEID, (Object)path.getNodeId(), i);
            model.setValue(ENTRY_NODENAME, (Object)path.getNodeName(), i);
            model.setValue(ENTRY_NODETYPE, (Object)path.getActivityType(), i);
            if (WfUtils.isNotEmpty((String)path.getExecutionType())) {
                model.setValue(ENTRY_EXECUTIONTYPE, (Object)path.getExecutionType(), i);
            } else if (BpmnModelUtil.instanceofStartEvent((String)path.getActivityType()) || BpmnModelUtil.instanceofEndEvent((String)path.getActivityType())) {
                model.setValue(ENTRY_EXECUTIONTYPE, null, i);
            }
            model.setValue(ENTRY_ASSIGNEE, (Object)path.getAssigneeId(), i);
            if (null != path.getVariables() && !path.getVariables().isEmpty()) {
                Map variables = (Map)JSON.parse((String)path.getVariables());
                model.setValue("decision", (Object)((String)variables.get("auditName")), i);
                model.setValue(ENTRY_VARIABLES, (Object)JSON.toJSONString((Object)path.getVariables()), i);
            }
            model.setValue(ENTRY_MODIFYEXP, (Object)path.getModifyExp());
            ++i;
        }
        int[] superfluous = new int[size - i];
        for (int j = 0; j < size - i; ++j) {
            superfluous[j] = i + j;
        }
        model.deleteEntryRows(ENTRYENTITY, superfluous);
    }

    private void initTestingPathByModel(List<PathItem> pathItems) {
        if (null == pathItems || pathItems.size() < 1) {
            return;
        }
        int size = pathItems.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRYENTITY, size);
        int i = 0;
        for (PathItem path : pathItems) {
            if ("SequenceFlow".equals(path.getActivityType())) continue;
            model.setValue(ENTRY_ID, (Object)path.getId(), i);
            model.setValue(ENTRY_NODEID, (Object)path.getNodeId(), i);
            model.setValue(ENTRY_NODENAME, (Object)path.getNodeName(), i);
            model.setValue(ENTRY_NODETYPE, (Object)path.getActivityType(), i);
            if (WfUtils.isNotEmpty((String)path.getExecutionType())) {
                model.setValue(ENTRY_EXECUTIONTYPE, (Object)path.getExecutionType(), i);
            } else if (BpmnModelUtil.instanceofStartEvent((String)path.getActivityType()) || BpmnModelUtil.instanceofEndEvent((String)path.getActivityType())) {
                model.setValue(ENTRY_EXECUTIONTYPE, null, i);
            }
            model.setValue(ENTRY_ASSIGNEE, (Object)path.getAssigneeId(), i);
            if (null != path.getVariables() && !path.getVariables().isEmpty()) {
                Map variables = path.getVariables();
                model.setValue("decision", (Object)((String)variables.get("auditName")), i);
                model.setValue(ENTRY_VARIABLES, (Object)JSON.toJSONString((Object)path.getVariables()), i);
            }
            model.setValue(ENTRY_MODIFYEXP, (Object)path.getModifyExp());
            ++i;
        }
        int[] superfluous = new int[size - i];
        for (int j = 0; j < size - i; ++j) {
            superfluous[j] = i + j;
        }
        model.deleteEntryRows(ENTRYENTITY, superfluous);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btnsave": {
                this.save();
                break;
            }
            case "btnautotest": {
                this.autoTest();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btnsave": {
                this.save();
                break;
            }
            case "variables": {
                this.showVariables();
                break;
            }
            case "modifyexp": {
                this.showExpWin();
                break;
            }
        }
    }

    private void autoTest() {
        String entityNumber = this.getPageCache().get("entitynumber");
        String pageId = this.getPageCache().get(KEY_BILL_PAGEID);
        String schemeId = this.getPageCache().get(KEY_SCHEME_ID);
        String paths = this.getPageCache().get(KEY_TESTINGPLAN_PATH);
        if (null == pageId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4fe1\u606f\u3002", (String)"WorkflowTestingPlanPlugin_5", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        IFormView billView = this.getView().getView(pageId);
        if (null == billView) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"WorkflowTestingPlanPlugin_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        DynamicObject billObject = billView.getModel().getDataEntity(true);
        OperationResult ret = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])new DynamicObject[]{billObject}, null);
        if (ret == null || ret.getSuccessPkIds().isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WorkflowTestingPlanPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        Object businessKey = ret.getSuccessPkIds().get(0);
        TestingPlanEntity testingPlan = null;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("paths", paths);
        try {
            WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            testingPlan = service.getRepositoryService().convertSchemeToCase(Long.valueOf(Long.parseLong(schemeId)), Long.valueOf(Long.parseLong(businessKey.toString())), param);
            if (null != testingPlan) {
                this.reloadTestingPlan(testingPlan.getId());
                TestingPlanUtil.runTestingPlan(testingPlan.getId(), false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"WorkflowTestingPlanPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fd0\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WorkflowTestingPlanPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]), e.getMessage()));
            this.logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.openTestingPlanListPage();
    }

    private void updatePathItems() {
        String paths = this.getPageCache().get(KEY_TESTINGPLAN_PATH);
        List pathList = SerializationUtils.fromJsonStringToList((String)paths.toString(), PathItem.class);
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        DynamicObjectCollection pathItems = this.getModel().getEntryEntity(ENTRYENTITY);
        if (null == pathItems || pathItems.isEmpty()) {
            return;
        }
        for (int i = 0; i < pathItems.size(); ++i) {
            DynamicObject item = (DynamicObject)pathItems.get(i);
            if (null == item.get(ENTRY_NODETYPE) || !item.get(ENTRY_NODETYPE).equals("AuditTask")) continue;
            Long assigneeId = (Long)item.get("assignee_id");
            assigneeMap.put((String)item.get(ENTRY_NODEID), assigneeId.toString());
        }
        for (PathItem path : pathList) {
            if (!assigneeMap.containsKey(path.getNodeId())) continue;
            String assignee = (String)assigneeMap.get(path.getNodeId());
            path.setAssigneeId(Long.valueOf(Long.parseLong(assignee)));
        }
        this.getPageCache().put(KEY_TESTINGPLAN_PATH, JSON.toJSONString((Object)pathList));
    }

    private void showVariables() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int focusRow = grid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"WorkflowTestingPlanPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingplan_variables");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTING_PLAN_VARIABLES));
        parameter.setCustomParam("schemeId", this.getModel().getValue(FIELD_SCHEME));
        parameter.setCustomParam("nodeId", this.getModel().getValue(ENTRY_NODEID, focusRow));
        parameter.setCustomParam("variables_value", this.getModel().getValue(ENTRY_VARIABLES, focusRow));
        this.getView().showForm(parameter);
    }

    private void showExpWin() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int focusRow = grid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"WorkflowTestingPlanPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingplan_exp");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENTRY_MODIFYEXP));
        parameter.setCustomParam("expValue", (Object)"{}");
        parameter.setCustomParam("entityNumber", (Object)this.getPageCache().get("entitynumber"));
        this.getView().showForm(parameter);
    }

    private void save() {
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam(ENTRY_ID);
        if (WfUtils.isNotEmpty((Long)id)) {
            TestingPlanEntity testingPlan = (TestingPlanEntity)this.getRepositoryService().findEntityById(id, "wf_testingplan");
            testingPlan.setName((ILocaleString)this.getModel().getValue(FIELD_NAME));
            testingPlan.setDescription((ILocaleString)this.getModel().getValue(FIELD_DESCRIPTION));
            testingPlan.setEnable(((Boolean)this.getModel().getValue(FIELD_ENABLE)).booleanValue());
            HashMap<String, String> cMap = new HashMap<String, String>();
            DynamicObjectCollection pathItems = this.getModel().getEntryEntity(ENTRYENTITY);
            int size = pathItems.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject item = (DynamicObject)pathItems.get(i);
                if (null == item.get(ENTRY_NODETYPE) || !item.get(ENTRY_NODETYPE).equals("UserTask")) continue;
                cMap.put((String)item.get(ENTRY_NODEID), (String)item.get(ENTRY_MODIFYEXP));
            }
            QFilter f = new QFilter(ENTRY_ID, "=", (Object)id);
            List pathList = this.getRepositoryService().findEntitiesByFilters("wf_testingpath", new QFilter[]{f});
            for (TestingPathEntity path : pathList) {
                if (!cMap.containsKey(path.getNodeId())) continue;
                path.setModifyExp((String)cMap.get(path.getNodeId()));
                this.getRepositoryService().saveOrUpdateEntity((Entity)path);
            }
            this.getRepositoryService().saveOrUpdateEntity((Entity)testingPlan);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkflowTestingPlanPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        if (FIELD_TESTCASE.equals(propName)) {
            this.testCaseChanged(newValue, oldValue);
        }
    }

    private void testCaseChanged(Object newValue, Object oldValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject testCase = (DynamicObject)newValue;
            Long procDefId = testCase.getLong("procdefid");
            List schemes = this.getManagementService().getDynamicConfigSchemeByProcDefId(procDefId, true);
            this.setSchemeSelectItems(schemes);
            ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(procDefId, "wf_processdefinition");
            this.getModel().setValue("entitynumber", (Object)procDefEntity.getEntraBill());
            this.getModel().setValue(FIELD_ENTITYNAME, (Object)EntityMetadataCache.getDataEntityTypeById((String)procDefEntity.getEntraBillId()).getDisplayName().getLocaleValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_PATH});
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "testing_plan_variables": {
                this.updateVariables(e.getReturnData());
                break;
            }
            case "modifyexp": {
                this.updateModifyExp(e.getReturnData());
                break;
            }
        }
    }

    private void updateVariables(Object returnData) {
        if (returnData instanceof Map) {
            Map variable = (Map)returnData;
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = grid.getEntryState().getFocusRow();
            this.getModel().setValue(ENTRY_VARIABLES, (Object)(variable.isEmpty() ? "" : JSON.toJSONString((Object)variable)), focusRow);
        }
    }

    private void updateModifyExp(Object returnData) {
        if (returnData instanceof Map) {
            Map ret = (Map)returnData;
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = grid.getEntryState().getFocusRow();
            this.getModel().setValue(ENTRY_MODIFYEXP, (Object)(ret.isEmpty() ? "" : ret.get("content").toString()), focusRow);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (rowCount < 1) {
            Long schemeId = (Long)this.getModel().getValue(FIELD_SCHEME);
            this.initPathEntrySelect(schemeId);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (TAB_BILL.equals(key)) {
            this.loadBillPage();
        }
    }

    private void loadBillPage() {
        String pageId = this.getPageCache().get(KEY_BILL_PAGEID);
        String addNew = this.getPageCache().get(KEY_BILL_ADD_NEW);
        if (pageId == null) {
            String formId = this.getPageCache().get("entitynumber");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(formId);
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(PANEL_BILL_CONTAINER);
            if (null == addNew) {
                parameter.setStatus(OperationStatus.VIEW);
                parameter.setPkId((Object)this.getPageCache().get(KEY_BILLID));
            } else if ("0".equals(addNew)) {
                parameter.setStatus(OperationStatus.ADDNEW);
            }
            parameter.addCustPlugin("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn");
            String appId = WfUtils.getAppIdForEntity((String)formId);
            if (WfUtils.isNotEmpty((String)appId)) {
                parameter.getCustomParams().put("ServiceAppId", appId);
            }
            parameter.setAppId("a479ec06000000ac");
            this.getView().showForm((FormShowParameter)parameter);
            this.getPageCache().put(KEY_BILL_PAGEID, parameter.getPageId());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_BILL_PAGEID);
        this.getPageCache().remove(KEY_BILLID);
        this.getPageCache().remove("entitynumber");
    }

    private void showAutoTestProcessInstances(Long schemeId) {
        IFormView openedView;
        String openedPageId = this.getPageCache().get(KEY_OPENED_PAGE_ID);
        if (null != openedPageId && (openedView = this.getView().getView(openedPageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCustomParam("schemeId", (Object)schemeId);
        parameter.setBillFormId("wf_hiprocinst_autotest");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
        this.getPageCache().put(KEY_OPENED_PAGE_ID, parameter.getPageId());
    }

    private void reloadTestingPlan(Long id) {
        TestingPlanEntity testingPlan = (TestingPlanEntity)this.getRepositoryService().findEntityById(id, "wf_testingplan");
        IDataModel model = this.getModel();
        model.setValue(FIELD_NAME, (Object)testingPlan.getName());
        model.setValue(FIELD_NUMBER, (Object)testingPlan.getNumber());
        model.setValue(FIELD_DESCRIPTION, (Object)testingPlan.getDescription());
        model.setValue(FIELD_ENTITYNAME, (Object)testingPlan.getEntityName());
        model.setValue("entitynumber", (Object)testingPlan.getEntityNumber());
        model.setValue(FIELD_TESTCASE, (Object)testingPlan.getCaseId());
        model.setValue(FIELD_SCHEME, (Object)testingPlan.getSchemeId());
        model.setValue(FIELD_ENABLE, (Object)testingPlan.isEnable());
    }

    private void openTestingPlanListPage() {
        Object caseId = this.getModel().getValue("testcase_id");
        if (null != caseId) {
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(Long.parseLong(caseId.toString()));
            TestingPlanUtil.openTestingPlanList(this.getView(), idList, "");
        }
    }
}

