/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testcase.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowTestingPlanVariablesPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btnok";
    private static final String ENTRYENTITY = "variablesentry";
    private static final String ENTRY_NAME = "name";
    private static final String ENTRY_VALUE = "value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String value = (String)parameter.getCustomParam("variables_value");
        if (WfUtils.isNotEmpty((String)value)) {
            this.initVariableEntry(value);
        }
    }

    private void initVariableEntry(String value) {
        JSONObject variable = JSON.parseObject((String)value);
        Set keys = variable.keySet();
        int size = keys.size();
        if (size > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            int i = 0;
            for (String key : keys) {
                model.setValue(ENTRY_NAME, (Object)key, i);
                model.setValue(ENTRY_VALUE, variable.get((Object)key), i);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey().toLowerCase();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        if (datas != null) {
            HashMap<String, Object> variable = new HashMap<String, Object>();
            for (DynamicObject data : datas) {
                variable.put(data.getString(ENTRY_NAME), data.get(ENTRY_VALUE));
            }
            this.getView().returnDataToParent(variable);
        }
        this.getView().close();
    }
}

