/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;

public class BecExecutePlugin
implements IEventServicePlugin {
    private static final String BUSINESSKEY = "businesskey";
    private static final String BOS_USER = "bos_user";
    private static final String BOS_WF_UNITTEST = "bos-wf-unittest";
    private static final String PHONE = "phone";
    private static Log logger = LogFactory.getLog(BecExecutePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
            String entityNumber = ((EntityEvent)evt).getEntityNumber();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)businesskey, (String)entityNumber);
            Long evtID = evt.getEventId();
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"evt_event", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)evtID)});
            String number = "";
            if (objs != null && objs.length > 0) {
                number = objs[0].getString("number");
            }
            MessageInfo info = new MessageInfo();
            info.setTitle(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3\u63d2\u4ef6\u6d4b\u8bd5", (String)"BecExecutePlugin_3", (String)BOS_WF_UNITTEST, (Object[])new Object[0]));
            StringBuilder sb = new StringBuilder();
            sb.append("EntityNumber:").append(entityNumber).append("<br />");
            sb.append("EntityNumber:").append(obj.get("billno")).append("<br />");
            sb.append("Businesskey:").append(businesskey).append("<br />");
            sb.append(String.format(ResManager.loadKDString((String)"%s\u4e8b\u4ef6\uff0c\u6267\u884c\u63d2\u4ef6\u6210\u529f\u3002", (String)"BecExecutePlugin_2", (String)BOS_WF_UNITTEST, (Object[])new Object[0]), number));
            info.setContent(sb.toString());
            ArrayList<Long> userIds = new ArrayList<Long>();
            DynamicObject creator = null;
            DynamicObject modifier = null;
            try {
                creator = (DynamicObject)obj.get("creator");
            }
            catch (Exception e) {
                creator = (DynamicObject)obj.get("createrfield");
            }
            try {
                modifier = (DynamicObject)obj.get("modifier");
            }
            catch (Exception e) {
                modifier = (DynamicObject)obj.get("modifierfield");
            }
            Long creatorId = (Long)creator.get("id");
            userIds.add(creatorId);
            if (modifier != null) {
                Long modifierId = (Long)modifier.get("id");
                userIds.add(modifierId);
            }
            info.setUserIds(userIds);
            info.setType("message");
            info.setEntityNumber(entityNumber);
            LocaleString messageTag = new LocaleString();
            messageTag.setLocaleValue_en("bec");
            messageTag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3", (String)"BecExecutePlugin_4", (String)BOS_WF_UNITTEST, (Object[])new Object[0]));
            info.setMessageTag((ILocaleString)messageTag);
            info.setNotifyType("yunzhijia");
            MessageCenterServiceHelper.sendMessage((MessageInfo)info);
            return 1;
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        QFilter[] selectValueFilters = new QFilter[]{new QFilter(PHONE, "=", (Object)"17299999999")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BOS_USER, (String)"id", (QFilter[])selectValueFilters);
        userIds.add(Long.valueOf(String.valueOf(dynamicObject.getPkValue())));
        QFilter[] selectValueFilters2 = new QFilter[]{new QFilter(PHONE, "=", (Object)"18612017354")};
        DynamicObject dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)BOS_USER, (String)"id", (QFilter[])selectValueFilters2);
        userIds.add(Long.valueOf(String.valueOf(dynamicObject2.getPkValue())));
        MessageInfo info = new MessageInfo();
        info.setTitle(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3\u63d2\u4ef6\u6d4b\u8bd5", (String)"BecExecutePlugin_3", (String)BOS_WF_UNITTEST, (Object[])new Object[0]));
        StringBuilder sb = new StringBuilder();
        sb.append("EntityNumber:").append(evt.getEventNumber());
        sb.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\uff0c\u6267\u884c\u63d2\u4ef6\u6210\u529f\u3002", (String)"BecExecutePlugin_5", (String)BOS_WF_UNITTEST, (Object[])new Object[0]));
        info.setContent(sb.toString());
        info.setUserIds(userIds);
        info.setType("message");
        LocaleString messageTag = new LocaleString();
        messageTag.setLocaleValue_en("bec");
        messageTag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3", (String)"BecExecutePlugin_4", (String)BOS_WF_UNITTEST, (Object[])new Object[0]));
        info.setMessageTag((ILocaleString)messageTag);
        info.setNotifyType("yunzhijia");
        MessageCenterServiceHelper.sendMessage((MessageInfo)info);
        return 1;
    }

    public List<Long> calcUserIds(KDBizEvent evt) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        QFilter[] selectValueFilters = new QFilter[]{new QFilter(PHONE, "=", (Object)"17299999999")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BOS_USER, (String)"id", (QFilter[])selectValueFilters);
        userIds.add(Long.valueOf(String.valueOf(dynamicObject.getPkValue())));
        return userIds;
    }

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        QFilter[] selectValueFilters = new QFilter[]{new QFilter(PHONE, "=", (Object)"17299999999")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BOS_USER, (String)"id", (QFilter[])selectValueFilters);
        userIds.add(Long.valueOf(String.valueOf(dynamicObject.getPkValue())));
        QFilter[] selectValueFilters2 = new QFilter[]{new QFilter(PHONE, "=", (Object)"18612017354")};
        DynamicObject dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)BOS_USER, (String)"id", (QFilter[])selectValueFilters2);
        userIds.add(Long.valueOf(String.valueOf(dynamicObject2.getPkValue())));
        HashMap<String, List<Long>> mapUserIds = new HashMap<String, List<Long>>();
        if (evt instanceof EntityEvent) {
            List businesskeys = ((EntityEvent)evt).getBusinesskeys();
            for (String businesskey : businesskeys) {
                mapUserIds.put(businesskey, userIds);
            }
            return mapUserIds;
        }
        JsonEvent jsonEvent = (JsonEvent)evt;
        String source = jsonEvent.getSource();
        if (WfUtils.isNotEmpty((String)source)) {
            JSONArray arr = (JSONArray)JSON.parse((String)source);
            String msgIdArr = arr.getJSONObject(0).getString(BUSINESSKEY);
            if (msgIdArr == null) {
                mapUserIds.put(BUSINESSKEY, userIds);
            }
            String[] channelArray = new String[]{};
            if (msgIdArr != null && StringUtils.isNotBlank((CharSequence)msgIdArr)) {
                channelArray = msgIdArr.split(",");
            }
            for (String businesskey : channelArray) {
                mapUserIds.put(businesskey, userIds);
            }
            return mapUserIds;
        }
        return null;
    }

    public String buildUrl(KDBizEvent evt) {
        String formId = ((EntityEvent)evt).getEntityNumber();
        String mobFormId = formId + "_mob";
        String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        Long pkid = Long.valueOf(businesskey);
        Map builMessageUrl = MessageCenterServiceHelper.builMessageUrl((String)formId, (String)mobFormId, (Long)pkid, null);
        String url = (String)builMessageUrl.get("data");
        logger.debug("buildUrl\u65b9\u6cd5\u8fd4\u56de\u7684\u94fe\u63a5\u4e3a\uff1a" + url);
        return url;
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> mapBillUrl = new HashMap<String, String>();
        if (evt instanceof EntityEvent) {
            String formId = ((EntityEvent)evt).getEntityNumber();
            String mobFormId = formId + "_mob";
            List businesskeys = ((EntityEvent)evt).getBusinesskeys();
            for (String businesskey : businesskeys) {
                Long pkid = Long.valueOf(businesskey);
                MessageCenterServiceImpl messageCenterServiceImpl = new MessageCenterServiceImpl();
                Map builMessageUrl = messageCenterServiceImpl.builMessageUrl(formId, mobFormId, pkid, null);
                String url = (String)builMessageUrl.get("data");
                mapBillUrl.put(businesskey, url);
            }
        } else {
            JsonEvent entityEvent = (JsonEvent)evt;
            String source = entityEvent.getSource();
            if (WfUtils.isNotEmpty((String)source)) {
                JSONArray arr = (JSONArray)JSON.parse((String)source);
                String msgIdArr = arr.getJSONObject(0).getString(BUSINESSKEY);
                if (msgIdArr == null) {
                    mapBillUrl.put(BUSINESSKEY, "http://localhost:8080/ierp/integration/yzjShareOpen.do?formId=er_tripreqbill&mb_formId=er_tripreqbill_mob&pkId=1063711077491030001&accountId=202109161650");
                }
                String[] channelArray = new String[]{};
                if (msgIdArr != null && StringUtils.isNotBlank((CharSequence)msgIdArr)) {
                    channelArray = msgIdArr.split(",");
                }
                for (String businesskey : channelArray) {
                    Map builMessageUrl = MessageCenterServiceHelper.builMessageUrl((String)"er_tripreqbill", (String)"er_tripreqbill_mob", (Long)Long.valueOf(businesskey), null);
                    String url = (String)builMessageUrl.get("data");
                    mapBillUrl.put(businesskey, url);
                }
            }
        }
        logger.debug("buildBillUrl\u65b9\u6cd5\u8fd4\u56de\u7684\u94fe\u63a5\u4e3a\uff1a" + ((Object)mapBillUrl).toString());
        return mapBillUrl;
    }
}

