/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.api.ProcessInstanceMainOrgView;
import kd.bos.workflow.api.ViewFlowChartPermParam;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.task.Comment;

public class ExtItfTestingPluginA
implements IWorkflowPlugin {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String REASON = "reason";
    private static String[] infos = new String[]{"Pushed down: 2 standard purchase requisition", "Start time: 2021-05-05 14:50:00", "Completion time: 2021-05-15 10:00:00"};

    public void afterHandleTask(AgentTask task, String evtName, Map<String, Object> executeParam) {
        this.log.debug("kd.bos.workflow.testing.ExtItfTestingPluginA.afterHandleTask(AgentTask, String, Map<String, Object>) task :" + task + "; evtName :" + evtName + ";executeParam :" + executeParam);
    }

    public List<Long> calcUserIds(AgentExecution execution) {
        ArrayList<Long> participants = new ArrayList<Long>();
        participants.add(76039528L);
        participants.add(11532634L);
        this.log.debug("event-name:" + execution.getEventName());
        if ("calculateParticipants".equals(execution.getEventName())) {
            this.log.debug("setVariable...");
            execution.setVariable("variable-0", (Object)"success");
            Object variable = execution.getVariable("var1");
            if (variable != null) {
                execution.setVariable("variable-1", variable);
            }
            if ((variable = execution.getVariable("var2")) != null) {
                execution.setVariable("variable-2", variable);
            }
        }
        this.logElementProperty(execution);
        return participants;
    }

    private void logElementProperty(AgentExecution execution) {
        if (execution != null) {
            String businessKey = execution.getBusinessKey();
            WorkflowElement element = execution.getCurrentFlowElement();
            if (element != null) {
                this.log.debug(element.getClass().getCanonicalName());
                this.log.debug(String.format("businessKey: %s, id: %s", businessKey, element.getId()));
                String name = (String)element.getPropertyValue("name");
                this.log.debug(String.format("businessKey: %s, name: %s", businessKey, name));
                String number = (String)element.getPropertyValue("number");
                this.log.debug(String.format("businessKey: %s, number: %s", businessKey, number));
                String documentation = (String)element.getPropertyValue("documentation");
                this.log.debug(String.format("businessKey: %s, documentation: %s", businessKey, documentation));
                String bizIdentifyKey = (String)element.getPropertyValue("bizIdentifyKey");
                this.log.debug(String.format("businessKey: %s, bizIdentifyKey: %s", businessKey, bizIdentifyKey));
                String formKey = (String)element.getPropertyValue("billSetting.formKey");
                this.log.debug(String.format("businessKey: %s, formKey: %s", businessKey, formKey));
                Object decisionOptions = element.getPropertyValue("decisionOptions");
                this.log.debug(String.format("businessKey: %s, decisionOptions: %s", businessKey, decisionOptions));
            }
        }
    }

    public boolean hasTrueCondition(AgentExecution execution) {
        this.logElementProperty(execution);
        return true;
    }

    public void notify(AgentExecution execution) {
        this.logElementProperty(execution);
        DynamicObject dynObj = WfUtils.findBusinessObject((String)execution.getBusinessKey(), (String)execution.getEntityNumber());
        if (dynObj.getDynamicObjectType().getProperty(REASON) != null) {
            dynObj.set(REASON, (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"ExtItfTestingPluginA_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
        }
    }

    public void notifyByWithdraw(AgentExecution execution) {
        this.logElementProperty(execution);
        DynamicObject dynObj = WfUtils.findBusinessObject((String)execution.getBusinessKey(), (String)execution.getEntityNumber());
        dynObj.set("applyway", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    public boolean validate(DynamicObject billInfo, Map<String, Object> params) {
        if (billInfo.getDynamicObjectType().getProperty(REASON) != null && WfUtils.isEmpty((String)billInfo.getString(REASON))) {
            throw new KDBizException("Validate Error\uff01");
        }
        return true;
    }

    public String[] getPushStatusInfo(String entityNumber, String businessKey) {
        return infos;
    }

    public Map<Object, Boolean> getBillPermissions(long userId, String entityNumber, List<Object> businessKeys) {
        HashMap<Object, Boolean> permissions = new HashMap<Object, Boolean>(businessKeys.size());
        for (Object businessKey : businessKeys) {
            permissions.put(businessKey, false);
        }
        return permissions;
    }

    public List<ProcessInstanceMainOrgView> hasViewFlowChartPermProcessInstance(ViewFlowChartPermParam param) {
        return param.getProcessInstanceOrgViewList();
    }

    public List<Comment> filterApprovalRecordByAuth(List<Comment> comments) {
        long currUserId = RequestContext.get().getCurrUserId();
        return this.encryptedApprovalRecordByUserId(currUserId, comments);
    }

    public List<Comment> encryptedApprovalRecordByUserId(Long userId, List<Comment> comments) {
        this.log.info("encryptedApprovalRecordByUserId invoke,userId:{},comments:{}", (Object)userId, comments);
        if (userId == null || userId.equals(0L)) {
            userId = 1L;
        }
        for (Comment child : comments) {
            this.log.debug("encryptedApprovalRecordByUserId userid:{},commentUserId:{},eqs:{}", new Object[]{userId, child.getUserId(), userId.equals(child.getUserId())});
            if (!userId.equals(child.getUserId())) continue;
            child.setResultName("**" + child.getResultName() + "**");
            if (child instanceof CommentEntityImpl) {
                this.log.debug("comment is CommentEntityImpl");
                CommentEntityImpl comment = (CommentEntityImpl)child;
                Map<String, String> collect = comment.getUserNameFormatter().entrySet().stream().peek(item -> item.setValue("**" + (String)item.getValue() + "**")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                comment.setUserNameFormatter((ILocaleString)LocaleString.fromMap(collect));
                child.setAssignee("**" + child.getAssignee() + "**");
                comment.setAvatar("/private/universe_ad.png");
            }
            child.setMessage("**" + child.getMessage() + "**");
        }
        this.log.debug(comments + "'");
        return comments;
    }
}

