/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testing;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaPubUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class YunzhijiaServiceHandlerTest
extends AbstractMessageServiceHandler {
    private static Log logger = LogFactory.getLog(YunzhijiaServiceHandlerTest.class);

    public void createToDo(MessageContext ctx, ToDoInfo info) {
        if (!WfConfigurationUtil.isEnabled((String)"yunzhijia")) {
            return;
        }
        MessageCenterServiceHelper.updateToDoMsgContent((MessageServiceConfig)this.config, (ITaskMsg)info);
        List toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo((ToDoInfo)info);
        for (ToDoInfo toDoInfo : toDoInfos) {
            try {
                YunzhijiaCommonUtil.createUserToDo((MessageContext)ctx, (ToDoInfo)toDoInfo, (YzjToDoState)YzjToDoState.CREATE, (String)"yunzhijia");
                logger.debug("create todo content=" + toDoInfo.getTaskId());
            }
            catch (Exception e) {
                throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjSendTodoError(), new Object[]{e.getMessage()});
            }
        }
    }

    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        block10: {
            if (!WfConfigurationUtil.isEnabled((String)"yunzhijia")) {
                return;
            }
            logger.debug("\u4e91\u4e4b\u5bb6\u670d\u52a1dealToDo ctx: " + ctx.toString() + ",taskId:" + info.getTaskId());
            YunzhijiaCommonUtil.checkTaskId((Long)info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DEAL, (String)"yunzhijia");
            }
            catch (Exception e) {
                this.logYzjError(e, 0, YzjToDoState.DEAL);
                if (ctx.isImmediatelyRetry()) {
                    try {
                        Thread.sleep(500L);
                        YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DEAL, (String)"yunzhijia");
                    }
                    catch (Exception e1) {
                        this.logYzjError(e1, 1, YzjToDoState.DEAL);
                        try {
                            Thread.sleep(1000L);
                            YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DEAL, (String)"yunzhijia");
                            break block10;
                        }
                        catch (Exception e2) {
                            this.logYzjError(e2, 2, YzjToDoState.DEAL);
                            try {
                                Thread.sleep(3000L);
                                YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DEAL, (String)"yunzhijia");
                                break block10;
                            }
                            catch (Exception e3) {
                                this.logYzjError(e3, 3, YzjToDoState.DEAL);
                                throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjdealTodoError(), new Object[]{e.getMessage()});
                            }
                        }
                    }
                }
                throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjdealTodoError(), new Object[]{e.getMessage()});
            }
        }
    }

    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        block10: {
            if (!WfConfigurationUtil.isEnabled((String)"yunzhijia")) {
                return;
            }
            logger.debug("\u4e91\u4e4b\u5bb6\u670d\u52a1deleteToDo ctx: " + ctx.toString());
            YunzhijiaCommonUtil.checkTaskId((Long)info.getTaskId());
            try {
                YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DELETE, (String)"yunzhijia");
            }
            catch (Exception e) {
                this.logYzjError(e, 0, YzjToDoState.DELETE);
                if (ctx.isImmediatelyRetry()) {
                    try {
                        Thread.sleep(500L);
                        YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DELETE, (String)"yunzhijia");
                    }
                    catch (Exception e1) {
                        this.logYzjError(e1, 1, YzjToDoState.DELETE);
                        try {
                            Thread.sleep(1000L);
                            YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DELETE, (String)"yunzhijia");
                            break block10;
                        }
                        catch (Exception e2) {
                            this.logYzjError(e2, 2, YzjToDoState.DELETE);
                            try {
                                Thread.sleep(3000L);
                                YunzhijiaCommonUtil.updateUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.DELETE, (String)"yunzhijia");
                                break block10;
                            }
                            catch (Exception e3) {
                                this.logYzjError(e3, 3, YzjToDoState.DELETE);
                                throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjdeleteTodoError(), new Object[]{e.getMessage()});
                            }
                        }
                    }
                }
                throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjdeleteTodoError(), new Object[]{e.getMessage()});
            }
        }
    }

    private void logYzjError(Exception e, int times, YzjToDoState todostate) {
        StringBuilder errorInfo = new StringBuilder();
        if (1 == times) {
            errorInfo.append(ResManager.loadKDString((String)"[\u7b2c\u4e00\u6b21\u91cd\u8bd5]", (String)"YunzhijiaServiceHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (2 == times) {
            errorInfo.append(ResManager.loadKDString((String)"[\u7b2c\u4e8c\u6b21\u91cd\u8bd5]", (String)"YunzhijiaServiceHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (3 == times) {
            errorInfo.append(ResManager.loadKDString((String)"[\u7b2c\u4e09\u6b21\u91cd\u8bd5]", (String)"YunzhijiaServiceHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (YzjToDoState.DELETE == todostate) {
            errorInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u4e91\u4e4b\u5bb6\u5f85\u529e\u5931\u8d25\u3002", (String)"YunzhijiaServiceHandler_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
        } else {
            errorInfo.append(ResManager.loadKDString((String)"\u66f4\u6539\u4e91\u4e4b\u5bb6\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u529e\u201d\u5931\u8d25\u3002", (String)"YunzhijiaServiceHandler_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        errorInfo.append(e.getMessage());
        logger.debug(errorInfo.toString());
    }

    public void checkTodo(MessageContext ctx, ToDoInfo info) {
        if (!WfConfigurationUtil.isEnabled((String)"yunzhijia")) {
            return;
        }
        logger.debug("\u4e91\u4e4b\u5bb6\u670d\u52a1checkToDo ctx: " + ctx.toString());
        YunzhijiaCommonUtil.checkTaskId((Long)info.getTaskId());
        try {
            YunzhijiaCommonUtil.checkUserToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.CHECK, (String)"yunzhijia");
        }
        catch (Exception e) {
            logger.debug("check user todo is error:" + e.getMessage());
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjcheckTodoError(), new Object[]{e.getMessage()});
        }
    }

    public void sendMessage(MessageContext ctx, MessageInfo message) {
        if (!WfConfigurationUtil.isEnabled((String)"yunzhijia")) {
            return;
        }
        try {
            MessageCenterServiceHelper.updateToDoMsgContent((MessageServiceConfig)this.config, (MessageInfo)message);
            YunzhijiaCommonUtil.embellishTodoUrl(null, (MessageInfo)message, (String)"yunzhijia");
            List messages = YunzhijiaToDoUtil.rebuildMessage((MessageInfo)message);
            if (MessageUtils.isBlankMessage((List)messages)) {
                logger.debug("YunzhijiaServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            for (MessageInfo messageInfo : messages) {
                List userIds = messageInfo.getUserIds();
                Map eidUserOpenIds = YunzhijiaCommonUtil.getUserOpenIdsGroupByEid((List)userIds);
                if (eidUserOpenIds == null || eidUserOpenIds.isEmpty()) continue;
                for (Map.Entry entry : eidUserOpenIds.entrySet()) {
                    YunzhijiaPubUtil.sendMessage((String)((String)entry.getKey()), (List)((List)entry.getValue()), (MessageInfo)messageInfo, (String)"yunzhijia");
                }
            }
            logger.debug(String.format("[%s]\u53d1\u9001\u4e91\u4e4b\u5bb6\u94fe\u63a5\u6d88\u606f\u6210\u529f", RequestContext.get().getTraceId()));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.yzjsendMsgError(), new Object[]{e.getMessage()});
        }
    }

    public boolean canSynch() {
        return true;
    }

    public boolean canCheck() {
        return true;
    }
}

