/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testing.crosstenant;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.TaskErrorCodeEnum;

@ApiController(value="wf", desc="\u8de8\u79df\u6237\u5185\u90e8\u6d4b\u8bd5api")
@ApiMapping(value="/")
public class CrossTenantInternalTestController
implements Serializable {
    private static Log logger = LogFactory.getLog(CrossTenantInternalTestController.class);

    @ApiPostMapping(value="/findBusinessObjectTest", desc="\u83b7\u53d6\u4e1a\u52a1\u5b9e\u4f53\u5bf9\u8c61")
    public CustomApiResult<String> findBusinessObjectTest(@ApiParam(value="\u5355\u636eid", required=true) @ApiParam(value="\u5355\u636eid", required=true) String id, @ApiParam(value="\u5b9e\u4f53\u7f16\u7801", required=true) @ApiParam(value="\u5b9e\u4f53\u7f16\u7801", required=true) String entityNumber, @ApiParam(value="\u67e5\u627e\u5c5e\u6027") @ApiParam(value="\u67e5\u627e\u5c5e\u6027") String fields) {
        if (!WfPermUtils.hasProcessQueryPerm((String)"api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (entity == null) {
                String msg = ResManager.loadKDString((String)"\u51fa\u5dee\u62dc\u8bbf\u5ba2\u6237\u3002", (String)"CrossTenantInternalTestController_1", (String)"bos-wf-unittest", (Object[])new Object[0]);
                return CustomApiResult.fail((String)"errorCode1", (String)msg);
            }
            Object pk = id;
            if (entity.getPrimaryKey() instanceof LongProp) {
                pk = Long.parseLong(id);
            }
            DynamicObject dynamicObject = null;
            String jsonString = "";
            dynamicObject = StringUtils.isBlank((CharSequence)fields) ? BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityNumber) : BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityNumber, (String)fields);
            if ("bos_user".equals(entityNumber) || "bos_org".equals(entityNumber)) {
                // empty if block
            }
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeDataEntityState(true);
            option.setIncludeComplexProperty(false);
            option.setIncludeCollectionProperty(true);
            option.setIncludeType(false);
            jsonString = DataEntitySerializer.serializerToString((Object)dynamicObject, (DataEntitySerializerOption)option);
            return CustomApiResult.success((Object)jsonString);
        }
        catch (KDException e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
        }
    }
}

