/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testing.tips;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.operate.Submit;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.testing.tips.ControlData;
import kd.bos.workflow.testing.tips.LinkData;
import kd.bos.workflow.testing.tips.TipsData;

@Deprecated
public class TipsTestPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"button4"});
    }

    public void initialize() {
        this.addClickListeners(new String[]{"fetchentitydata", "fetchall"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("fetchentitydata".equals(key)) {
            Object entityNumber = this.getModel().getValue("entitynumber");
            if (entityNumber == null) {
                return;
            }
            TipsData tipsData = this.fetchEntityData(entityNumber + "");
            String s = SerializationUtils.toJsonString((Object)tipsData);
            this.getModel().setValue("text", (Object)s);
        } else if ("fetchall".equals(key)) {
            ArrayList list = Lists.newArrayList((Object[])new String[]{"1ZJRZDWYHO0X", "0P2FWW95+QU6", "1ZA=ZFJ59MIL", "194JD185SVFC", "L+YYPU4WNDE", "a479ec06000000ac", "2X5JFEY==B/V"});
            List collect = QueryServiceHelper.query((String)"bos_entityobject", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizappid", "in", (Object)list)}).stream().map(item -> item.getString("id")).map(this::fetchEntityData).collect(Collectors.toList());
            String s = SerializationUtils.toJsonString(collect);
            this.getModel().setValue("text", (Object)s);
        }
    }

    private TipsData fetchEntityData(String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return new TipsData();
        }
        String id = MetadataDao.getIdByNumber((String)(entityNumber + ""), (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new TipsData();
        }
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (metadata == null) {
            return new TipsData();
        }
        TipsData tipsData = new TipsData();
        tipsData.setEntityNumber(entityNumber);
        tipsData.setFormName(metadata.getName().getLocaleValue_zh_CN());
        List<ControlData> collect = metadata.getItems().stream().map(this::getTips).filter(item -> StringUtils.isNotBlank((CharSequence)item.getContent())).collect(Collectors.toList());
        tipsData.setControlDataList(collect);
        return tipsData;
    }

    private ControlData getTips(ControlAp<?> control) {
        if (control == null) {
            return new ControlData();
        }
        Class<?> clazz = control.getClass();
        Optional<Field> first = this.getAllFields(clazz).stream().filter(item -> Tips.class.equals(item.getType())).findFirst();
        ControlData controlData = new ControlData();
        if (!first.isPresent()) {
            return controlData;
        }
        controlData.setControlName(Optional.ofNullable(control.getName()).map(ILocaleString::getLocaleValue_zh_CN).orElseGet(() -> ""));
        controlData.setControlNumber(control.getKey());
        Field field = first.get();
        try {
            Tips tips = (Tips)field.get(control);
            if (tips == null) {
                return controlData;
            }
            String content = Optional.ofNullable(tips.getContent()).map(ILocaleString::getLocaleValue_zh_CN).orElseGet(() -> "");
            if (StringUtils.isEmpty((CharSequence)content)) {
                return controlData;
            }
            String clearContent = content.replaceAll("\\\\n", "").replaceAll("\\\\r", "").replaceAll("\\\\t", "").replaceAll("#\\{\\d*}", "").replaceAll("\\s", "");
            controlData.setContent(clearContent);
            List linkData = tips.getLinkData();
            if (linkData == null) {
                return controlData;
            }
            List<LinkData> collect = linkData.stream().map(item -> {
                LinkData res = new LinkData().setLinkCode((String)item.get("code")).setIndex((Integer)item.get("index"));
                Object name = item.get("name");
                if (name instanceof ILocaleString) {
                    ILocaleString localeName = (ILocaleString)name;
                    res.setLinkName(localeName.getLocaleValue_zh_CN());
                } else if (name instanceof Map) {
                    Map map = (Map)name;
                    Object o = map.get(Lang.zh_CN.name());
                    String s = Optional.ofNullable(o).map(Object::toString).orElseGet(() -> "");
                    res.setLinkName(s);
                }
                return res;
            }).collect(Collectors.toList());
            controlData.setLinkDataList(collect);
            return controlData;
        }
        catch (IllegalAccessException illegalAccessException) {
            return new ControlData();
        }
    }

    public List<Field> getAllFields(Class<?> clazz) {
        ArrayList fieldList = Lists.newArrayList();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity;
        WFProcess process;
        Object source = args.getSource();
        if (source instanceof Submit && (process = WorkflowServiceHelper.getProcessInfo((DynamicObject)(dataEntity = this.getModel().getDataEntity(true)), (String)"submit")) == null) {
            args.setCancelMessage("address fail");
            args.setCancel(true);
            this.getView().showErrorNotification("address fail");
        }
    }
}

