/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testingplan.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.unittest.util.TestingPlanUtil;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;

public class WorkflowTestingPlanRecordPlugin
extends AbstractWorkflowPlugin
implements ProgresssListener {
    private static final String BTNREFRESH = "btnrefresh";
    private static final String BTNSHOWBILL = "btnshowbill";
    private static final String BTNSHOWPROC = "btnshowproc";
    private static final String BTNSAVEASPLAN = "btnsaveasplan";
    private static final String BTNSHOWPLAN = "btnshowplan";
    private static final String BTNSHOWERROR = "btnshowerror";
    private static final String LABEL_PASSED = "imageap";
    private static final String VERSION = "version";
    private static final String BILLINFO = "billinfo";
    private static final String PLANNUMBER = "plannumber";
    private static final String PLANNAME = "planname";
    private static final String TESTINGDATE = "testingdate";
    private static final String STATE = "state";
    private static final String ENTRYENTITY = "hitaskentry";
    private static final String ENTRY_NODENAME = "nodename";
    private static final String ENTRY_NODETYPE = "nodetype";
    private static final String ENTRY_EXECUTIONTYPE = "executiontype";
    private static final String ENTRY_APPROVEINFO = "approveinfo";
    private static final String KEY_BUSINESS_ID = "businessKey";
    private static final String KEY_PROCINSTANCE_ID = "procInstanceIdKey";
    private static final String KEY_TESTINGPLAN_ID = "testingPlanKey";
    private static final String KEY_TESTINGSCHEME_ID = "testingSchemeKey";
    private static final String KEY_TESTINGPLAN_DES = "testingPlanDes";
    private static final String KEY_TESTINGPLAN_ERROR = "testingPlanError";
    private static final String KEY_REFRESH_TIMES = "refreshTimes";
    private static final String KEY_OPENED_PAGE_ID = "openedPageId";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String FLEX_PROGRESSBAR = "flexpanelap6";
    private static final String SOURCE_PAGE_WORKFLOW_DESINGER = "workflowDesinger";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNREFRESH, BTNSHOWBILL, BTNSHOWPROC, BTNSAVEASPLAN, BTNSHOWPLAN, BTNSHOWERROR});
    }

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (null != progressBar) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btnrefresh": {
                this.refreshPage();
                break;
            }
            case "btnshowbill": {
                this.showBill();
                break;
            }
            case "btnshowproc": {
                this.showProc();
                break;
            }
            case "btnshowplan": {
                this.showPlans();
                break;
            }
            case "btnsaveasplan": {
                this.showSceneDescription();
                break;
            }
            case "btnshowerror": {
                this.showErrorPage();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String testingPlanId = (String)customParams.get("testingPlanId");
        this.getPageCache().put(KEY_TESTINGPLAN_ID, testingPlanId);
        Object withProcess = customParams.get("withProcess");
        if (null != withProcess && ((Boolean)withProcess).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_PROGRESSBAR});
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            progressBar.start();
        }
        this.refreshPage();
    }

    private void refreshPage() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String testingPlanId = this.getPageCache().get(KEY_TESTINGPLAN_ID);
        TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.getRepositoryService().findEntityById(Long.valueOf(testingPlanId), "wf_testingplan");
        if (null == testingPlanEntity) {
            this.getView().showErrorNotification(WFMultiLangConstants.getTestingPlanDeleted());
            return;
        }
        this.getPageCache().put(KEY_TESTINGPLAN_DES, testingPlanEntity.getDescription().getLocaleValue());
        this.getPageCache().put(KEY_TESTINGPLAN_ERROR, testingPlanEntity.getErrorInfo());
        this.getPageCache().put(KEY_TESTINGSCHEME_ID, testingPlanEntity.getNewSchemeId().toString());
        if (WfUtils.isNotEmpty((String)testingPlanEntity.getErrorInfo())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTNSHOWERROR});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTNSHOWERROR});
        }
        String sourcePage = (String)customParams.get("sp");
        if (!SOURCE_PAGE_WORKFLOW_DESINGER.equals(sourcePage)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTNSAVEASPLAN, BTNSHOWPLAN});
            if ("successed".equals(testingPlanEntity.getState()) && !testingPlanEntity.isPassed()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTNSAVEASPLAN});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTNSAVEASPLAN});
            }
            if (testingPlanEntity.isPassed()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LABEL_PASSED});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_PASSED});
            }
        }
        this.getModel().setValue(VERSION, (Object)testingPlanEntity.getSchemeName());
        String entityNumber = testingPlanEntity.getEntityNumber();
        LocaleString entityName = WfUtils.getEntityName((String)entityNumber, (String)testingPlanEntity.getBusinesskey());
        String billInfo = entityName.getLocaleValue() + "/" + testingPlanEntity.getBillNo();
        this.getModel().setValue(BILLINFO, (Object)billInfo);
        this.getModel().setValue(PLANNUMBER, (Object)testingPlanEntity.getNumber());
        this.getModel().setValue(PLANNAME, (Object)testingPlanEntity.getName().getLocaleValue());
        this.getModel().setValue(TESTINGDATE, (Object)testingPlanEntity.getStartTime());
        this.getModel().setValue(STATE, (Object)testingPlanEntity.getState());
        String businessKey = WfUtils.isEmptyString((Object)testingPlanEntity.getNewBusinesskey()) ? testingPlanEntity.getBusinesskey() : testingPlanEntity.getNewBusinesskey();
        this.getPageCache().put(KEY_BUSINESS_ID, businessKey);
        Long procInstId = this.getRuntimeService().getProcInstIdByBusKey(businessKey);
        this.getPageCache().put(KEY_PROCINSTANCE_ID, String.valueOf(procInstId));
        Long schemeId = WfUtils.isEmpty((Long)testingPlanEntity.getNewSchemeId()) ? testingPlanEntity.getSchemeId() : testingPlanEntity.getNewSchemeId();
        this.initEntrySelect(schemeId, procInstId);
        Map<String, String> approverInfoMap = TestingPlanUtil.getApproverInfo(schemeId);
        this.getModel().deleteEntryData(ENTRYENTITY);
        QFilter q1 = new QFilter(KEY_BUSINESS_ID, "=", (Object)businessKey);
        QFilter q2 = new QFilter("assigneeId", "!=", (Object)0L);
        List hiTasks = this.getRepositoryService().findEntitiesByFilters("wf_hitaskinst", new QFilter[]{q1, q2});
        if (null != hiTasks && !hiTasks.isEmpty()) {
            int size = hiTasks.size();
            IDataModel model = this.getModel();
            int addSize = null == testingPlanEntity.getEndTime() ? 1 : 2;
            int totalSize = size + addSize;
            model.batchCreateNewEntryRow(ENTRYENTITY, totalSize);
            for (int i = 0; i <= size; ++i) {
                if (i == 0) {
                    model.setValue(ENTRY_NODENAME, (Object)ResManager.loadKDString((String)"\u5f00\u59cb", (String)"WorkflowTestingPlanRecordPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]), i);
                    model.setValue(ENTRY_NODETYPE, (Object)" ", i);
                    continue;
                }
                HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)hiTasks.get(i - 1);
                model.setValue(ENTRY_NODENAME, (Object)hiTask.getTaskDefinitionKey(), i);
                model.setValue(ENTRY_NODETYPE, (Object)hiTask.getCategory(), i);
                if ("skip".equals(hiTask.getExecutionType())) {
                    model.setValue(ENTRY_EXECUTIONTYPE, (Object)" ", i);
                } else {
                    model.setValue(ENTRY_EXECUTIONTYPE, (Object)hiTask.getExecutionType(), i);
                }
                ILocaleString userName = WfUtils.findUserName((Long)hiTask.getAssigneeId());
                String typeInfo = approverInfoMap.get(String.format("%s_%s", hiTask.getTaskDefinitionKey(), hiTask.getAssigneeId()));
                if (WfUtils.isEmpty((String)typeInfo)) {
                    typeInfo = approverInfoMap.get(hiTask.getTaskDefinitionKey());
                }
                String assigneeIdStr = "";
                if (-1L != hiTask.getAssigneeId() && 0L != hiTask.getAssigneeId()) {
                    assigneeIdStr = "(" + hiTask.getAssigneeId() + ")";
                }
                String userInfo = userName.getLocaleValue() + assigneeIdStr;
                model.setValue(ENTRY_APPROVEINFO, (Object)((typeInfo == null ? "" : typeInfo) + " " + userInfo), i);
                model.setValue("subject", (Object)hiTask.getSubject().getLocaleValue(), i);
            }
            if (null != testingPlanEntity.getEndTime()) {
                model.setValue(ENTRY_NODENAME, (Object)ResManager.loadKDString((String)"\u7ed3\u675f", (String)"WorkflowTestingPlanRecordPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]), totalSize - 1);
                model.setValue(ENTRY_NODETYPE, (Object)" ", totalSize - 1);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "testingPlanDes": {
                this.updateDescriptionAndSavePlan(e.getReturnData());
            }
        }
    }

    public void onProgress(ProgressEvent arg0) {
        String refreshTimes = this.getPageCache().get(KEY_REFRESH_TIMES);
        if (null == refreshTimes) {
            refreshTimes = "1";
        }
        int times = Integer.parseInt(refreshTimes);
        arg0.setProgress(times * 5);
        if (times <= 20) {
            ++times;
            String planId = this.getPageCache().get(KEY_TESTINGPLAN_ID);
            TestingPlanEntity testingPlan = (TestingPlanEntity)this.getRepositoryService().findEntityById(Long.valueOf(Long.parseLong(planId)), "wf_testingplan");
            if ("failed".equals(testingPlan.getState()) || "successed".equals(testingPlan.getState())) {
                ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
                arg0.setProgress(100);
                progressBar.stop();
            } else {
                this.getPageCache().put(KEY_REFRESH_TIMES, String.valueOf(times));
            }
        } else {
            ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            progressBar.stop();
        }
        if (100 == arg0.getProgress()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PROGRESSBAR});
            this.getView().updateView();
        }
        this.refreshPage();
    }

    private void initEntrySelect(Long schemeId, Long procInstId) {
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        List elements = bpmnModel.getMainProcess().getFlowElementList();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (FlowElement element : elements) {
            if (!(element instanceof UserTask)) continue;
            String multiKey = BpmnModelUtil.getActivityNameMultiKey((String)element.getId());
            LocaleString elementName = (LocaleString)BpmnModelUtil.getMultiLangFieldValue((Long)procInstId, (String)multiKey, (String)element.getName());
            items.add(new ComboItem(elementName, element.getId()));
        }
        ComboEdit nodeName = (ComboEdit)this.getControl(ENTRY_NODENAME);
        nodeName.setComboItems(items);
        ComboEdit executionType = (ComboEdit)this.getControl(ENTRY_NODETYPE);
        executionType.setComboItems(this.getStencilTypeItems());
    }

    private List<ComboItem> getStencilTypeItems() {
        List configs = DesignerModelUtil.getStencilConfigs((String)"WorkflowModel", (boolean)true);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (StencilConfig config : configs) {
            if (!config.isVisible()) continue;
            String id = config.getId();
            HashSet<Boolean> resultSet = new HashSet<Boolean>();
            resultSet.add("StartSignalEvent".equals(id));
            resultSet.add("EndNoneEvent".equals(id));
            resultSet.add("UserTask".equals(id));
            resultSet.add("AuditTask".equals(id));
            resultSet.add("YunzhijiaTask".equals(id));
            resultSet.add("SSCApprove".equals(id));
            resultSet.add("SSCImageUpload".equals(id));
            resultSet.add("SSCImageUploadNew".equals(id));
            if (!WfUtils.isNotEmpty((String)id) || !resultSet.contains(Boolean.TRUE)) continue;
            items.add(new ComboItem(new LocaleString(config.getStencilName()), config.getId()));
        }
        return items;
    }

    private void showBill() {
        if (!this.checkTestingPlanVisiable()) {
            this.getView().showErrorNotification(WFMultiLangConstants.getTestingPlanDeleted());
            return;
        }
        String procInstanceId = this.getPageCache().get(KEY_PROCINSTANCE_ID);
        if (null == procInstanceId) {
            return;
        }
        TaskService taskService = this.getTaskService();
        Map billInfo = taskService.getBillForTaskCenter(Long.valueOf(Long.parseLong(procInstanceId)), "applyed");
        String entitynumber = null;
        String businesskey = null;
        String formkey = null;
        String formkeyview = null;
        if (billInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u67e5\u770b\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u518d\u8bd5\u3002", (String)"WorkflowTestingPlanRecordPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        entitynumber = (String)billInfo.get("entitynumber");
        businesskey = (String)billInfo.get("businesskey");
        formkey = (String)billInfo.get("formkey");
        formkeyview = (String)billInfo.get("formkeyview");
        boolean isBillExist = WfUtils.exist((String)entitynumber, (Object)businesskey);
        if (!isBillExist) {
            this.getView().showTipNotification(WFMultiLangConstants.getBillNotExistTip(), Integer.valueOf(3000));
        } else {
            if (null == formkey || 0 == formkey.trim().length()) {
                formkey = !WfUtils.isEmptyString((Object)formkeyview) ? formkeyview : entitynumber;
            }
            if (WfUtils.isEmpty((String)formkey) || WfUtils.isEmpty((String)businesskey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u67e5\u770b\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u518d\u8bd5\u3002", (String)"WorkflowTestingPlanRecordPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            String name = WfUtils.getEntityName((String)formkey, (String)businesskey).getLocaleValue();
            parameter.setCaption(name);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId((Object)businesskey);
            parameter.setFormId(formkey);
            parameter.addCustPlugin("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn");
            String appId = WfUtils.getAppIdForEntity((String)entitynumber);
            if (WfUtils.isNotEmpty((String)appId)) {
                parameter.getCustomParams().put("ServiceAppId", appId);
            }
            parameter.setAppId("a479ec06000000ac");
            this.showForm((FormShowParameter)parameter);
        }
    }

    private void showProc() {
        if (!this.checkTestingPlanVisiable()) {
            this.getView().showErrorNotification(WFMultiLangConstants.getTestingPlanDeleted());
            return;
        }
        String businessId = this.getPageCache().get(KEY_BUSINESS_ID);
        WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)businessId);
    }

    private void showPlans() {
        IFormView openedView;
        if (!this.checkTestingPlanVisiable()) {
            this.getView().showErrorNotification(WFMultiLangConstants.getTestingPlanDeleted());
            return;
        }
        String openedPageId = this.getPageCache().get(KEY_OPENED_PAGE_ID);
        if (null != openedPageId && (openedView = this.getView().getView(openedPageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        String schemeId = this.getPageCache().get(KEY_TESTINGSCHEME_ID);
        if (null == schemeId) {
            return;
        }
        IFormView settingsFormView = DesignerModelUtil.getTabControlView((IFormView)this.getView());
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_testingplan");
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qFilter = new QFilter("newschemeid", "=", (Object)Long.parseLong(schemeId));
        listFilterParameter.setFilter(qFilter);
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (settingsFormView != null) {
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setCustomParam("isOpenNewTab", (Object)true);
            parameter.setCustomParam("sp", this.getView().getFormShowParameter().getCustomParams().get("sp"));
            parameter.setMultiSelect(true);
            settingsFormView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(settingsFormView);
        } else {
            this.getView().showForm((FormShowParameter)parameter);
        }
        this.getPageCache().put(KEY_OPENED_PAGE_ID, parameter.getPageId());
    }

    private void showSceneDescription() {
        String state = (String)this.getModel().getValue(STATE);
        if (null != state && !"successed".equals(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8fd0\u884c\u6210\u529f\u4e0d\u80fd\u5b58\u6863\u3002", (String)"WorkflowTestingPlanRecordPlugin_4", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return;
        }
        String des = this.getPageCache().get(KEY_TESTINGPLAN_DES);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingplan_des");
        parameter.setCustomParam(KEY_TESTINGPLAN_DES, (Object)des);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTINGPLAN_DES));
        this.getView().showForm(parameter);
    }

    private void showErrorPage() {
        String error = this.getPageCache().get(KEY_TESTINGPLAN_ERROR);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_testingplan_error");
        parameter.setCustomParam(KEY_TESTINGPLAN_ERROR, (Object)error);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TESTINGPLAN_ERROR));
        this.getView().showForm(parameter);
    }

    private void updateDescriptionAndSavePlan(Object retData) {
        String op;
        if (null != retData && retData instanceof Map && "ok".equals(op = (String)((Map)retData).get("op"))) {
            String newDes = (String)((Map)retData).get("data");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String testingPlanId = (String)customParams.get("testingPlanId");
            BpmnNodeValidateUtil.markTestingPlanPassed((Long)Long.parseLong(testingPlanId), (ILocaleString)WfUtils.getMultiLangValue((String)newDes));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WorkflowTestingPlanRecordPlugin_3", (String)"bos-wf-unittest", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTNSAVEASPLAN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{LABEL_PASSED});
        }
    }

    private boolean checkTestingPlanVisiable() {
        String testingPlanId = this.getPageCache().get(KEY_TESTINGPLAN_ID);
        TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.getRepositoryService().findEntityById(Long.valueOf(testingPlanId), "wf_testingplan", "id");
        return testingPlanEntity != null;
    }
}

