/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testingplan.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;

public class WorkflowTestingPlanResultPlugin
extends AbstractWorkflowPlugin
implements IWorkflowDesigner {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BTNREFRESH = "btnrefresh";
    private static final String BTNVIEWTESTINGPLAN = "viewtestingplan";
    private static final String BILLNUMBER = "billnumber";
    private static final String VERSION = "version";
    private static final String STATE = "state";
    private static final String RECORD = "record";
    private static final String WORKFLOW_DESIGNER = "workflowdesigner";
    private static final String EXPECTED_DESIGNER = "expecteddesigner";
    private static final String TESTINGPLANID = "testingplanid";
    protected static final String MODEL_JSON = "model_json";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNREFRESH, BTNVIEWTESTINGPLAN});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnrefresh": {
                this.refresh();
                break;
            }
            case "viewtestingplan": {
                this.viewtTestingPlan();
                break;
            }
        }
    }

    private void viewtTestingPlan() {
        String testingPlanId = (String)this.getModel().getValue(TESTINGPLANID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_testingplan_edit");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setCustomParam("id", (Object)Long.valueOf(testingPlanId));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    protected void refresh() {
        WorkflowDesigner designer = (WorkflowDesigner)this.getControl(WORKFLOW_DESIGNER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String testingPlanId = (String)this.getModel().getValue(TESTINGPLANID);
        params.put(TESTINGPLANID, testingPlanId);
        params.put("key", WORKFLOW_DESIGNER);
        try {
            Map<String, Object> model = this.getDesignerInitData(params);
            designer.open("WorkflowModel", model);
            TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.getRepositoryService().findEntityById(Long.valueOf(testingPlanId), "wf_testingplan");
            this.setStateAndResult(testingPlanEntity);
        }
        catch (Exception e) {
            this.log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u6d41\u8f6c\u4fe1\u606f\u51fa\u9519\u3002%s", (String)"WorkflowTestingPlanResultPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String testingPlanId = (String)customParams.get(TESTINGPLANID);
        TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.getRepositoryService().findEntityById(Long.valueOf(testingPlanId), "wf_testingplan");
        this.getModel().setValue(BILLNUMBER, (Object)testingPlanEntity.getBillNo());
        this.getModel().setValue(VERSION, (Object)testingPlanEntity.getSchemeName());
        this.setStateAndResult(testingPlanEntity);
        Html record = (Html)this.getControl(RECORD);
        record.setConent(testingPlanEntity.getResultInfo());
    }

    private void setStateAndResult(TestingPlanEntity testingPlanEntity) {
        this.getModel().setValue(STATE, (Object)testingPlanEntity.getState());
        Html record = (Html)this.getControl(RECORD);
        record.setConent(String.format("<div style=\"line-height:1.8;\">%s</div>", testingPlanEntity.getResultInfo()));
    }

    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        Object testingPlanId = params.get(TESTINGPLANID);
        this.getModel().setValue(TESTINGPLANID, testingPlanId);
        TestingPlanEntity testingPlanEntity = (TestingPlanEntity)this.getRepositoryService().findEntityById(Long.valueOf(testingPlanId.toString()), "wf_testingplan");
        if (EXPECTED_DESIGNER.equals(params.get("key"))) {
            String graphXml = testingPlanEntity.getExpectedGraph();
            Label label = (Label)this.getControl("iamlabel");
            if (label != null) {
                label.setText(" ");
            }
            return this.getExpectedGraphData(graphXml);
        }
        String businesskey = testingPlanEntity.getNewBusinesskey();
        Long procInstId = this.getRuntimeService().getProcInstIdByBusKey(businesskey);
        Map data = null;
        try {
            data = ViewFlowchartUtil.getFlowchartInitData((Long)procInstId);
            if (data == null || data.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u8fd8\u672a\u542f\u52a8,\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowTestingPlanResultPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
                return null;
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u8fd0\u884c\u6d41\u7a0b\u56fe\u52a0\u8f7d\u51fa\u9519\uff1a%s", (String)"WorkflowTestingPlanResultPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), e.getMessage()));
            this.log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return data;
    }

    private Map<String, Object> getExpectedGraphData(String graphXml) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("graph_xml", graphXml);
        return result;
    }
}

