/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.unittest.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.unittest.util.TestingPlanUtil;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;

public class WfCaseReportPlugin
extends AbstractWorkflowPlugin {
    private static final String BTNSEARCH = "btnsearch";
    private static final String BTNRESET = "btnreset";
    private static final String BTNREFRESH = "btnrefresh";
    private static final String TOOLBAR = "toolbarap";
    private static final String BTN_MARK = "btnmark";
    private static final String INSERTFIELD = "insertfield";
    private static final String TEXTFIELD = "textfield";
    public static final String NUMBERMAPNAME = "numberMapName";
    public static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBAR);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long caseId = (Long)parameter.getCustomParam("caseId");
        switch (key) {
            case "btnsearch": 
            case "btnrefresh": {
                this.search(caseId);
                break;
            }
            case "btnreset": {
                this.reset();
                break;
            }
            case "btnmark": {
                this.markPassed();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long caseId = (Long)parameter.getCustomParam("caseId");
        this.search(caseId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName().toLowerCase();
        if (propertyName.equals(INSERTFIELD)) {
            String oldField = (String)this.getModel().getValue(TEXTFIELD);
            String tField = oldField.replace("{", "").replace("}", "");
            if (propertyName.equals(INSERTFIELD)) {
                this.getModel().setValue(TEXTFIELD, (Object)"");
            }
            String content = "";
            Object insertField = this.getModel().getValue(INSERTFIELD);
            String comma = tField.length() > 0 ? "," : "";
            String newField = tField + comma + insertField.toString();
            content = WfUtils.isEmptyString((Object)insertField) ? oldField : "{" + newField + "}";
            this.getModel().setValue(TEXTFIELD, (Object)content);
        }
    }

    private void search(Long caseId) {
        QFilter q = new QFilter("caseid", "=", (Object)caseId);
        List planList = this.getRepositoryService().findEntitiesByFilters("wf_testingplan", new QFilter[]{q});
        if (null == planList || planList.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        int size = planList.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRYENTITY, size);
        int index = 0;
        for (TestingPlanEntity tPlanEntity : planList) {
            Long schemeId = WfUtils.isNotEmpty((Long)tPlanEntity.getNewSchemeId()) ? tPlanEntity.getNewSchemeId() : tPlanEntity.getSchemeId();
            Map<String, String> approverInfoMap = TestingPlanUtil.getApproverInfo(schemeId);
            String businessKey = WfUtils.isEmptyString((Object)tPlanEntity.getNewBusinesskey()) ? tPlanEntity.getBusinesskey() : tPlanEntity.getNewBusinesskey();
            QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
            QFilter q2 = new QFilter("assigneeId", "!=", (Object)"0");
            List hiTasks = this.getRepositoryService().findEntitiesByFilters("wf_hitaskinst", new QFilter[]{q1, q2});
            StringBuilder paths = new StringBuilder("[").append(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"WfCaseReportPlugin_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            paths.append("]-->");
            String subject = "";
            if (null != hiTasks && !hiTasks.isEmpty()) {
                for (HistoricTaskInstanceEntity hiTask : hiTasks) {
                    subject = hiTask.getSubject().getLocaleValue();
                    paths.append("[");
                    paths.append(hiTask.getName().getLocaleValue());
                    paths.append("][");
                    ILocaleString userName = WfUtils.findUserName((Long)hiTask.getAssigneeId());
                    String userInfo = userName.getLocaleValue() + "(" + hiTask.getAssigneeId() + ")";
                    String typeInfo = WfUtils.isEmpty((String)approverInfoMap.get(hiTask.getTaskDefinitionKey())) ? "" : approverInfoMap.get(hiTask.getTaskDefinitionKey());
                    paths.append(typeInfo).append(userInfo).append("]-->");
                }
                if (null != tPlanEntity.getEndTime()) {
                    paths.append("[").append(ResManager.loadKDString((String)"\u7ed3\u675f", (String)"WfCaseReportPlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0])).append("]");
                }
            }
            model.setValue("plannumber", (Object)tPlanEntity.getNumber(), index);
            model.setValue("subject", (Object)subject, index);
            model.setValue("paths", (Object)paths, index);
            model.setValue("status", (Object)tPlanEntity.getState(), index);
            model.setValue("passed", (Object)tPlanEntity.isPassed(), index);
            model.setValue("pid", (Object)tPlanEntity.getId(), index);
            ++index;
        }
    }

    private void markPassed() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            for (int index : selectRows) {
                Object planId = this.getModel().getValue("pid", index);
                BpmnNodeValidateUtil.markTestingPlanPassed((Long)Long.parseLong(planId.toString()), null);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"WfCaseReportPlugin_0", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private void refresh() {
    }

    private void reset() {
        this.getModel().setValue(TEXTFIELD, (Object)"");
    }

    private void setFieldComboItems(String entityNumber) {
        MainEntityType entityType;
        HashMap<String, String> numberMapName = new HashMap<String, String>();
        MainEntityType mainType = entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = mainType.getAllFields().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (iter.hasNext()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (!(fieldProp instanceof IFieldHandle) || WfUtils.isNotEmpty((String)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName())) continue;
            if (!(fieldProp instanceof BasedataProp) && !(fieldProp instanceof AttachmentProp)) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
                numberMapName.put(item.getValue(), item.getCaption().toString());
            }
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERTFIELD);
        this.getPageCache().put(NUMBERMAPNAME, SerializationUtils.toJsonString(numberMapName));
        fieldCombo.setComboItems(items);
    }

    static class ReportListDataProvider
    extends ListDataProvider {
        protected QueryResult queryResult = null;
        protected Long caseId;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public ReportListDataProvider(Long caseId) {
            this.caseId = caseId;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            this.queryResult = new QueryResult();
            this.queryResult.setDataCount(this.getDataCount(null));
            DynamicObjectCollection data1 = null;
            DynamicObjectCollection data2 = null;
            String masterTableAlias = "a";
            String multiLangTableAlias = "b";
            String entityNumber = "wf_hitaskinst";
            String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fname", (String)"fname", (String)"name");
            String sql1 = String.format("select * from t_wf_testingplan a where a.fcaseid=%s", this.caseId);
            String sql2 = String.format("select a.fid," + nameSQL + ",a.fcreatedate,a.fendtime from t_wf_hiprocinst a left join t_wf_hiprocinst_l b on a.fid = b.fid where 1!=1", this.caseId);
            try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_hitaskinst.queryGridData.nodata", (DBRoute)DBRoute.workflow, (String)sql2);){
                data1 = ORM.create().query(sql1, null);
                data2 = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            }
            this.queryResult.setCollection(null);
            return null;
        }

        public int getRealCount() {
            return 0;
        }

        private int getDataCount(String caseId) {
            return 0;
        }
    }
}

