/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.unittest.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.HandleResult;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.unittest.util.TestingPlanUtil;

public class WfCasesListPlugin
extends AbstractListPlugin {
    protected static Log logger = LogFactory.getLog(WfCasesListPlugin.class);
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndelete";
    private static final String BUTTON_TESTINGPLAN = "opentestingplan";
    private static final String BTN_ADDTESTINGCASE = "addtestingcase";
    private static final String BTN_ADDTESTINGPLAN = "addtestingplan";
    private static final String KEY_EDITTESTINGCASE = "editTestingCase";
    private static final String BTN_OPENCASERESULT = "opencaseresult";
    private static final String BTN_RUN_TESTCASE = "runtestcase";
    private static final String BTN_RUNWITHEXTRACTED = "runwithextracted";
    private static final String CONFIRM_CALLBACK_DELETE = "delete_confirm";
    private static final String CONFIRM_CALLBACK_REPUBLISH = "republish_confirm";
    private static final String CASES_RESULTS_PAGEID = "cases_ret_pageId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_EDIT, BTN_DELETE, BUTTON_TESTINGPLAN, BTN_ADDTESTINGCASE, BTN_ADDTESTINGPLAN, BTN_RUN_TESTCASE, BTN_OPENCASERESULT});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADDTESTINGCASE});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "btnedit": {
                this.editTestingCase(rows);
                break;
            }
            case "btndelete": {
                this.delete(rows);
                break;
            }
            case "opentestingplan": {
                this.openTestingPlan();
                break;
            }
            case "addtestingplan": {
                this.openNewTestingPlan();
                break;
            }
            case "addtestingcase": {
                this.openAddTestingCase();
                break;
            }
            case "runtestcase": {
                this.runTestCase(rows);
                break;
            }
            case "runwithextracted": {
                this.runWithExtracted(rows);
                break;
            }
            case "opencaseresult": {
                this.openCaseResult();
                break;
            }
        }
    }

    private void openCaseResult() {
        IFormView tabView = DesignerModelUtil.getTabControlView((IFormView)this.getView());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_testcaseresult");
        String pageId = null;
        IFormView openedView = null;
        pageId = this.getPageCache().get(CASES_RESULTS_PAGEID);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        if (tabView != null) {
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            tabView.showForm(parameter);
            this.getView().sendFormAction(tabView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            this.getView().showForm(parameter);
        }
        pageId = parameter.getPageId();
        this.getPageCache().put(CASES_RESULTS_PAGEID, pageId);
    }

    private void delete(ListSelectedRowCollection rows) {
        if (WfUtils.isNotEmptyForCollection((Collection)rows)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\uff1f", (String)"WfCasesListPlugin_13", (String)"bos-wf-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_DELETE));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6d4b\u8bd5\u6848\u4f8b\uff01", (String)"WfCasesListPlugin_14", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private void runWithExtracted(ListSelectedRowCollection rows) {
        if (this.validateSelected(rows)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u63d0\u53d6\u65f6\u7684\u6d41\u7a0b\u8fd0\u884c\u6d4b\u8bd5\u6848\u4f8b\u4f1a\u91cd\u65b0\u5bfc\u5165\u63d0\u53d6\u7684\u6d41\u7a0b\u548c\u65b9\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"WfCasesListPlugin_15", (String)"bos-wf-unittest", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_REPUBLISH));
        }
    }

    private void editTestingCase(ListSelectedRowCollection rows) {
        if (this.validateSelectOneItem(rows)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wf_testcase_edit");
            parameter.setCustomParam("id", rows.get(0).getPrimaryKeyValue());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_EDITTESTINGCASE));
            this.getView().showForm(parameter);
        }
    }

    private void openTestingPlan() {
        ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
        if (list != null && WfUtils.isNotEmptyForCollection((Collection)list)) {
            ArrayList<Long> caseIds = new ArrayList<Long>();
            for (ListSelectedRow selectedRow : list) {
                caseIds.add((Long)selectedRow.getPrimaryKeyValue());
            }
            TestingPlanUtil.openTestingPlanList(this.getView(), caseIds, "");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6848\u4f8b!", (String)"WfCasesListPlugin_16", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
    }

    private void openNewTestingPlan() {
        ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
        if (list.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6848\u4f8b!", (String)"WfCasesListPlugin_16", (String)"bos-wf-unittest", (Object[])new Object[0]));
        } else {
            IFormView parentView = DesignerModelUtil.getTabControlView((IFormView)this.getView());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("id", (Object)-1L);
            parameter.setFormId("wf_testingplan_edit");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "testing_plan"));
            if (parentView != null) {
                parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.EDIT);
                parentView.showForm(parameter);
                this.getView().sendFormAction(parentView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                this.getView().showForm(parameter);
            }
        }
    }

    private void openAddTestingCase() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_ADDTESTINGCASE));
        parameter.setFormId("wf_testcase_searchscheme");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(true);
        this.getView().showForm(parameter);
    }

    private void runTestCase(ListSelectedRowCollection rows) {
        if (this.validateSelected(rows)) {
            this.runTestCase(rows, false);
        }
    }

    private void runTestCase(ListSelectedRowCollection rows, boolean republish) {
        try {
            ArrayList<Long> caseIds = new ArrayList<Long>();
            for (ListSelectedRow row : rows) {
                caseIds.add((Long)row.getPrimaryKeyValue());
            }
            HandleResult ret = TestingPlanUtil.runTestingCase(caseIds, republish);
            if (ret.isAllSuccessed()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\uff01", (String)"WfCasesListPlugin_17", (String)"bos-wf-unittest", (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (ret.isAllFailed()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u5931\u8d25\uff01 %s", (String)"WfCasesListPlugin_18", (String)"bos-wf-unittest", (Object[])new Object[0]), ret.getReason()));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8ba1\u5212\u542f\u52a8\u6210\u529f %s \u4e2a\uff0c \u542f\u52a8\u5931\u8d25 %s \u4e2a\uff01", (String)"WfCasesListPlugin_19", (String)"bos-wf-unittest", (Object[])new Object[0]), ret.getSuccessed(), ret.getFailed()), Integer.valueOf(3000));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", (String)"WfCasesListPlugin_20", (String)"bos-wf-unittest", (Object[])new Object[0]), e.getMessage()));
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if (CONFIRM_CALLBACK_DELETE.equals(callBackId)) {
            this.deleteTesingCase();
            ((IListView)this.getView()).refresh();
        } else if (CONFIRM_CALLBACK_REPUBLISH.equals(callBackId)) {
            this.runTestCase(((IListView)this.getView()).getSelectedRows(), true);
        }
    }

    private void deleteTesingCase() {
        RepositoryService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        Long id = 0L;
        int failed = 0;
        int successed = 0;
        int total = rows.size();
        StringBuilder sb = new StringBuilder();
        for (ListSelectedRow listSelectedRow : rows) {
            try {
                id = (Long)listSelectedRow.getPrimaryKeyValue();
                service.deleteTestingCaseDatas(id);
                ++successed;
            }
            catch (Exception e) {
                ++failed;
                sb.append("[").append(id).append("]").append(e.getMessage()).append("; ");
                logger.debug(String.format("\u5220\u9664\u6848\u4f8b %s \u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", id, WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        if (successed == total) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"WfCasesListPlugin_21", (String)"bos-wf-unittest", (Object[])new Object[0]));
        } else if (failed == total) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", (String)"WfCasesListPlugin_22", (String)"bos-wf-unittest", (Object[])new Object[0]), sb.toString()));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f %s \u4e2a\uff0c\u5220\u9664\u5931\u8d25 %s \u4e2a\uff0c\u539f\u56e0\uff1a%s", (String)"WfCasesListPlugin_23", (String)"bos-wf-unittest", (Object[])new Object[0]), successed, failed, sb.toString()));
        }
    }

    private boolean validateSelectOneItem(ListSelectedRowCollection rows) {
        if (rows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6d4b\u8bd5\u6848\u4f8b\uff01", (String)"WfCasesListPlugin_24", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateSelected(ListSelectedRowCollection rows) {
        if (WfUtils.isEmptyForCollection((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8fd0\u884c\u7684\u6d4b\u8bd5\u6848\u4f8b\uff01", (String)"WfCasesListPlugin_25", (String)"bos-wf-unittest", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equals(KEY_EDITTESTINGCASE)) {
            ((IListView)this.getView()).refresh();
        }
        if (e.getActionId().equals(BTN_ADDTESTINGCASE)) {
            Long schemeId = 1L;
            try {
                WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                TestingPlanEntity testingPlan = service.getRepositoryService().convertProcessInstanceToCase(schemeId);
                this.showTestingPlanEditPage(testingPlan);
            }
            catch (Exception e2) {
                logger.error((Throwable)e2);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(CASES_RESULTS_PAGEID);
    }

    private void showTestingPlanEditPage(TestingPlanEntity testingPlan) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_testplan_edit");
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("id", (Object)testingPlan.getId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }
}

