/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.unittest.plugin.devops;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.unittest.plugin.devops.TestUtil;

public class JumpConditionPlugin
implements IWorkflowPlugin {
    public static final Log logger = LogFactory.getLog(JumpConditionPlugin.class);
    public static final String CONSENT = "Consent";
    public static final String YUN_ZHI_JIA_TASK = "YunzhijiaTask";
    public static final String AUDIT_TASK = "AuditTask";
    public static final String ACTIVITY_NAME = "activityname";

    public boolean hasTrueCondition(AgentExecution execution) {
        try {
            Thread.sleep(TestUtil.getWfConfCenterSleepTimes());
        }
        catch (InterruptedException e) {
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        String name = execution.getCurrentFlowElement().getName();
        String entityNumber = execution.getEntityNumber();
        String businessKey = execution.getBusinessKey();
        QFilter filter = new QFilter("entitynumber", "=", (Object)entityNumber);
        filter.and("businesskey", "=", (Object)businessKey);
        filter.and(ACTIVITY_NAME, "=", (Object)name);
        Object[] load = BusinessDataServiceHelper.load((String)"wf_hicomment", (String)"taskid,activityname,resultnumber,groupid,category", (QFilter[])filter.toArray(), (String)"time desc");
        if (load == null || load.length == 0) {
            return false;
        }
        logger.debug("\u67e5\u8be2\u51fa\u6765\u7684\u4efb\u52a1\u6267\u884c\u7ed3\u679c\uff1a" + Arrays.toString(load));
        String category = execution.getCurrentFlowElement().getType();
        if (YUN_ZHI_JIA_TASK.equals(category)) {
            return this.triage(name, (DynamicObject[])load);
        }
        if (AUDIT_TASK.equals(category)) {
            return this.approval(name, (DynamicObject[])load);
        }
        return false;
    }

    private boolean approval(String name, DynamicObject[] load) {
        for (DynamicObject dyn : load) {
            String resultNumber;
            String activityName = dyn.getString(ACTIVITY_NAME);
            if (!StringUtils.isNotBlank((CharSequence)activityName) || !activityName.equals(name) || !CONSENT.equals(resultNumber = dyn.getString("resultnumber"))) continue;
            logger.debug("\u81ea\u52a8\u5ba1\u6279 \u8df3\u8fc7\u8282\u70b9\uff1a" + activityName);
            return true;
        }
        return false;
    }

    private boolean triage(String name, DynamicObject[] load) {
        for (DynamicObject dyn : load) {
            String groupId;
            String activityName = dyn.getString(ACTIVITY_NAME);
            if (!StringUtils.isNotBlank((CharSequence)activityName) || !activityName.equals(name)) continue;
            String resultNumber = dyn.getString("resultnumber");
            String taskId = dyn.getLong("taskid") + "";
            if (!taskId.equals(groupId = dyn.getString("groupid")) || !CONSENT.equals(resultNumber)) continue;
            logger.debug("\u4f1a\u5ba1\u8282\u70b9 \u81ea\u52a8\u5ba1\u6279 \u8df3\u8fc7\u8282\u70b9\uff1a" + activityName);
            return true;
        }
        return false;
    }
}

