/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.unittest.scheme;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.comparator.IntegerValueComparator;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import org.junit.Assert;
import org.junit.Test;

public class BpmnDiffUnittest
extends Assert {
    protected ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testNoModified() {
        String src = "{\"name\":\"Tom\"}";
        String tgt = "{\"name\":\"Tom\"}";
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)BpmnDiffUtil.getNode((String)src), (JsonNode)BpmnDiffUtil.getNode((String)tgt));
        BpmnDiffUnittest.assertTrue((patch != null ? 1 : 0) != 0);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)patch.toString());
    }

    @Test
    public void testListBaseAdded() {
        String src = "{\"items\":[\"A\",\"B\"]}";
        String tgt = "{\"items\":[\"A\",\"B\",\"C\"]}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertTrue((boolean)"[{\"op\": \"add\", \"path\": \"/items/[_hashcode_:67]\", \"value\": \"C\"}]".equals(patch.toString()));
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        BpmnDiffUnittest.assertTrue((boolean)"{\"items\":[{\"_value_\":\"C\"}]}".equals(bpmnPatch.toString()));
        JsonNode patchdSource = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)bpmnPatch);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchdSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testListBaseModified() {
        JsonNode target;
        String src = "{\"items\":[\"A\",\"C\",\"F\",\"B\",\"D\"]}";
        String tgt = "{\"items\":[\"D\",\"B\",\"E\",\"A\",\"C\"]}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)(target = BpmnDiffUtil.getNode((String)tgt)));
        BpmnDiffUnittest.assertTrue((patch != null ? 1 : 0) != 0);
        String diff = "[{\"op\": \"replace\", \"path\": \"/items/[_hashcode_:70]\", \"oldValue\": \"F\", \"value\": null}, {\"op\": \"add\", \"path\": \"/items/[_hashcode_:69]\", \"value\": \"E\"}]";
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patch.toString()));
        String patchStr = "{\"items\":[{\"_hashcode_\":\"70\",\"_action_\":\"remove\"},{\"_value_\":\"E\"}]}";
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        BpmnDiffUnittest.assertTrue((boolean)patchStr.equals(bpmnPatch.toString()));
        JsonNode patchdSource = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)bpmnPatch);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchdSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testListBaseMerge() {
        String src = ResManager.loadKDString((String)"{\"properties\":{\"itemId\":\"wzk_auto_bug_test_AutoTask0\",\"name\":\"\u81ea\u52a8\",\"service\":{\"entityId\":\"/EMRPGY7E0PO\",\"entityName\":\"\u6d88\u606f\u7c7b\u578b\"}}}", (String)"BpmnDiffUnittest_0", (String)"bos-wf-unittest", (Object[])new Object[0]);
        String patch = "{\"properties\":{\"service\":{\"extItf\":[{\"_hashcode_\":\"1466631090\",\"_action_\":\"remove\"},{\"_value_\":\"{\\\"type\\\":\\\"class\\\", \\\"value\\\":\\\"uuuppp\\\"}\"}]}}}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.applyPatch((JsonNode)source, (String)patch);
        JsonNode extItf = target.get("properties").get("service").get("extItf");
        BpmnDiffUnittest.assertNotNull((Object)extItf);
        BpmnDiffUnittest.assertTrue((boolean)extItf.isArray());
        ArrayNode arr = (ArrayNode)extItf;
        BpmnDiffUnittest.assertTrue((arr.size() == 1 ? 1 : 0) != 0);
        BpmnDiffUnittest.assertTrue((boolean)"\"{\\\"type\\\":\\\"class\\\", \\\"value\\\":\\\"uuuppp\\\"}\"".equals(arr.get(0).toString()));
    }

    @Test
    public void testDiffOne() {
        String src = ResManager.loadKDString((String)"{\"id\": \"acwzy\",\"description\": \"\u51b3\u7b56\u7ed3\u679c\",\"type\": \"audit\",\"dataType\": \"enum\"}", (String)"BpmnDiffUnittest_1", (String)"bos-wf-unittest", (Object[])new Object[0]);
        String tgt = ResManager.loadKDString((String)"{\"id\": \"acwzy\",\"description\": \"\",\"name\": \"\u540d\u79f0\"}", (String)"BpmnDiffUnittest_2", (String)"bos-wf-unittest", (Object[])new Object[0]);
        String diff = "[{\"op\": \"replace\", \"path\": \"/dataType\", \"oldValue\": \"enum\", \"value\": null}, {\"op\": \"replace\", \"path\": \"/type\", \"oldValue\": \"audit\", \"value\": null}, {\"op\": \"add\", \"path\": \"/name\", \"value\": \"\u540d\u79f0\"}, {\"op\": \"replace\", \"path\": \"/description\", \"oldValue\": \"\u51b3\u7b56\u7ed3\u679c\", \"value\": \"\"}]";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertNotNull((Object)patch);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patch.toString()));
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        String bpmnDiff = ResManager.loadKDString((String)"{\"dataType\":null,\"type\":null,\"description\":\"\",\"name\":\"\u540d\u79f0\"}", (String)"BpmnDiffUnittest_3", (String)"bos-wf-unittest", (Object[])new Object[0]);
        BpmnDiffUnittest.assertTrue((boolean)bpmnDiff.equals(bpmnPatch.toString()));
        JsonNode patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (String)bpmnDiff);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testDiffTwo() {
        String src = ResManager.loadKDString((String)"{\"id\":\"node1\",\"childShapes\":[{\"resourceId\":\"wzk_diff_01_UserTask3\",\"properties\":{\"number\":\"StartSignalEvent1\",\"name\":\"\u5f00\u59cb\"},\"stencil\":{\"id\":\"UserTask\"},\"outgoing\":[{\"resourceId\":\"wzk_diff_01_SequenceFlow2\"}]}]}", (String)"BpmnDiffUnittest_4", (String)"bos-wf-unittest", (Object[])new Object[0]);
        String tgt = "{\"id\":\"node1\",\"childShapes\":[{\"resourceId\":\"wzk_diff_01_UserTask3\",\"properties\":{\"number\":\"xxx\"},\"stencil\":{\"id\":\"UserTask\"},\"outgoing\":[{\"resourceId\":\"wzk_diff_01_SequenceFlow2\"}]},{\"resourceId\":\"wzk_diff_01_AddedTask\",\"properties\":{\"number\":\"newTask\"},\"stencil\":{\"id\":\"AuditTask\"},\"outgoing\":[{\"resourceId\":\"wzk_diff_01_SequenceFlow8\"}]}]}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "[{\"op\":\"add\",\"path\":\"/childShapes/[resourceId:wzk_diff_01_AddedTask]\",\"value\":{\"resourceId\":\"wzk_diff_01_AddedTask\",\"properties\":{\"number\":\"newTask\"},\"stencil\":{\"id\":\"AuditTask\"},\"outgoing\":[{\"resourceId\":\"wzk_diff_01_SequenceFlow8\"}]}},{\"op\":\"replace\",\"path\":\"/childShapes/[resourceId:wzk_diff_01_UserTask3]/properties/name\",\"oldValue\":\"\u5f00\u59cb\",\"value\":null},{\"op\":\"replace\",\"path\":\"/childShapes/[resourceId:wzk_diff_01_UserTask3]/properties/number\",\"oldValue\":\"StartSignalEvent1\",\"value\":\"xxx\"},{\"op\":\"add\",\"path\":\"/childShapes/[resourceId:wzk_diff_01_UserTask3]/_inherit_\",\"value\":true}]";
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertNotNull((Object)patch);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patch.toString().replaceAll("\\s+", "")));
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        String bpmnDiff = "{\"childShapes\":[{\"resourceId\":\"wzk_diff_01_UserTask3\",\"properties\":{\"name\":null,\"number\":\"xxx\"},\"_inherit_\":true},{\"resourceId\":\"wzk_diff_01_AddedTask\",\"properties\":{\"number\":\"newTask\"},\"stencil\":{\"id\":\"AuditTask\"},\"outgoing\":[{\"resourceId\":\"wzk_diff_01_SequenceFlow8\"}]}]}";
        BpmnDiffUnittest.assertTrue((boolean)bpmnDiff.equals(bpmnPatch.toString()));
        JsonNode patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (String)bpmnDiff);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testDiffThree() {
        String src = "{\"decisionOptions\":[{\"id\":\"15373382358900\",\"number\":\"Consent\",\"name\":\"\u540c\u610f\",\"auditType\":\"approve\",\"defaultDecision\":true},{\"id\":\"15373382358901\",\"number\":\"Reject\",\"rejectOptions\":[{\"itemId\":\"wzk_diff_01_UserTask3\",\"name\":\"wzk\u5355\u636e\u6d4b\u8bd5\u63d0\u4ea4\"}],\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"defaultDecision\":false}]}";
        String tgt = "{\"decisionOptions\":[{\"id\":\"15373382358900\",\"number\":\"Consent\",\"name\":\"\u540c\u610f\",\"auditType\":\"approve\",\"defaultDecision\":false},{\"id\":\"15373382358901\",\"number\":\"Reject\",\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"defaultDecision\":true,\"rejectOptions\":[{\"itemId\":\"wzk_diff_01_UserTask3\",\"name\":\"wzk\u5355\u636e\u6d4b\u8bd5\u63d0\u4ea4\",\"attributes\":{},\"extensionElements\":{}}]},{\"id\":\"1537338235912\",\"number\":\"decision\",\"name\":\"\u51b3\u7b56\u9879\u7ec8\u6b62\",\"auditType\":\"terminate\",\"defaultDecision\":false}]}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "[{\"op\": \"add\", \"path\": \"/decisionOptions/[id:1537338235912]\", \"value\": {\"id\":\"1537338235912\",\"number\":\"decision\",\"name\":\"\u51b3\u7b56\u9879\u7ec8\u6b62\",\"auditType\":\"terminate\",\"defaultDecision\":false}}, {\"op\": \"replace\", \"path\": \"/decisionOptions/[id:15373382358900]/defaultDecision\", \"oldValue\": true, \"value\": false}, {\"op\": \"add\", \"path\": \"/decisionOptions/[id:15373382358900]/_inherit_\", \"value\": true}, {\"op\": \"replace\", \"path\": \"/decisionOptions/[id:15373382358901]/defaultDecision\", \"oldValue\": false, \"value\": true}, {\"op\": \"add\", \"path\": \"/decisionOptions/[id:15373382358901]/rejectOptions/[itemId:wzk_diff_01_UserTask3]/attributes\", \"value\": {}}, {\"op\": \"add\", \"path\": \"/decisionOptions/[id:15373382358901]/rejectOptions/[itemId:wzk_diff_01_UserTask3]/extensionElements\", \"value\": {}}, {\"op\": \"add\", \"path\": \"/decisionOptions/[id:15373382358901]/rejectOptions/[itemId:wzk_diff_01_UserTask3]/_inherit_\", \"value\": true}, {\"op\": \"add\", \"path\": \"/decisionOptions/[id:15373382358901]/_inherit_\", \"value\": true}]";
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertNotNull((Object)patch);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patch.toString()));
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        String bpmnDiff = "{\"decisionOptions\":[{\"id\":\"15373382358900\",\"defaultDecision\":false,\"_inherit_\":true},{\"id\":\"15373382358901\",\"defaultDecision\":true,\"rejectOptions\":[{\"itemId\":\"wzk_diff_01_UserTask3\",\"attributes\":{},\"extensionElements\":{},\"_inherit_\":true}],\"_inherit_\":true},{\"id\":\"1537338235912\",\"number\":\"decision\",\"name\":\"\u51b3\u7b56\u9879\u7ec8\u6b62\",\"auditType\":\"terminate\",\"defaultDecision\":false}]}";
        BpmnDiffUnittest.assertTrue((boolean)bpmnDiff.equals(bpmnPatch.toString()));
        JsonNode patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (String)bpmnDiff);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testDiffFour() {
        String src = "{\"skipCondition\":{\"elementid\":\"JDJT_CCJKD_01_AuditTask11\",\"type\":\"skip\",\"property\":\"skipCondition\",\"expression\":\"${ notempty model.billno }\",\"description\":{\"zh_TW\":\" \",\"zh_CN\":\" \"},\"entryentity\":[{\"valuetype\":\"commVal\",\"id\":\"486033733783174157\",\"paramnumber\":\"model.billno\",\"operation\":\"notempty\",\"value\":\"\"}],\"showtext\":{\"zh_TW\":\"\u5b50\u516c\u53f8\u8ca0\u8cac\u4eba\",\"zh_CN\":\"\u5b50\u516c\u53f8\u8d1f\u8d23\u4eba\"}}}";
        String tgt = "{\"skipCondition\":{\"elementid\":\"JDJT_CCJKD_01_AuditTask11\",\"expression\":\"${ model.approveamount <= 200000 }\",\"property\":\"skipCondition\",\"type\":\"skip\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\" \",\"rightbracket\":\" \",\"paramnumber\":\"model.approveamount\",\"logic\":\" \",\"operation\":\"<=\",\"value\":\"200000\",\"id\":\"486033733783174157\"}],\"showtext\":{\"zh_TW\":\"\u5b50\u516c\u53f8\u8ca0\u8cac\u4eba\",\"zh_CN\":\"\u5b50\u516c\u53f8\u8d1f\u8d23\u4eba\"},\"description\":{\"zh_TW\":\" \",\"zh_CN\":\" \"}}}";
        JsonPatch patch = BpmnDiffUtil.getJsonDiffPatch((String)src, (String)tgt);
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        JsonNode type = bpmnPatch.get("skipCondition").get("type");
        BpmnDiffUnittest.assertNotNull((Object)type);
        BpmnDiffUnittest.assertTrue((boolean)"skip".equals(type.asText()));
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        JsonNode patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)bpmnPatch);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testListItem() {
        String src = ResManager.loadKDString((String)"{\"decisionOptions\":[{\"number\":\"Consent\",\"name\":\"\u540c\u610f\",\"auditType\":\"approve\",\"id\":\"-28227835751361970\",\"defaultDecision\":true}]}", (String)"BpmnDiffUnittest_5", (String)"bos-wf-unittest", (Object[])new Object[0]);
        String tgt = ResManager.loadKDString((String)"{\"decisionOptions\":[{\"number\":\"OK\",\"name\":\"\u540c\u610f\",\"auditType\":\"approve\",\"id\":\"-28227835751361970\",\"defaultDecision\":true},{\"number\":\"Reject\",\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"id\":\"-28227835751573071\"}]}", (String)"BpmnDiffUnittest_6", (String)"bos-wf-unittest", (Object[])new Object[0]);
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "[{\"op\": \"add\", \"path\": \"/decisionOptions/[id:-28227835751573071]\", \"value\": {\"number\":\"Reject\",\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"id\":\"-28227835751573071\"}}, {\"op\": \"replace\", \"path\": \"/decisionOptions/[id:-28227835751361970]/number\", \"oldValue\": \"Consent\", \"value\": \"OK\"}, {\"op\": \"add\", \"path\": \"/decisionOptions/[id:-28227835751361970]/_inherit_\", \"value\": true}]";
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertNotNull((Object)patch);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patch.toString()));
        String bpmnDiff = ResManager.loadKDString((String)"{\"decisionOptions\":[{\"id\":\"-28227835751361970\",\"number\":\"OK\",\"_inherit_\":true},{\"number\":\"Reject\",\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"id\":\"-28227835751573071\"}]}", (String)"BpmnDiffUnittest_7", (String)"bos-wf-unittest", (Object[])new Object[0]);
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        BpmnDiffUnittest.assertTrue((boolean)bpmnDiff.equals(bpmnPatch.toString()));
        JsonNode patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (String)bpmnDiff);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
        src = "{\"decisionOptions\":[]}";
        source = BpmnDiffUtil.getNode((String)src);
        patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)bpmnPatch);
        String expect = ResManager.loadKDString((String)"{\"decisionOptions\":[{\"number\":\"Reject\",\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"id\":\"-28227835751573071\"}]}", (String)"BpmnDiffUnittest_8", (String)"bos-wf-unittest", (Object[])new Object[0]);
        BpmnDiffUnittest.assertTrue((boolean)expect.equals(patchSource.toString()));
        src = "{}";
        source = BpmnDiffUtil.getNode((String)src);
        patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)bpmnPatch);
        expect = ResManager.loadKDString((String)"{\"decisionOptions\":[{\"number\":\"Reject\",\"name\":\"\u9a73\u56de\",\"auditType\":\"reject\",\"id\":\"-28227835751573071\"}]}", (String)"BpmnDiffUnittest_8", (String)"bos-wf-unittest", (Object[])new Object[0]);
        BpmnDiffUnittest.assertTrue((boolean)expect.equals(patchSource.toString()));
    }

    @Test
    public void testConditionalRule() {
        String src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${ model.reason == \\\"jhhh\\\" && model.ispresent == 0 }\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461487382118544384\",\"paramnumber\":\"model.reason\",\"logic\":\"&&\",\"operation\":\"==\",\"value\":\"jhhh\"},{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461488358988724224\",\"paramnumber\":\"model.ispresent\",\"logic\":\"\",\"operation\":\"==\",\"value\":\"0\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"description\":{\"zh_TW\":\" \",\"zh_CN\":\" \"},\"validtime\":null,\"type\":\"sequenceFlow\"},\"defaultflow\":false,\"name\":\"hhhh\"}";
        String tgt = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${ model.amount == 888 && model.ispresent == 0 }\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461487382118544384\",\"paramnumber\":\"model.amount\",\"logic\":\"&&\",\"operation\":\"==\",\"value\":\"888\"},{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461488358988724224\",\"paramnumber\":\"model.ispresent\",\"logic\":\"\",\"operation\":\"==\",\"value\":\"0\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"description\":{\"zh_TW\":\" \",\"zh_CN\":\" \"},\"validtime\":null,\"type\":\"sequenceFlow\"},\"defaultflow\":false,\"name\":\"hhhh\"}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "{\"conditionalRule\":{\"entryentity\":[{\"id\":\"461487382118544384\",\"paramnumber\":\"model.amount\",\"value\":\"888\",\"_inherit_\":true}],\"expression\":\"${ model.amount == 888 && model.ispresent == 0 }\",\"type\":\"sequenceFlow\",\"_inherit_\":true}}";
        JsonNode patchNode = BpmnDiffUtil.getBpmnPatch((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patchNode.toString()));
        JsonNode patchSource = BpmnDiffUtil.applyPatch((JsonNode)source, (String)diff);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchSource);
        BpmnDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
        src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${  model.ispresent == 0  }\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461488358988724224\",\"paramnumber\":\"model.ispresent\",\"logic\":\"\",\"operation\":\"==\",\"value\":\"0\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"description\":{\"zh_TW\":\" \",\"zh_CN\":\" \"},\"validtime\":null,\"type\":\"sequenceFlow\"},\"defaultflow\":false,\"name\":\"hhhh\"}";
        source = BpmnDiffUtil.getNode((String)src);
        JsonNode ret = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)patchNode);
        this.checkConditionalRule(ret, "\"${model.ispresent==0}\"");
        src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{},\"defaultflow\":false,\"name\":\"hhhh\"}";
        source = BpmnDiffUtil.getNode((String)src);
        ret = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)patchNode);
        this.checkConditionalRule(ret, "\"\"");
        src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{},\"defaultflow\":false,\"name\":\"hhhh\"}";
        source = BpmnDiffUtil.getNode((String)src);
        ret = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)patchNode);
        this.checkConditionalRule(ret, "\"\"");
    }

    private void checkConditionalRule(JsonNode ret, String expression) {
        ArrayNode arr = (ArrayNode)ret.get("conditionalRule").get("entryentity");
        Iterator iterator = arr.iterator();
        JsonNode node = null;
        while (iterator.hasNext()) {
            node = (JsonNode)iterator.next();
            if (!"461487382118544384".equals(node.get("id"))) continue;
            BpmnDiffUnittest.fail((String)ResManager.loadKDString((String)"\u7236\u8282\u70b9\u5220\u9664\u7684\u5c5e\u6027\u5728\u5b50\u8282\u70b9\u8fd8\u5b58\u5728\u3002", (String)"BpmnDiffUnittest_9", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        BpmnDiffUnittest.assertTrue((boolean)expression.equals(ret.get("conditionalRule").get("expression").toString().replaceAll("\\s+", "")));
    }

    @Test
    public void testConditionalRuleOne() {
        String src = "{\"childShapes\":[{\"resourceId\":\"wzk_scheme_test_SequenceFlow6\",\"properties\":{\"itemId\":\"wzk_scheme_test_SequenceFlow6\",\"number\":\"SequenceFlow6\"}}]}";
        String tgt = "{\"childShapes\":[{\"resourceId\":\"wzk_scheme_test_SequenceFlow6\",\"properties\":{\"itemId\":\"wzk_scheme_test_SequenceFlow6\",\"number\":\"SequenceFlow6\",\"conditionalRule\":{\"description\":{\"zh_CN\":\" \",\"zh_TW\":\" \"},\"elementid\":\"wzk_scheme_test_SequenceFlow6\",\"entryentity\":[{\"id\":\"498368927982687232\",\"leftbracket\":\"\",\"logic\":\"\",\"operation\":\"==\",\"paramnumber\":\"model.reason\",\"rightbracket\":\"\",\"value\":\"test\",\"valuetype\":\"commVal\"}],\"expression\":\"${ model.reason == \\\"test\\\" }\",\"property\":\"conditionalRule\",\"showtext\":{\"zh_CN\":\"test\",\"zh_TW\":\"test\"},\"type\":\"sequenceFlow\"},\"defaultflow\":false,\"name\":\"test\"}}]}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        JsonNode patch = BpmnDiffUtil.getBpmnPatch((JsonNode)source, (JsonNode)target);
        src = "{\"childShapes\":[{\"resourceId\":\"wzk_scheme_test_SequenceFlow6\",\"properties\":{\"itemId\":\"wzk_scheme_test_SequenceFlow6\",\"number\":\"SequenceFlow6\",\"defaultflow\":false,\"conditionalRule\":{\"description\":{\"zh_CN\":\" \",\"zh_TW\":\" \"},\"elementid\":\"wzk_scheme_test_SequenceFlow6\",\"entryentity\":[{\"id\":\"498377294763530240\",\"leftbracket\":\"\",\"logic\":\"\",\"operation\":\"==\",\"paramnumber\":\"model.amount\",\"rightbracket\":\"\",\"value\":\"111\",\"valuetype\":\"commVal\"}],\"expression\":\"${ model.amount == 111 }\",\"property\":\"conditionalRule\",\"showtext\":{\"zh_CN\":\"111\",\"zh_TW\":\"111\"},\"type\":\"sequenceFlow\"},\"name\":\"111\"}}]}";
        source = BpmnDiffUtil.getNode((String)src);
        target = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)patch);
        JsonNode conditionalRule = target.get("childShapes").get(0).get("properties").get("conditionalRule");
        JsonNode firstItem = conditionalRule.get("entryentity").get(0);
        JsonNode logic = firstItem.get("logic");
        BpmnDiffUnittest.assertTrue((logic != null && !"".equals(logic.asText().trim()) ? 1 : 0) != 0);
        String expression = conditionalRule.get("expression").asText();
        BpmnDiffUnittest.assertTrue((boolean)"${ model.amount == 111 && model.reason == \"test\" }".equals(expression));
    }

    @Test
    public void testConditionalRuleTwo() {
        String src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${  model.reason == \\\"ok\\\"  }\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"123456789\",\"paramnumber\":\"model.reason\",\"logic\":\"\",\"operation\":\"==\",\"value\":\"ok\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"type\":\"sequenceFlow\"}}";
        String tgt = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${  model.reason == \\\"ok\\\" || model.amount == 333 }\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"123456789\",\"paramnumber\":\"model.reason\",\"logic\":\"||\",\"operation\":\"==\",\"value\":\"ok\"},{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"987654321\",\"paramnumber\":\"model.amount\",\"logic\":\"\",\"operation\":\">\",\"value\":\"333\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"type\":\"sequenceFlow\"}}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "{\"conditionalRule\":{\"entryentity\":[{\"id\":\"123456789\",\"logic\":\"||\",\"_inherit_\":true},{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"987654321\",\"paramnumber\":\"model.amount\",\"logic\":\"\",\"operation\":\">\",\"value\":\"333\"}],\"expression\":\"${  model.reason == \\\"ok\\\" || model.amount == 333 }\",\"type\":\"sequenceFlow\",\"_inherit_\":true}}";
        JsonNode patchNode = BpmnDiffUtil.getBpmnPatch((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patchNode.toString()));
        src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{}}";
        source = BpmnDiffUtil.getNode((String)src);
        JsonNode ret = BpmnDiffUtil.applyPatch((JsonNode)source, (String)diff);
        this.checkConditionalRule(ret, "\"${model.amount>333}\"");
        BpmnDiffUnittest.assertTrue((boolean)"sequenceFlow".equals(ret.get("conditionalRule").get("type").textValue()));
        src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\"}";
        source = BpmnDiffUtil.getNode((String)src);
        ret = BpmnDiffUtil.applyPatch((JsonNode)source, (String)diff);
        BpmnDiffUnittest.assertNull((Object)ret.get("conditionalRule"));
    }

    @Test
    public void testDiffConditionalRule() {
        String src = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${model.reason==\\\"jhhh\\\"&&model.ispresent==0}\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461487382118544384\",\"paramnumber\":\"model.reason\",\"logic\":\"&&\",\"operation\":\"==\",\"value\":\"jhhh\"},{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461488358988724224\",\"paramnumber\":\"model.ispresent\",\"logic\":\"\",\"operation\":\"==\",\"value\":\"0\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"description\":{\"zh_TW\":\"\",\"zh_CN\":\"\"},\"validtime\":null,\"type\":\"sequenceFlow\"},\"defaultflow\":false,\"name\":\"hhhh\"}";
        String tgt = "{\"itemId\":\"wzk_test_submit_0929_SequenceFlow4\",\"number\":\"SequenceFlow4\",\"conditionalRule\":{\"elementid\":\"wzk_test_submit_0929_SequenceFlow4\",\"expression\":\"${model.reason==\\\"jhhh\\\"&&model.ispresent==0}\",\"entryentity\":[{\"valuetype\":\"commVal\",\"leftbracket\":\"\",\"rightbracket\":\"\",\"id\":\"461487382118544384\",\"paramnumber\":\"model.reason\",\"logic\":\"\",\"operation\":\"==\",\"value\":\"jhhh\"}],\"showtext\":{\"zh_TW\":\"hhhh\",\"zh_CN\":\"hhhh\"},\"property\":\"conditionalRule\",\"description\":{\"zh_TW\":\"\",\"zh_CN\":\"\"},\"validtime\":null,\"type\":\"sequenceFlow\"},\"defaultflow\":false,\"name\":\"hhhh\"}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "{\"conditionalRule\":{\"entryentity\":[{\"id\":\"461488358988724224\",\"_action_\":\"remove\"},{\"id\":\"461487382118544384\",\"logic\":\"\",\"_inherit_\":true}],\"type\":\"sequenceFlow\",\"_inherit_\":true}}";
        JsonNode patchNode = BpmnDiffUtil.getBpmnPatch((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patchNode.toString()));
        String ret = "\"${model.reason==\\\"jhhh\\\"}\"";
        BpmnDiffUnittest.assertFalse((boolean)ret.equals(target.get("conditionalRule").get("expression").toString().replaceAll("\\s*", "")));
        JsonNode sourceApply = BpmnDiffUtil.applyPatch((JsonNode)source, (String)diff);
        BpmnDiffUnittest.assertTrue((boolean)ret.equals(sourceApply.get("conditionalRule").get("expression").toString().replaceAll("\\s*", "")));
    }

    @Test
    public void testConditionalRuleThree() {
        String src = "{\"childShapes\":[{\"properties\":{\"itemId\":\"wzk_test_scheme_SequenceFlow6\",\"number\":\"SequenceFlow6\",\"defaultflow\":false,\"name\":\"testcond\",\"conditionalRule\":{\"description\":{\"zh_CN\":\" \",\"zh_TW\":\" \"},\"elementid\":\"wzk_test_scheme_SequenceFlow6\",\"entryentity\":[{\"id\":\"541172357130110976\",\"leftbracket\":\"\",\"logic\":\"\",\"operation\":\"==\",\"paramnumber\":\"model.billno\",\"rightbracket\":\"\",\"value\":\"xxx\",\"valuetype\":\"commVal\"}],\"expression\":\"${ model.billno == \\\"xxx\\\" }\",\"property\":\"conditionalRule\",\"showtext\":{\"zh_CN\":\"testcond\",\"zh_TW\":\"testcond\"},\"type\":\"sequenceFlow\"}},\"resourceId\":\"wzk_test_scheme_SequenceFlow6\"}]}";
        String tgt = "{\"childShapes\":[{\"properties\":{\"itemId\":\"wzk_test_scheme_SequenceFlow6\",\"number\":\"SequenceFlow6\",\"defaultflow\":false,\"name\":\"testcond\",\"conditionalRule\":{\"description\":{\"zh_CN\":\" \",\"zh_TW\":\" \"},\"elementid\":\"wzk_test_scheme_SequenceFlow6\",\"entryentity\":[{\"id\":\"541172357130110976\",\"leftbracket\":\"\",\"logic\":\"\",\"operation\":\"==\",\"paramnumber\":\"model.billno\",\"rightbracket\":\"\",\"value\":\"yyy\",\"valuetype\":\"commVal\"}],\"expression\":\"${ model.billno == \\\"yyy\\\" }\",\"property\":\"conditionalRule\",\"showtext\":{\"zh_CN\":\"testcond-child\",\"zh_TW\":\"testcond-child\"},\"type\":\"sequenceFlow\"}},\"resourceId\":\"wzk_test_scheme_SequenceFlow6\"}]}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.getNode((String)tgt);
        String diff = "{\"childShapes\":[{\"resourceId\":\"wzk_test_scheme_SequenceFlow6\",\"properties\":{\"conditionalRule\":{\"entryentity\":[{\"id\":\"541172357130110976\",\"value\":\"yyy\",\"_inherit_\":true}],\"expression\":\"${ model.billno == \\\"yyy\\\" }\",\"showtext\":{\"zh_CN\":\"testcond-child\",\"zh_TW\":\"testcond-child\"},\"type\":\"sequenceFlow\",\"_inherit_\":true}},\"_inherit_\":true}]}";
        JsonNode patchNode = BpmnDiffUtil.getBpmnPatch((JsonNode)source, (JsonNode)target);
        BpmnDiffUnittest.assertTrue((boolean)diff.equals(patchNode.toString()));
        src = "{\"childShapes\":[{\"properties\":{\"itemId\":\"wzk_test_scheme_SequenceFlow6\",\"number\":\"SequenceFlow6\",\"defaultflow\":false,\"name\":\"testcond\",\"conditionalRule\":null},\"resourceId\":\"wzk_test_scheme_SequenceFlow6\"}]}";
        source = BpmnDiffUtil.getNode((String)src);
        target = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)patchNode);
        ArrayNode shapes = (ArrayNode)target.get("childShapes");
        JsonNode conditionalRule = shapes.get(0).get("properties").get("conditionalRule");
        BpmnDiffUnittest.assertTrue((conditionalRule == null || conditionalRule.isNull() ? 1 : 0) != 0);
        src = "{\"childShapes\":[{\"properties\":{\"itemId\":\"wzk_test_scheme_SequenceFlow6\",\"number\":\"SequenceFlow6\",\"defaultflow\":false,\"name\":\"testcond\"},\"resourceId\":\"wzk_test_scheme_SequenceFlow6\"}]}";
        source = BpmnDiffUtil.getNode((String)src);
        target = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)patchNode);
        shapes = (ArrayNode)target.get("childShapes");
        conditionalRule = shapes.get(0).get("properties").get("conditionalRule");
        BpmnDiffUnittest.assertTrue((conditionalRule == null ? 1 : 0) != 0);
    }

    @Test
    public void testMergeRemoveAllArr() {
        String src = "{\"expireModel\":{\"expirebtn\":true,\"expireTime\":null,\"timeControls\":[{\"duration\":8,\"controltype\":\"beforeDuration\",\"timetype\":\"hour\",\"id\":\"470194276202979328\",\"operation\":\" \"},{\"duration\":0,\"controltype\":null,\"timetype\":\"hour\",\"id\":\"470194342481370112\",\"operation\":\" \"}]}}";
        String patch = "{\"expireModel\":{\"timeControls\":[{\"id\":\"470194276202979328\",\"_action_\":\"remove\"},{\"id\":\"470194342481370112\",\"_action_\":\"remove\"}]}}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.applyPatch((JsonNode)source, (String)patch);
        JsonNode timeControls = target.get("expireModel").get("timeControls");
        BpmnDiffUnittest.assertTrue((boolean)timeControls.isArray());
        BpmnDiffUnittest.assertTrue((((ArrayNode)timeControls).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMergerRemoved() {
        String src = "{\"properties\":{\"hideTaskInCenter\":false,\"allowTransfer\":false,\"outMsg\":[{\"messagetype\":\"notify\",\"notify\":true,\"sendevt\":\"end\",\"id\":\"474307253864779776\",\"notifytype\":\"yunzhijia\"}]}}";
        String patch = "{\"properties\":{\"outMsg\":[{\"id\":\"474307253864779776\",\"receiver\":[{\"id\":\"474307253730542592\",\"_action_\":\"remove\"},{\"selectedType\":\"person\",\"property\":\"outMsg.receiver\",\"openpagebyformid\":\"wf_part_person\",\"id\":\"474307645579218944\",\"type\":\"person\",\"value\":\"9478\"}],\"_inherit_\":true}]}}";
        JsonNode source = BpmnDiffUtil.getNode((String)src);
        JsonNode target = BpmnDiffUtil.applyPatch((JsonNode)source, (String)patch);
        JsonNode temp = null;
        temp = target.get("properties");
        BpmnDiffUnittest.assertNotNull((Object)temp);
        temp = temp.get("outMsg");
        BpmnDiffUnittest.assertNotNull((Object)temp);
        BpmnDiffUnittest.assertTrue((boolean)temp.isArray());
        ArrayNode arr = (ArrayNode)temp;
        BpmnDiffUnittest.assertTrue((arr.size() == 1 ? 1 : 0) != 0);
        temp = arr.get(0);
        temp = temp.get("receiver");
        BpmnDiffUnittest.assertNotNull((Object)temp);
        BpmnDiffUnittest.assertTrue((boolean)temp.isArray());
        arr = (ArrayNode)temp;
        BpmnDiffUnittest.assertTrue((arr.size() == 1 ? 1 : 0) != 0);
        JsonNode receiver = arr.get(0);
        BpmnDiffUnittest.assertNull((Object)receiver.get("_action_"));
    }

    @Test
    public void testElements() {
        ObjectNode obj = this.mapper.createObjectNode();
        obj.put("a", (JsonNode)this.mapper.createObjectNode());
        obj.put("b", 2);
        ObjectNode node = (ObjectNode)obj.get("a");
        node.put("a1", 4);
        JsonNode child = node.get("a1");
        BpmnDiffUnittest.assertTrue((boolean)obj.path("a/a1").isMissingNode());
        BpmnDiffUnittest.assertFalse((boolean)obj.path("a").isMissingNode());
        BpmnDiffUnittest.assertTrue((boolean)node.elements().hasNext());
        BpmnDiffUnittest.assertTrue((boolean)obj.elements().hasNext());
        BpmnDiffUnittest.assertFalse((boolean)child.elements().hasNext());
    }

    @Test
    public void testIteratorRemove() {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add("a");
        arr.add("b");
        arr.add("c");
        arr.add("d");
        arr.add("e");
        Iterator iterator = arr.iterator();
        String next = null;
        while (iterator.hasNext()) {
            next = (String)iterator.next();
            if (!next.equals("b") && !next.equals("c")) continue;
            iterator.remove();
        }
        BpmnDiffUnittest.assertSame((Object)3, (Object)arr.size());
    }

    @Test
    public void testFieldNames() {
        ArrayNode array = this.mapper.createArrayNode();
        ObjectNode obj = this.mapper.createObjectNode();
        obj.put("a", (JsonNode)this.mapper.createObjectNode());
        obj.put("b", 2);
        array.add((JsonNode)obj);
        Iterator iterator = array.fieldNames();
        BpmnDiffUnittest.assertFalse((boolean)iterator.hasNext());
        iterator = obj.fieldNames();
        BpmnDiffUnittest.assertTrue((boolean)iterator.hasNext());
        if (iterator.hasNext()) {
            BpmnDiffUnittest.assertSame((Object)"a", iterator.next());
        }
        if (iterator.hasNext()) {
            BpmnDiffUnittest.assertSame((Object)"b", iterator.next());
        }
    }

    @Test
    public void testSize() {
        String str = "[\"a\",{\"mykey\":\"myvalue\"}]";
        JsonNode node = BpmnDiffUtil.getNode((String)str);
        if (node.isArray()) {
            ArrayNode arr = (ArrayNode)node;
            int size = arr.size();
            BpmnDiffUnittest.assertEquals((long)size, (long)2L);
            JsonNode item = arr.get(0);
            BpmnDiffUnittest.assertFalse((boolean)item.isContainerNode());
            BpmnDiffUnittest.assertTrue((item.size() == 0 ? 1 : 0) != 0);
            item = arr.get(1);
            BpmnDiffUnittest.assertTrue((boolean)item.isContainerNode());
            BpmnDiffUnittest.assertTrue((item.size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRegex() {
        String path = "[_receiver,notify,notifyType_:6554156113569038-1189411160]";
        BpmnDiffUnittest.assertTrue((boolean)path.matches("\\[([\\w,]+):(.+?)\\]"));
    }

    @Test
    public void testGetNode() {
        JsonNode node = BpmnDiffUtil.getNode((String)"\"true\"");
        BpmnDiffUnittest.assertTrue((boolean)node.isTextual());
        node = BpmnDiffUtil.getNode((String)"true");
        BpmnDiffUnittest.assertTrue((boolean)node.isBoolean());
    }

    @Test
    public void testRemoveAllArray() {
        int[] indexes;
        String str = "[\"a\", \"b\", \"c\"]";
        JsonNode node = BpmnDiffUtil.getNode((String)str);
        BpmnDiffUnittest.assertTrue((boolean)node.isArray());
        ArrayNode arr = (ArrayNode)node;
        for (int index : indexes = new int[]{0, 1, 2}) {
            arr.remove(index);
        }
        BpmnDiffUnittest.assertFalse((arr.size() == 0 ? 1 : 0) != 0);
        for (int index : indexes = new int[]{2, 1, 0}) {
            arr.remove(index);
        }
        BpmnDiffUnittest.assertTrue((arr.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntComparator() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(5);
        list.add(3);
        list.add(4);
        list.add(1);
        list.add(2);
        Collections.sort(list, new IntegerValueComparator());
        BpmnDiffUnittest.assertTrue(((Integer)list.get(0) == 5 ? 1 : 0) != 0);
        BpmnDiffUnittest.assertTrue(((Integer)list.get(1) == 4 ? 1 : 0) != 0);
        BpmnDiffUnittest.assertTrue(((Integer)list.get(2) == 3 ? 1 : 0) != 0);
        BpmnDiffUnittest.assertTrue(((Integer)list.get(3) == 2 ? 1 : 0) != 0);
        BpmnDiffUnittest.assertTrue(((Integer)list.get(4) == 1 ? 1 : 0) != 0);
    }
}

