/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.unittest.scheme;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import junit.framework.Assert;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import org.junit.Test;

public class ListDiffUnittest
extends Assert {
    private Log logger = LogFactory.getLog(ListDiffUnittest.class);
    protected ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testListBaseModified() {
        JsonNode target;
        String src = "{\"items\":[\"A\",\"C\",\"F\",\"B\",\"D\"]}";
        String tgt = "{\"items\":[\"D\",\"B\",\"E\",\"A\",\"C\"]}";
        JsonNode source = this.getNode(src);
        JsonPatch patch = BpmnDiffUtil.diffJson((JsonNode)source, (JsonNode)(target = this.getNode(tgt)));
        ListDiffUnittest.assertTrue((patch != null ? 1 : 0) != 0);
        String diff = "[{\"op\": \"replace\", \"path\": \"/items/[_hashcode_:70]\", \"oldValue\": \"F\", \"value\": null}, {\"op\": \"add\", \"path\": \"/items/[_hashcode_:69]\", \"value\": \"E\"}]";
        ListDiffUnittest.assertTrue((boolean)diff.equals(patch.toString()));
        String patchStr = "{\"items\":[{\"_hashcode_\":\"70\",\"_action_\":\"remove\"},{\"_value_\":\"E\"}]}";
        JsonNode bpmnPatch = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
        ListDiffUnittest.assertTrue((boolean)patchStr.equals(bpmnPatch.toString()));
        JsonNode patchdSource = BpmnDiffUtil.applyPatch((JsonNode)source, (JsonNode)bpmnPatch);
        JsonPatch result = BpmnDiffUtil.diffJson((JsonNode)target, (JsonNode)patchdSource);
        ListDiffUnittest.assertSame((Object)"[]", (Object)result.toString());
    }

    @Test
    public void testSize() {
        String str = "[\"a\",{\"mykey\":\"myvalue\"}]";
        JsonNode node = this.getNode(str);
        if (node.isArray()) {
            ArrayNode arr = (ArrayNode)node;
            int size = arr.size();
            ListDiffUnittest.assertEquals((int)size, (int)2);
            JsonNode item = arr.get(0);
            ListDiffUnittest.assertFalse((boolean)item.isContainerNode());
            ListDiffUnittest.assertTrue((item.size() == 0 ? 1 : 0) != 0);
            item = arr.get(1);
            ListDiffUnittest.assertTrue((boolean)item.isContainerNode());
            ListDiffUnittest.assertTrue((item.size() > 0 ? 1 : 0) != 0);
        }
    }

    protected JsonNode getNode(String content) {
        JsonNode node = null;
        try {
            node = this.mapper.readTree(content);
        }
        catch (Exception e) {
            this.logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            ListDiffUnittest.fail((String)e.getMessage());
        }
        return node;
    }
}

