/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.unittest.util;

import com.alibaba.fastjson.JSONArray;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.HandleResult;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingDecisionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.testcase.model.TestcaseRunningResults;

public class TestingPlanUtil {
    public static final String FCASEID = "FCASEID";
    public static final String COUNT = "COUNT";
    public static final String QUERYSQL = "SELECT FCASEID, COUNT(FID) COUNT FROM T_WF_TESTINGPLAN WHERE FSTATE = &#x27;%s&#x27; GROUP BY FCASEID;";

    public static void runTestingPlan(Long testingPlanId, boolean republish) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        service.getRepositoryService().runTestingPlan(testingPlanId, republish);
    }

    public static void openTestingPlanList(IFormView view, Long caseId, String sourcePage) {
        ArrayList<Long> caseIds = new ArrayList<Long>();
        caseIds.add(caseId);
        TestingPlanUtil.openTestingPlanList(view, caseIds, sourcePage);
    }

    public static void openTestingPlanList(IFormView view, List<Long> caseIds, String sourcePage) {
        IFormView settingsFormView = DesignerModelUtil.getTabControlView((IFormView)view);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_testingplan");
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qFilter = new QFilter("caseid", "in", caseIds);
        listFilterParameter.setFilter(qFilter);
        parameter.setListFilterParameter(listFilterParameter);
        if (settingsFormView != null) {
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setCustomParam("isOpenNewTab", (Object)true);
            parameter.setCustomParam("sp", (Object)sourcePage);
            parameter.setMultiSelect(true);
            settingsFormView.showForm((FormShowParameter)parameter);
            view.sendFormAction(settingsFormView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            view.showForm((FormShowParameter)parameter);
        }
    }

    public static void openCaseReport(IFormView view, Long caseId) {
        IFormView parentView = DesignerModelUtil.getTabControlView((IFormView)view);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("caseId", (Object)caseId);
        parameter.setFormId("wf_casereport");
        if (parentView != null) {
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setStatus(OperationStatus.EDIT);
            parentView.showForm(parameter);
            view.sendFormAction(parentView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            view.showForm(parameter);
        }
    }

    public static HandleResult runTestingCase(List<Long> caseIds, boolean republish) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return service.getRepositoryService().runTestingCase(caseIds, republish);
    }

    public static List<TestcaseRunningResults> getCaseRunningResults() {
        Object row;
        TestcaseRunningResults result;
        Iterator iter3;
        Iterator iter2;
        String sql = "SELECT FCASEID, COUNT(FID) COUNT, MIN(FSTARTTIME) STARTTIME, MAX(FENDTIME) ENDTIME FROM T_WF_TESTINGPLAN GROUP BY FCASEID;";
        LinkedHashMap<Long, TestcaseRunningResults> map = new LinkedHashMap<Long, TestcaseRunningResults>();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.testcase.queryTestingPlanCount", (DBRoute)DBRoute.workflow, (String)sql, null);){
            iter2 = ds.iterator();
            TestcaseRunningResults result2 = null;
            while (iter2.hasNext()) {
                Row row2 = (Row)iter2.next();
                result2 = new TestcaseRunningResults();
                result2.setCaseId(row2.getLong(FCASEID));
                result2.setCount(row2.getInteger(COUNT));
                result2.setStartTime(row2.getTimestamp("STARTTIME"));
                result2.setEndTime(row2.getTimestamp("ENDTIME"));
                result2.setDuration(result2.getStartTime(), result2.getEndTime());
                map.put(result2.getCaseId(), result2);
            }
        }
        ArrayList<TestcaseRunningResults> results = new ArrayList<TestcaseRunningResults>(map.size());
        if (map.isEmpty()) {
            return results;
        }
        sql = String.format("SELECT FCASEID, COUNT(FID) COUNT FROM T_WF_TESTINGPLAN WHERE FSTATE = '%s' GROUP BY FCASEID;", "successed");
        DataSet ds = DB.queryDataSet((String)"wf.engine.testcase.querySucceedPlanCount", (DBRoute)DBRoute.workflow, (String)sql, null);
        iter2 = null;
        try {
            iter3 = ds.iterator();
            result = null;
            while (iter3.hasNext()) {
                row = (Row)iter3.next();
                result = (TestcaseRunningResults)map.get(row.getLong(FCASEID));
                result.setSuccessed(row.getInteger(COUNT));
            }
        }
        catch (Throwable iter3) {
            iter2 = iter3;
            throw iter3;
        }
        finally {
            if (ds != null) {
                if (iter2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter3) {
                        ((Throwable)((Object)iter2)).addSuppressed(iter3);
                    }
                } else {
                    ds.close();
                }
            }
        }
        sql = String.format("SELECT FCASEID, COUNT(FID) COUNT FROM T_WF_TESTINGPLAN WHERE FSTATE = '%s' GROUP BY FCASEID;", "failed");
        ds = DB.queryDataSet((String)"wf.engine.testcase.queryFailedPlanCount", (DBRoute)DBRoute.workflow, (String)sql, null);
        iter2 = null;
        try {
            iter3 = ds.iterator();
            result = null;
            while (iter3.hasNext()) {
                row = (Row)iter3.next();
                result = (TestcaseRunningResults)map.get(row.getLong(FCASEID));
                result.setFailed(row.getInteger(COUNT));
            }
        }
        catch (Throwable iter4) {
            iter2 = iter4;
            throw iter4;
        }
        finally {
            if (ds != null) {
                if (iter2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter4) {
                        ((Throwable)((Object)iter2)).addSuppressed(iter4);
                    }
                } else {
                    ds.close();
                }
            }
        }
        sql = String.format("SELECT FCASEID, COUNT(FID) COUNT FROM T_WF_TESTINGPLAN WHERE FSTATE = '%s' GROUP BY FCASEID;", "running");
        ds = DB.queryDataSet((String)"wf.engine.testcase.queryRunningPlanCount", (DBRoute)DBRoute.workflow, (String)sql, null);
        iter2 = null;
        try {
            iter3 = ds.iterator();
            result = null;
            while (iter3.hasNext()) {
                row = (Row)iter3.next();
                result = (TestcaseRunningResults)map.get(row.getLong(FCASEID));
                result.setRunning(row.getInteger(COUNT));
            }
        }
        catch (Throwable iter5) {
            iter2 = iter5;
            throw iter5;
        }
        finally {
            if (ds != null) {
                if (iter2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter5) {
                        ((Throwable)((Object)iter2)).addSuppressed(iter5);
                    }
                } else {
                    ds.close();
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : map.keySet()) {
            sb.append(id).append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        String lang = RequestContext.get().getLang().toString();
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_cases", (String)"C", (String)"CL", (String)"FNAME", (String)"NAME", (String)"name");
        sql = String.format("SELECT C.FID ID, C.FNUMBER NUMBER, " + nameSQL + " FROM T_WF_CASES C LEFT JOIN T_WF_CASES_L CL ON C.FID = CL.FID AND CL.FLOCALEID = '%s' WHERE C.FID IN (%s);", lang, sb.toString());
        DataSet ds2 = DB.queryDataSet((String)"wf.engine.testcase.queryTestingCaseInfo", (DBRoute)DBRoute.workflow, (String)sql, null);
        row = null;
        try {
            Iterator iter6 = ds2.iterator();
            TestcaseRunningResults result3 = null;
            while (iter6.hasNext()) {
                Row row3 = (Row)iter6.next();
                result3 = (TestcaseRunningResults)map.get(row3.getLong("ID"));
                result3.setCaseNumber(row3.getString("NUMBER"));
                result3.setCaseName(row3.getString("NAME"));
                if (result3.getRunning() == 0 && result3.getFailed() == 0 && result3.getSuccessed() == 0) {
                    result3.setResult("notrunning");
                } else {
                    result3.setResult(result3.getRunning() > 0 ? "running" : (result3.getFailed() > 0 ? "failed" : "successed"));
                }
                result3.setRate(TestingPlanUtil.getSuccessRate(result3.getCount(), result3.getSuccessed()));
            }
        }
        catch (Throwable iter6) {
            row = iter6;
            throw iter6;
        }
        finally {
            if (ds2 != null) {
                if (row != null) {
                    try {
                        ds2.close();
                    }
                    catch (Throwable iter6) {
                        ((Throwable)row).addSuppressed(iter6);
                    }
                } else {
                    ds2.close();
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            TestcaseRunningResults testcaseRunningResults = (TestcaseRunningResults)entry.getValue();
            results.add(testcaseRunningResults);
        }
        return results;
    }

    public static String getSuccessRate(int total, int successed) {
        return String.format("%s%%", new DecimalFormat("#.##").format((double)successed * 100.0 / (double)total));
    }

    public static String getDuration(Long startTime, Long endTime) {
        return String.format("%s s", (endTime - startTime) / 1000L);
    }

    public static List<Map<String, String>> getDynResourceByBill(String entityNumber) {
        ArrayList<Map<String, String>> retMap = new ArrayList<Map<String, String>>();
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_expressionext", (String)"a", (String)"b", (String)"fname", (String)"name", (String)"name");
        String sql = "SELECT a.FID, a.FNUMBER, " + nameSQL + " from t_wf_dynconfscheme a";
        return retMap;
    }

    public static Map<String, String> getApproverInfo(Long schemeId) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        HashMap<String, String> ret = new HashMap<String, String>();
        BpmnModel bpmnModel = service.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        List elements = bpmnModel.getMainProcess().getFlowElementList();
        for (FlowElement element : elements) {
            List participant;
            UserTask userTask;
            ParticipatantModel participantModel;
            if (element instanceof SequenceFlow || !"UserTask".equals(element.getType()) && !"AuditTask".equals(element.getType()) && !"YunzhijiaTask".equals(element.getType()) || null == (participantModel = (userTask = (UserTask)element).getParticipant()) || null == (participant = participantModel.getParticipant()) || participant.isEmpty()) continue;
            for (ParticipantModelEntityImpl participantModelEntityImpl : participant) {
                String personsStr;
                String[] persons;
                if (null == participantModelEntityImpl) continue;
                DynamicObject dynamicObject = participantModelEntityImpl.getDynamicObject();
                String type = participantModelEntityImpl.getType();
                if ("person".equals(type) && null != (persons = (personsStr = dynamicObject.getString("value")).split(",")) && persons.length > 0) {
                    for (String assigneeId : persons) {
                        ret.put(String.format("%s_%s", element.getId(), assigneeId), ResManager.loadKDString((String)"\u4eba\u5458\uff1a", (String)"TestingPlanUtil_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
                    }
                }
                if ("role".equals(type)) {
                    String roleId = dynamicObject.getString("roleId");
                    RoleEntity dynObject = (RoleEntity)service.getRepositoryService().findEntityById(Long.valueOf(Long.parseLong(roleId)), "wf_role");
                    if (null == dynObject) continue;
                    String roleNumber = dynObject.getNumber();
                    String roleName = dynObject.getName();
                    Map roleObject = (Map)dynObject.getPersistentState();
                    if (null == roleObject) continue;
                    List userList = (List)roleObject.get("roleentry");
                    if (null != userList && !userList.isEmpty()) {
                        for (Map userObject : userList) {
                            DynamicObject user = (DynamicObject)userObject.get("user");
                            if (null == user) continue;
                            Long userId = (Long)user.get("id");
                            ret.put(String.format("%s_%s", element.getId(), String.valueOf(userId)), ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a", (String)"TestingPlanUtil_2", (String)"bos-wf-unittest", (Object[])new Object[0]) + roleName + "(" + roleNumber + ")");
                        }
                    }
                }
                if (!"relation".equals(type)) continue;
                String value = dynamicObject.getString("value");
                ret.put(element.getId(), ResManager.loadKDString((String)"\u5173\u7cfb\uff1a", (String)"TestingPlanUtil_3", (String)"bos-wf-unittest", (Object[])new Object[0]) + value);
            }
        }
        return ret;
    }

    public static String getFirstUserOptNumber(Long schemeId) {
        List endEventList;
        EndEvent endEvent;
        String optNumber = "";
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = service.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        List allNodes = bpmnModel.getPreviousNodes((endEvent = (EndEvent)(endEventList = bpmnModel.getMainProcess().findFlowElementsOfType(EndEvent.class)).get(0)).getId());
        if (null != allNodes && !allNodes.isEmpty()) {
            for (FlowElement element : allNodes) {
                if (null == element || !"UserTask".equals(element.getType()) || null == element.getDecisionOptions() || element.getDecisionOptions().isEmpty()) continue;
                DecisionOption dOption = (DecisionOption)element.getDecisionOptions().get(0);
                optNumber = dOption.getNumber();
                break;
            }
        }
        return optNumber;
    }

    public static String getCycleDecisionByTaskId(Long taskId, Long planId) {
        String ret = "";
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoricActivityInstanceEntity historicActivityInstance = configuration.getHistoryService().getHistoricActivityByTaskId(taskId);
        if (null != historicActivityInstance) {
            String cycle = historicActivityInstance.getCycle();
            int cyclenum = TestingPlanUtil.getCycleCount("_", cycle);
            QFilter[] qFilter = new QFilter[]{new QFilter("planid", "=", (Object)planId), new QFilter("nodeid", "=", (Object)historicActivityInstance.getActivityId())};
            List decisionList = configuration.getRepositoryService().findEntitiesByFilters("wf_testingdecision", qFilter);
            if (null != decisionList && !decisionList.isEmpty()) {
                TestingDecisionEntity decisionItem = (TestingDecisionEntity)decisionList.get(0);
                String decisions = decisionItem.getDecisions();
                List cycleDecisions = (List)JSONArray.parse((String)decisions);
                for (Map m : cycleDecisions) {
                    if (!String.valueOf(cyclenum).equals(m.get("cyclenum"))) continue;
                    ret = (String)m.get("decisionnum");
                }
            }
        }
        return ret;
    }

    public static int getCycleCount(String target, String str) {
        int count = 1;
        int index = 0;
        while ((index = str.indexOf(target)) != -1) {
            str = str.substring(index + target.length());
            ++count;
        }
        return count;
    }
}

