/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import junit.framework.Assert;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculator;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.variable.VariableTypes;

public abstract class AbstractWorkflowValidator
extends Assert {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
    protected RepositoryService repositoryService = this.configuration.getRepositoryService();
    protected RuntimeService runtimeService = this.configuration.getRuntimeService();
    protected HistoryService historyService = this.configuration.getHistoryService();
    protected TaskService taskService = this.configuration.getTaskService();
    protected BillSubjectCalculator subjectCalculator = this.configuration.getBillSubjectCalculator();
    protected ParticipantCalculator participantCalculator = this.configuration.getParticipantCalculator();
    protected ExpressionManager expressionManager = this.configuration.getExpressionManager();
    protected TaskHelper taskHelper = this.configuration.getTaskHelper();
    protected MacroParser lastAssigneeParser = this.configuration.getMacroParser("lastAssignee");
    protected VariableTypes variableTypes = this.configuration.getVariableTypes();
    protected CommandExecutor commandExecutor = this.configuration.getCommandExecutor();

    protected void validateEquals(Object expected, Object actual) {
        if (expected instanceof String || expected instanceof ILocaleString || actual instanceof String || actual instanceof ILocaleString) {
            this.validateStringEquals(expected, actual);
        } else if (expected instanceof Long || actual instanceof Long) {
            this.validateLongEquals(expected, actual);
        } else {
            AbstractWorkflowValidator.assertEquals((Object)expected, (Object)actual);
        }
    }

    private void validateStringEquals(Object expected, Object actual) {
        String expStr = this.getStringValue(expected);
        String actStr = this.getStringValue(actual);
        AbstractWorkflowValidator.assertEquals((String)expStr, (String)actStr);
    }

    private void validateLongEquals(Object expected, Object actual) {
        if (expected == null) {
            AbstractWorkflowValidator.assertTrue((boolean)WfUtils.isEmpty((Long)((Long)actual)));
        } else if (actual == null) {
            AbstractWorkflowValidator.assertTrue((boolean)WfUtils.isEmpty((Long)((Long)expected)));
        } else {
            AbstractWorkflowValidator.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected boolean isMultiInstanceActivity(FlowElement element) {
        return "YunzhijiaTask".equals(element.getType());
    }

    private String getStringValue(Object object) {
        String val;
        String objStr = "";
        if (null == object) {
            return objStr;
        }
        if (object instanceof ILocaleString && (val = ((ILocaleString)object).getLocaleValue()) != null) {
            objStr = val;
        }
        if (object instanceof String) {
            objStr = String.valueOf(object);
        }
        return objStr;
    }
}

