/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoAudit;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.validator.AutoAuditNodeValidator;
import kd.bos.workflow.validator.SkipNodeValidator;
import kd.bos.workflow.validator.UserTaskValidator;

public class AuditTaskValidator
extends UserTaskValidator {
    @Override
    protected void validate(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem) {
        BpmnModel bpmnModel;
        AuditTask auditTask;
        ExecutionEntity execution = this.getClonedExecution(activityInstance);
        if (this.isSkippedTask(execution, (UserTask)(auditTask = (AuditTask)(bpmnModel = this.repositoryService.getBpmnModel(activityInstance.getProcessDefinitionId(), activityInstance.getProcessInstanceId())).getFlowElement(activityInstance.getActivityId())))) {
            new SkipNodeValidator().validateDatas(activityInstance, pathItem);
        } else if (this.isAutoAuditTask(execution, auditTask)) {
            new AutoAuditNodeValidator().validateDatas(activityInstance, pathItem);
        } else {
            this.validateDatas(activityInstance, pathItem);
        }
    }

    @Override
    protected void validateTaskHandleState(ExecutionEntity execution, TaskEntity taskEntity, UserTask userTask) {
        boolean isRejectTask = this.taskHelper.isRejectTask(execution.getProcessInstanceId(), execution.getCurrentActInstId(), userTask.getId());
        String handleState = isRejectTask ? "dismissed" : "willApproval";
        this.validateEquals(handleState, taskEntity.getHandleState());
    }

    @Override
    protected void validateHistoricTaskHandleState(HistoricTaskInstanceEntity hisTask, TestingPathEntity pathItem) {
        Map pathVariables = (Map)JSON.parse((String)pathItem.getVariables());
        Object state = pathVariables.get("auditType");
        this.validateEquals(state, hisTask.getHandleState());
    }

    @Override
    protected void validateCommentSpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricTaskInstanceEntity hisTask, CommentEntity comment) {
        List variables = this.historyService.getHistoricVariableInstanceEntityByTaskId(hisTask.getId());
        AuditTaskValidator.assertTrue((variables != null && !variables.isEmpty() ? 1 : 0) != 0);
        int i = 0;
        for (HistoricVariableInstanceEntity variable : variables) {
            switch (variable.getName()) {
                case "auditNumber": {
                    this.validateEquals(variable.getTextValue(), comment.getResultNumber());
                    ++i;
                    break;
                }
                case "auditName": {
                    this.validateEquals(variable.getTextValue(), comment.getResultName());
                    ++i;
                    break;
                }
                case "auditMessage": {
                    this.validateEquals(variable.getTextValue(), comment.getMessage());
                    ++i;
                    break;
                }
                case "assignee": {
                    this.validateEquals(variable.getTextValue(), comment.getAssignee());
                    ++i;
                    break;
                }
                case "auditType": {
                    this.validateEquals(variable.getTextValue(), comment.getDecisionType());
                    ++i;
                    break;
                }
            }
            if (i != 5) continue;
            break;
        }
        this.validateEquals(hisTask.getBusinessKey(), comment.getBusinessKey());
        this.validateEquals(hisTask.getEntityNumber(), comment.getEntityNumber());
        String name = bpmnModel.getFlowElement(hisTask.getTaskDefinitionKey()).getName();
        String multiKey = BpmnModelUtil.getActivityNameMultiKey((String)comment.getActivityId());
        ILocaleString activityName = BpmnModelUtil.getMultiLangFieldValue((Long)comment.getProcessInstanceId(), (String)multiKey, (String)name);
        this.validateEquals(activityName, comment.getNodeName());
    }

    @Override
    protected boolean isSkippedTask(ExecutionEntity execution, UserTask userTask) {
        boolean isSkipped = super.isSkippedTask(execution, userTask);
        if (isSkipped) {
            return true;
        }
        AuditTask auditTask = (AuditTask)userTask;
        return this.isSkippedByRepeaterApprove(execution, auditTask);
    }

    protected boolean isAutoAuditTask(ExecutionEntity execution, AuditTask auditTask) {
        AutoAudit autoAudit = auditTask.getAutoAudit();
        TaskEntity task = this.getTaskEntityFromHistoricTask((HistoricTaskInstanceEntity)this.repositoryService.findEntityById(execution.getCurrentTaskId(), "wf_hitaskinst"));
        if (autoAudit != null && autoAudit.isAutoAuditWhenMatch()) {
            return ConditionUtil.hasTrueCondition((ConditionalRuleEntity)autoAudit.getAutoAuditCondition(), (VariableScope)task, null);
        }
        if (this.taskHelper.isStarterSameAsAuditor(task)) {
            return true;
        }
        return this.isAutoAuditByRepeaterApprove(execution, auditTask);
    }
}

