/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoAudit;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.validator.AuditTaskValidator;

public class AutoAuditNodeValidator
extends AuditTaskValidator {
    @Override
    protected void validateHistoricActivitySpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricActivityInstanceEntity hisActInst, TestingPathEntity pathItem) {
        super.validateHistoricActivitySpecProps(bpmnModel, execution, hisActInst, pathItem);
        this.validateEquals("byAuto", hisActInst.getExecutionType());
        this.validateEquals(null, hisActInst.getSkipReason());
    }

    @Override
    protected void validateHistoricTaskSpecProps(BpmnModel bpmnModel, HistoricTaskInstanceEntity hisTask, ExecutionEntity execution, TestingPathEntity pathItem) {
        this.validateEquals("byAuto", hisTask.getExecutionType());
        AutoAuditor auditor = this.getAutoAuditor(bpmnModel, execution);
        this.validateEquals(auditor.getAssigneeId(), hisTask.getAssigneeId());
        this.validateEquals(auditor.getAssignee(), hisTask.getAssignee());
    }

    @Override
    protected void validateCommentSpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricTaskInstanceEntity hisTask, CommentEntity comment) {
        AutoAuditor auditor = this.getAutoAuditor(bpmnModel, execution);
        this.validateEquals(auditor.getAssigneeId(), comment.getUserId());
    }

    protected AutoAuditor getAutoAuditor(BpmnModel bpmnModel, ExecutionEntity execution) {
        AutoAuditor auditor = null;
        AuditTask auditTask = (AuditTask)bpmnModel.getFlowElement(execution.getActivityId());
        AutoAudit autoAudit = auditTask.getAutoAudit();
        List<Long> participants = null;
        TaskEntity task = null;
        if (Boolean.TRUE.equals(autoAudit.getParticipantAsAutoAuditor()) && (participants = this.calcParticipants(execution)).size() == 1) {
            Long assigneeId = participants.get(0);
            ILocaleString userName = WfUtils.findUserName((Long)assigneeId);
            auditor = new AutoAuditor(assigneeId, userName);
        } else {
            task = this.getTaskEntityFromHistoricTask((HistoricTaskInstanceEntity)this.repositoryService.findEntityById(execution.getCurrentTaskId(), "wf_hitaskinst"));
            if (this.taskHelper.isStarterSameAsAuditor(task)) {
                auditor = new AutoAuditor(task.getStarterId(), task.getStartName());
            } else if (this.isAutoAuditByRepeaterApprove(execution, auditTask)) {
                participants = this.calcParticipants(execution);
                Long assigneeId = participants.get(0);
                auditor = new AutoAuditor(assigneeId, WfUtils.findUserById((long)assigneeId).getName());
            } else {
                ILocaleString processHandler = BpmnModelUtil.getMultiLangFieldValue((Long)execution.getProcessInstanceId(), (String)String.format("%s.autoAudit.processHandler", auditTask.getId()), null);
                auditor = new AutoAuditor(-1L, processHandler);
            }
        }
        return auditor;
    }

    static class AutoAuditor {
        private Long assigneeId;
        private ILocaleString assignee;

        public AutoAuditor(Long assigneeId, ILocaleString assignee) {
            this.assigneeId = assigneeId;
            this.assignee = assignee;
        }

        public Long getAssigneeId() {
            return this.assigneeId;
        }

        public void setAssigneeId(Long assigneeId) {
            this.assigneeId = assigneeId;
        }

        public ILocaleString getAssignee() {
            return this.assignee;
        }

        public void setAssignee(ILocaleString assignee) {
            this.assignee = assignee;
        }
    }
}

