/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;
import kd.bos.workflow.validator.AbstractWorkflowValidator;
import kd.bos.workflow.validator.entity.CommentEntityValidator;
import kd.bos.workflow.validator.entity.DynamicResourceEntityValidator;
import kd.bos.workflow.validator.entity.ExecutionEntityValidator;
import kd.bos.workflow.validator.entity.HistoricActivityEntityValidator;
import kd.bos.workflow.validator.entity.HistoricProcessInstanceEntityValidator;
import kd.bos.workflow.validator.entity.HistoricUserActInstEntityValidator;
import kd.bos.workflow.validator.entity.IdentityLinkEntityValidator;
import kd.bos.workflow.validator.entity.TaskEntityValidator;
import kd.bos.workflow.validator.entity.VariableEntityValidator;

public abstract class BaseBpmnNodeValidator
extends AbstractWorkflowValidator {
    private Boolean terminal;
    private Long testingPlanId;
    protected ExecutionEntityValidator executionEntityValidator = new ExecutionEntityValidator();
    protected TaskEntityValidator taskEntityValidator = new TaskEntityValidator();
    protected IdentityLinkEntityValidator participantValidator = new IdentityLinkEntityValidator();
    protected CommentEntityValidator commentEntityValidator = new CommentEntityValidator();
    protected VariableEntityValidator variableEntityValidator = new VariableEntityValidator();
    protected HistoricActivityEntityValidator historicActivityValidator = new HistoricActivityEntityValidator();
    protected HistoricUserActInstEntityValidator historicUserActInstValidator = new HistoricUserActInstEntityValidator();
    protected HistoricProcessInstanceEntityValidator historicProcInstValidator = new HistoricProcessInstanceEntityValidator();
    protected DynamicResourceEntityValidator dynamicResourceValidator = new DynamicResourceEntityValidator();

    protected ExecutionEntity getClonedExecution(HistoricActivityInstanceEntity activityInstance) {
        ExecutionEntityImpl execution = (ExecutionEntityImpl)this.repositoryService.findEntityById(activityInstance.getExecutionId(), "wf_execution");
        return this.getClonedExecution((ExecutionEntity)execution, activityInstance);
    }

    protected ExecutionEntity getClonedExecution(ExecutionEntity execution, HistoricActivityInstanceEntity activityInstance) {
        ExecutionEntityImpl clonedExecution = null;
        if (execution == null) {
            HistoricProcessInstanceEntity hisProcessInstance = (HistoricProcessInstanceEntity)this.repositoryService.findEntityById(activityInstance.getProcessInstanceId(), "wf_hiprocinst");
            clonedExecution = this.getExecutionFromHistoricProcess(hisProcessInstance);
        } else {
            clonedExecution = ((ExecutionEntityImpl)execution).clone();
        }
        String activityId = activityInstance.getActivityId();
        clonedExecution.setActivityId(activityId);
        clonedExecution.setCurrentActInstId(activityInstance.getId());
        clonedExecution.setCurrentTaskId(activityInstance.getTaskId());
        clonedExecution.setId(activityInstance.getExecutionId());
        return clonedExecution;
    }

    protected TaskEntity getTaskEntityFromHistoricTask(HistoricTaskInstanceEntity hisTask) {
        TaskEntityImpl task = new TaskEntityImpl(hisTask);
        return task;
    }

    protected ExecutionEntityImpl getExecutionFromHistoricProcess(HistoricProcessInstanceEntity hisProcess) {
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        ExecutionEntityImpl processExecution = this.getProcessExecutionFromHistoricProcess(hisProcess);
        execution.setActive(true);
        execution.setScope(false);
        execution.setParent((ExecutionEntity)processExecution);
        execution.setProcessInstance((ExecutionEntity)processExecution);
        this.setExecutionProperties((ExecutionEntity)execution, hisProcess);
        return execution;
    }

    protected ExecutionEntityImpl getProcessExecutionFromHistoricProcess(HistoricProcessInstanceEntity hisProcess) {
        ExecutionEntityImpl processExecution = new ExecutionEntityImpl();
        processExecution.setScope(true);
        processExecution.setId(hisProcess.getId());
        this.setExecutionProperties((ExecutionEntity)processExecution, hisProcess);
        return processExecution;
    }

    private void setExecutionProperties(ExecutionEntity execution, HistoricProcessInstanceEntity hisProcess) {
        execution.setBusinessKey(hisProcess.getBusinessKey());
        execution.setProcessDefinitionId(hisProcess.getProcessDefinitionId());
        execution.setProcessDefinitionKey(hisProcess.getProcessDefinitionKey());
        execution.setProcessDefinitionName(hisProcess.getProcessDefinitionName());
        execution.setProcessDefinitionVersion(hisProcess.getProcessDefinitionVersion());
        execution.setDeploymentId(hisProcess.getDeploymentId());
        execution.setProcessInstanceId(hisProcess.getProcessInstanceId());
        execution.setDeleteReason(hisProcess.getDeleteReason());
        if (hisProcess.getName() != null) {
            execution.setName(hisProcess.getName());
        }
        if (hisProcess.getDescription() != null) {
            execution.setDescription(hisProcess.getDescription());
        }
        execution.setStartUserId(hisProcess.getStartUserId());
        execution.setActivityId(hisProcess.getEndActivityId());
        if (hisProcess.getActivityName() != null) {
            execution.setActivityName(hisProcess.getActivityName());
        }
        if (hisProcess.getSubject() != null) {
            execution.setSubject(hisProcess.getSubject());
        }
        if (hisProcess.getEntraBillName() != null) {
            execution.setEntraBillName(hisProcess.getEntraBillName());
        }
        execution.setEntityNumber(hisProcess.getEntitynumber());
        execution.setBillNo(hisProcess.getBillNo());
        execution.setBusinessKey(hisProcess.getBusinessKey());
        execution.setSchemeId(hisProcess.getSchemeId());
        execution.setMainOrgId(hisProcess.getMainOrgId());
        execution.setTestingPlanId(hisProcess.getTestingPlanId());
    }

    public void validateNode(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem, Long testingPlanId) {
        this.setTestingPlanId(testingPlanId);
        this.beginValidate(activityInstance);
        this.validate(activityInstance, pathItem);
        this.afterValidate(activityInstance);
    }

    protected void beginValidate(HistoricActivityInstanceEntity activityInstance) {
        StringBuilder sb = new StringBuilder();
        if ("SequenceFlow".equals(activityInstance.getActivityType())) {
            sb.append("[");
            sb.append(DateUtils.getDateTime());
            sb.append("]");
            sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6821\u9a8c \u8fde\u7ebf ", (String)"BaseBpmnNodeValidator_6", (String)"bos-wf-unittest", (Object[])new Object[0]));
            sb.append(activityInstance.getActivityId());
        } else {
            sb.append("[");
            sb.append(DateUtils.getDateTime());
            sb.append("]");
            sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6821\u9a8c ", (String)"BaseBpmnNodeValidator_1", (String)"bos-wf-unittest", (Object[])new Object[0]));
            sb.append(activityInstance.getActivityName());
            sb.append(ResManager.loadKDString((String)" \u8282\u70b9", (String)"BaseBpmnNodeValidator_2", (String)"bos-wf-unittest", (Object[])new Object[0]));
        }
        BpmnNodeValidateUtil.recordValidateInfo((Long)this.getTestingPlanId(), (String)sb.toString());
    }

    protected abstract void validate(HistoricActivityInstanceEntity var1, TestingPathEntity var2);

    protected void afterValidate(HistoricActivityInstanceEntity activityInstance) {
        StringBuilder sb = new StringBuilder();
        if ("SequenceFlow".equals(activityInstance.getActivityType())) {
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u8fde\u7ebf %2$d \u6821\u9a8c\u6210\u529f\u3002%3$s", (String)"BaseBpmnNodeValidator_3", (String)"bos-wf-unittest", (Object[])new Object[0]), "<p style=\"color:green;\">", activityInstance.getActivityId(), "</p>"));
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"%1$s%2$s \u8282\u70b9\u6821\u9a8c\u6210\u529f\u3002%3$s", (String)"BaseBpmnNodeValidator_5", (String)"bos-wf-unittest", (Object[])new Object[0]), "<p style=\"color:green;\">", activityInstance.getActivityName(), "</p>"));
        }
        BpmnNodeValidateUtil.recordValidateInfo((Long)this.getTestingPlanId(), (String)sb.toString());
    }

    public boolean isProcessTerminal(Long procInstanceId) {
        if (this.terminal == null) {
            HistoricProcessInstanceEntity hisProcInst = (HistoricProcessInstanceEntity)this.repositoryService.findEntityById(procInstanceId, "wf_hiprocinst", "endTime");
            this.terminal = hisProcInst.getEndTime() != null;
        }
        return this.terminal;
    }

    public Long getTestingPlanId() {
        return this.testingPlanId;
    }

    public void setTestingPlanId(Long testingPlanId) {
        this.testingPlanId = testingPlanId;
    }
}

