/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.model.ValidateModel;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.unittest.util.TestingPlanUtil;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;
import kd.bos.workflow.validator.AuditTaskValidator;
import kd.bos.workflow.validator.BaseBpmnNodeValidator;
import kd.bos.workflow.validator.EndEventValidator;
import kd.bos.workflow.validator.SequenceFlowValidator;
import kd.bos.workflow.validator.UserTaskValidator;
import kd.bos.workflow.validator.YunzhijiaTaskValidator;

public class BpmnNodeValidator {
    public static final String AUDITNUMBER = "auditNumber";
    private Log log = LogFactory.getLog(this.getClass());
    private WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    private Map<String, BaseBpmnNodeValidator> validatorMap = new HashMap<String, BaseBpmnNodeValidator>();

    public BpmnNodeValidator() {
        this.validatorMap.put("UserTask", new UserTaskValidator());
        this.validatorMap.put("AuditTask", new AuditTaskValidator());
        this.validatorMap.put("YunzhijiaTask", new YunzhijiaTaskValidator());
        this.validatorMap.put("SequenceFlow", new SequenceFlowValidator());
        this.validatorMap.put("EndNoneEvent", new EndEventValidator());
        this.validatorMap.put("EndErrorEvent", new EndEventValidator());
        this.validatorMap.put("EndCancelEvent", new EndEventValidator());
        this.validatorMap.put("EndTerminateEvent", new EndEventValidator());
    }

    public void validate(Long procInstId, Long executionId, Long testingPlanId, Long taskId) {
        try {
            TestingPlanEntity testingPlan = (TestingPlanEntity)this.service.getRepositoryService().findEntityById(testingPlanId, "wf_testingplan");
            if (testingPlan.isAutoTest()) {
                HistoricProcessInstanceEntity hiProcInst;
                List retList;
                if (0L == executionId && 0L == taskId && null == testingPlan.getEndTime() && (null == (retList = this.service.getRuntimeService().getChildExecutionsByProcessInstanceId(procInstId)) || retList.isEmpty()) && null != (hiProcInst = (HistoricProcessInstanceEntity)this.service.getRepositoryService().findEntityById(procInstId, "wf_hiprocinst")) && null != hiProcInst.getEndType()) {
                    if ("40".equals(hiProcInst.getEndType())) {
                        BpmnNodeValidateUtil.markTestingPlanTerminated((Long)testingPlan.getId());
                    } else {
                        BpmnNodeValidateUtil.markTestingPlanSuccess((Long)testingPlan.getId());
                    }
                }
                if (0L != taskId) {
                    String cycle;
                    int cyclenum;
                    HistoricActivityInstanceEntity historicActivityInstance = this.service.getHistoryService().getHistoricActivityByTaskId(taskId);
                    if (null != historicActivityInstance && (cyclenum = BpmnNodeValidator.getCycleCount("_", cycle = historicActivityInstance.getCycle())) > 10) {
                        this.service.abandonProInstance(procInstId.longValue());
                        BpmnNodeValidateUtil.markTestingPlanTerminated((Long)testingPlan.getId());
                        return;
                    }
                    TestingPathEntity pathItem = this.getPathItem(taskId, testingPlan);
                    this.completeTask(testingPlan, taskId, pathItem);
                }
                if (0L == executionId || 0L == taskId) {
                    this.buildErrorInfo(procInstId, testingPlan);
                }
                return;
            }
        }
        catch (Exception e) {
            String error = WfUtils.getExceptionStacktrace((Throwable)e);
            this.log.debug(error);
            BpmnNodeValidateUtil.recordValidateFailed((Long)testingPlanId, (String)error);
            BpmnNodeValidateUtil.removeValidateDatas((Long)procInstId);
        }
    }

    private void validateDatas(List<ValidateModel> models, TestingPlanEntity testingPlan) {
        HistoricActivityInstanceEntity hisActInst = null;
        for (ValidateModel model : models) {
            hisActInst = model.getHisActInst();
            this.validate(hisActInst, model.getPathItem(), testingPlan.getId());
            if (hisActInst.getEndTime() != null) continue;
            this.completeTask(testingPlan, hisActInst.getTaskId(), model.getPathItem());
        }
    }

    private <T extends BaseElement> void validate(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem, Long testingPlanId) {
        BaseBpmnNodeValidator validator = this.validatorMap.get(activityInstance.getActivityType());
        if (validator != null) {
            validator.validateNode(activityInstance, pathItem, testingPlanId);
        } else {
            this.log.debug(String.format("%s \u7c7b\u578b\u7684\u8282\u70b9\u6ca1\u6709\u5bf9\u5e94\u7684\u6821\u9a8c\u5668!", activityInstance.getActivityType()));
        }
    }

    private void completeTask(TestingPlanEntity testingPlan, Long taskId, TestingPathEntity path) {
        if (WfUtils.isNotEmpty((Long)taskId) && null != path && null != path.getVariables() && !path.getVariables().isEmpty()) {
            if ("UserTask".equals(path.getActivityType())) {
                Map pathVariable;
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"wf_hitaskinst");
                String businessKey = task.getString("businesskey");
                String entityNumber = task.getString("entitynumber");
                if (WfUtils.isNotEmpty((String)path.getModifyExp())) {
                    String[] kvSet;
                    String expStr = path.getModifyExp().trim();
                    HashMap<String, String> keyMap = new HashMap<String, String>();
                    if (expStr.length() > 1 && expStr.startsWith("{") && expStr.endsWith("}") && (kvSet = (expStr = expStr.substring(1, expStr.length() - 1)).split("==")).length >= 1) {
                        String key = kvSet[0];
                        String value = kvSet.length > 1 ? kvSet[1] : "";
                        keyMap.put(key, value);
                    }
                    if (!keyMap.isEmpty()) {
                        DynamicObject up = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                        for (Map.Entry entry : keyMap.entrySet()) {
                            up.set((String)entry.getKey(), entry.getValue());
                        }
                        up.set("id", (Object)businessKey);
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{up});
                    }
                }
                String optNum = (pathVariable = (Map)JSON.parse((String)path.getVariables())).get(AUDITNUMBER) == null ? "submit" : (String)pathVariable.get(AUDITNUMBER);
                OperateOption options = OperateOption.create();
                options.setVariableValue("ishasright", String.valueOf(true));
                options.setVariableValue("mutex_writeback", String.valueOf(true));
                options.setVariableValue("specialdataperm_currentappid", "wftask");
                options.setVariableValue("appnumber", "wftask");
                options.setVariableValue("mutex_ignoremodify", "true");
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
                OperationResult ret = OperationServiceHelper.executeOperate((String)optNum, (String)entityNumber, (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)options);
                if (null != ret && !ret.isSuccess()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ret.getMessage());
                    List errs = ret.getAllErrorOrValidateInfo();
                    if (errs != null && errs.size() > 0) {
                        for (IOperateInfo info : errs) {
                            sb.append(info.getTitle()).append(":").append(info.getMessage());
                        }
                    }
                    testingPlan.setErrorInfo(sb.toString());
                    testingPlan.setState("failed");
                    testingPlan.setEndTime(WfUtils.now());
                    this.service.getRepositoryService().saveOrUpdateEntity((Entity)testingPlan);
                }
            } else if ("YunzhijiaTask".equals(path.getActivityType())) {
                List userIdList = Context.getProcessEngineConfiguration().getIdentityLinkEntityManager().findIdentityLinksByTaskId(taskId);
                if (null != userIdList && !userIdList.isEmpty()) {
                    IdentityLinkEntity entity = (IdentityLinkEntity)userIdList.get(0);
                    Long parentTaskId = entity.getParenttaskid();
                    QFilter[] filters = new QFilter[]{new QFilter("parentTaskId", "=", (Object)parentTaskId)};
                    List taskList = Context.getProcessEngineConfiguration().getTaskEntityManager().findByQueryFilters(filters);
                    if (null != taskList && !taskList.isEmpty()) {
                        for (TaskEntity t : taskList) {
                            Map pathVariable = (Map)JSON.parse((String)path.getVariables());
                            String decisionNum = TestingPlanUtil.getCycleDecisionByTaskId(taskId, path.getPlanId());
                            if (WfUtils.isNotEmpty((String)decisionNum)) {
                                pathVariable.put(AUDITNUMBER, decisionNum);
                            }
                            Long assigneeId = 0L;
                            List participantList = Context.getProcessEngineConfiguration().getIdentityLinkEntityManager().findIdentityLinksByTaskId(t.getId());
                            if (null != participantList && !participantList.isEmpty()) {
                                IdentityLinkEntity participant = (IdentityLinkEntity)participantList.get(0);
                                assigneeId = participant.getUserId();
                            }
                            this.service.getTaskService().complete(t.getId(), assigneeId, pathVariable);
                        }
                    }
                }
            } else {
                Map pathVariable = (Map)JSON.parse((String)path.getVariables());
                String decisionNum = TestingPlanUtil.getCycleDecisionByTaskId(taskId, path.getPlanId());
                if (WfUtils.isNotEmpty((String)decisionNum)) {
                    pathVariable.put(AUDITNUMBER, decisionNum);
                }
                Long assigneeId = path.getAssigneeId();
                List userIdList = Context.getProcessEngineConfiguration().getIdentityLinkEntityManager().findIdentityLinksByTaskId(taskId);
                if (null != userIdList && !userIdList.isEmpty()) {
                    IdentityLinkEntity entity = (IdentityLinkEntity)userIdList.get(0);
                    assigneeId = entity.getUserId();
                }
                this.service.getTaskService().complete(taskId, assigneeId, pathVariable);
            }
        } else {
            this.log.debug("can not complete task, because taskId is null or variables is empty! ");
        }
    }

    private TestingPathEntity getPathItem(Long taskId, TestingPlanEntity testingPlan) {
        TaskEntity task = (TaskEntity)this.service.getRepositoryService().findEntityById(taskId, "wf_task");
        String taskDefId = task.getTaskDefinitionKey();
        TestingPathEntity item = null;
        if (null != testingPlan) {
            QFilter f = new QFilter("planid", "=", (Object)testingPlan.getId());
            List pathItems = this.service.getRepositoryService().findEntitiesByFilters("wf_testingpath", new QFilter[]{f});
            for (TestingPathEntity i : pathItems) {
                if (null == taskDefId || !taskDefId.endsWith(i.getNodeId())) continue;
                return i;
            }
        }
        return item;
    }

    private void buildErrorInfo(Long procInstId, TestingPlanEntity testingPlan) {
        QFilter f = new QFilter("processInstanceId", "=", (Object)procInstId);
        List deadLetterJobs = this.service.getRepositoryService().findEntitiesByFilters("wf_deadletterjob", new QFilter[]{f});
        if (null != deadLetterJobs && !deadLetterJobs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (DeadLetterJobEntity dj : deadLetterJobs) {
                sb.append(dj.getExceptionMessage());
            }
            testingPlan.setErrorInfo(sb.toString());
            testingPlan.setState("failed");
            testingPlan.setEndTime(WfUtils.now());
            this.service.getRepositoryService().saveOrUpdateEntity((Entity)testingPlan);
        }
    }

    public static int getCycleCount(String target, String str) {
        int count = 1;
        int index = 0;
        while ((index = str.indexOf(target)) != -1) {
            str = str.substring(index + target.length());
            ++count;
        }
        return count;
    }
}

