/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;
import kd.bos.workflow.validator.BaseBpmnNodeValidator;

public class EndEventValidator
extends BaseBpmnNodeValidator {
    @Override
    protected void validate(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem) {
        ExecutionEntity execution = this.getClonedExecution(activityInstance);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(activityInstance.getProcessDefinitionId(), activityInstance.getProcessInstanceId());
        this.validateHistoricUserActInstEntity(bpmnModel, execution);
        this.markTestingPlanSuccess();
        this.clearDatas(activityInstance);
    }

    protected void validateHistoricUserActInstEntity(BpmnModel bpmnModel, ExecutionEntity execution) {
        Map variables = this.historyService.getHistoricVariableByExecution(execution.getId(), new String[]{"lastUserDealNode"});
        Object lastUserDealNode = variables.get("lastUserDealNode");
        if (!"start".equals(lastUserDealNode)) {
            QFilter[] filters = new QFilter[]{new QFilter("proInstId", "=", (Object)execution.getProcessInstanceId()), new QFilter("currentActInstId", "=", (Object)execution.getCurrentActInstId())};
            List entities = this.repositoryService.findEntitiesByFilters("wf_hiuseractinst", filters);
            EndEventValidator.assertTrue((entities != null && entities.size() == 1 ? 1 : 0) != 0);
            if (null != entities && entities.size() == 1) {
                HiUserActInstEntity hisUserActEntity = (HiUserActInstEntity)entities.get(0);
                this.historicUserActInstValidator.validateHistoricUserActEntity(bpmnModel, hisUserActEntity, execution);
                EndEventValidator.assertNotNull((Object)hisUserActEntity.getEndTime());
            }
        }
    }

    private void markTestingPlanSuccess() {
        TestingPlanEntity testingPlan = (TestingPlanEntity)this.repositoryService.findEntityById(this.getTestingPlanId(), "wf_testingplan");
        testingPlan.setState("successed");
        testingPlan.setEndTime(WfUtils.now());
        this.repositoryService.saveOrUpdateEntity((Entity)testingPlan);
    }

    private void clearDatas(HistoricActivityInstanceEntity activityInstance) {
        BpmnNodeValidateUtil.removeValidateDatas((Long)activityInstance.getProcessInstanceId());
    }
}

