/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.validator.UserTaskValidator;

public class FirstUserTaskValidator
extends UserTaskValidator {
    @Override
    protected void validateDatas(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem) {
        super.validateDatas(activityInstance, pathItem);
        if (!this.isProcessTerminal(activityInstance.getProcessInstanceId())) {
            ExecutionEntity procInstExecution = (ExecutionEntity)this.repositoryService.findEntityById(activityInstance.getProcessInstanceId(), "wf_execution");
            TestingPlanEntity testingPlan = (TestingPlanEntity)this.repositoryService.findEntityById(procInstExecution.getTestingPlanId(), "wf_testingplan");
            this.executionEntityValidator.validateProcessInstanceExecution(procInstExecution, testingPlan);
            ExecutionEntity executionEntity = (ExecutionEntity)this.repositoryService.findEntityById(activityInstance.getExecutionId(), "wf_execution");
            this.executionEntityValidator.validateExecution(activityInstance, executionEntity, procInstExecution);
            this.validateProcessStarter(procInstExecution);
            this.validateProcessInitialVariables(testingPlan, procInstExecution);
            HistoricProcessInstanceEntity hisProcessInstance = (HistoricProcessInstanceEntity)this.repositoryService.findEntityById(activityInstance.getProcessInstanceId(), "wf_hiprocinst");
            this.historicProcInstValidator.validateHistoricProcessInstanceEntity(hisProcessInstance, procInstExecution);
        }
    }

    protected void validateProcessInitialVariables(TestingPlanEntity testingPlan, ExecutionEntity procInstExecution) {
        HashMap<String, Object> expectedVars = new HashMap<String, Object>();
        Long starterId = testingPlan.getStarterId();
        expectedVars.put("_businessKey_", testingPlan.getNewBusinesskey());
        expectedVars.put("_initiator_", String.valueOf(starterId));
        expectedVars.put("SCHEMEID", testingPlan.getNewSchemeId());
        expectedVars.put("_entityNumber_", testingPlan.getEntityNumber());
        expectedVars.put("testingPlanId", testingPlan.getId());
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procInstExecution.getProcessDefinitionId(), procInstExecution.getProcessInstanceId());
        UserTask firstUserTask = BpmnModelUtil.getFirstUserTask((Process)bpmnModel.getMainProcess());
        expectedVars.put("_operation_", firstUserTask.getOperationStr());
        expectedVars.put("bizApplier", starterId);
        Map userInfo = UserServiceHelper.getUserInfoByID((long)starterId);
        expectedVars.put("bizApplierName", userInfo.get("name"));
        expectedVars.put("specialdataperm_currentappid", null);
        expectedVars.put("ishasright", Boolean.TRUE);
        QFilter[] filters = new QFilter[]{new QFilter("executionId", "=", (Object)procInstExecution.getId())};
        List variables = this.repositoryService.findEntitiesByFilters("wf_variableinstance", filters);
        for (VariableInstanceEntity variable : variables) {
            if (variable.getName().endsWith("forkResult")) continue;
            this.variableEntityValidator.validateVariableEntity(procInstExecution, variable, expectedVars);
        }
    }

    protected void validateProcessStarter(ExecutionEntity procInstExecution) {
        QFilter[] filters = new QFilter[]{new QFilter("processinstanceid", "=", (Object)procInstExecution.getProcessInstanceId()), new QFilter("userid", "=", (Object)procInstExecution.getStartUserId())};
        List entities = this.repositoryService.findEntitiesByFilters("wf_participant", filters);
        FirstUserTaskValidator.assertTrue((entities != null && entities.size() == 1 ? 1 : 0) != 0);
        if (null != entities && entities.size() == 1) {
            IdentityLinkEntity participant = (IdentityLinkEntity)entities.get(0);
            FirstUserTaskValidator.assertNotNull((Object)participant.getId());
            this.validateEquals("starter", participant.getType());
            this.validateEquals(procInstExecution.getStartUserId(), participant.getUserId());
            this.validateEquals(procInstExecution.getProcessDefinitionId(), participant.getProcessDefinitionId());
            FirstUserTaskValidator.assertTrue((boolean)WfUtils.isEmpty((Long)participant.getTaskId()));
            FirstUserTaskValidator.assertTrue((boolean)WfUtils.isEmpty((Long)participant.getParenttaskid()));
        }
    }

    @Override
    protected void validateHistoricActivitySpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricActivityInstanceEntity hisActInst, TestingPathEntity pathItem) {
        super.validateHistoricActivitySpecProps(bpmnModel, execution, hisActInst, pathItem);
        this.validateEquals("skip", hisActInst.getExecutionType());
        this.validateEquals("FirstUserTask", hisActInst.getSkipReason());
    }

    @Override
    protected void validateHistoricTaskSpecProps(BpmnModel bpmnModel, HistoricTaskInstanceEntity hisTask, ExecutionEntity execution, TestingPathEntity pathItem) {
        this.validateEquals("skip", hisTask.getExecutionType());
        FirstUserTaskValidator.assertTrue(("task skip".equals(hisTask.getDeleteReason()) || "first_usertask_skip".equals(hisTask.getDeleteReason()) ? 1 : 0) != 0);
        this.validateEquals(hisTask.getStarterId(), hisTask.getAssigneeId());
        User user = WfUtils.findUserById((long)hisTask.getAssigneeId());
        if (user != null) {
            this.validateEquals(user.getName(), hisTask.getAssignee());
        } else {
            FirstUserTaskValidator.assertTrue((boolean)WfUtils.isEmpty((String)hisTask.getAssignee()));
        }
    }

    @Override
    protected void validateCommentSpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricTaskInstanceEntity hisTask, CommentEntity comment) {
        String operation = (String)execution.getProcessInstance().getVariable("_operation_");
        this.validateEquals(operation, comment.getResultNumber());
        ILocaleString defaultValue = WfUtils.getPromptWordLocaleString((String)"\u63d0\u4ea4", (String)"FirstUserTaskValidator_0", (String)"bos-wf-unittest");
        ILocaleString resultName = TaskBehaviorUtil.getOperationName((String)hisTask.getEntityNumber(), (String)operation, (ILocaleString)defaultValue);
        this.validateEquals(resultName, comment.getResultName());
    }

    @Override
    protected List<Long> getParticipants(UserTask userTask, ExecutionEntity execution) {
        List<Long> userIds = this.calcParticipants(execution);
        if (userIds.isEmpty()) {
            userIds.add(execution.getProcessInstance().getStartUserId());
        }
        return userIds;
    }

    @Override
    protected void validateHistoricVariables(Long taskId, TestingPathEntity pathItem) {
    }
}

