/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.validator.BaseBpmnNodeValidator;

public class SequenceFlowValidator
extends BaseBpmnNodeValidator {
    protected DynamicResourceEntityManager dynamicResourceManager;
    protected HistoricDynamicResourceEntityManager hisDynResourceManager;

    public SequenceFlowValidator() {
        this.dynamicResourceManager = this.configuration.getDynamicResourceEntityManager();
        this.hisDynResourceManager = this.configuration.getHistoricDynamicResourceEntityManager();
    }

    @Override
    protected void validate(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(activityInstance.getProcessDefinitionId(), activityInstance.getProcessInstanceId());
        SequenceFlow sequenceFlow = (SequenceFlow)bpmnModel.getFlowElement(activityInstance.getActivityId());
        if (sequenceFlow.isDynamic()) {
            ExecutionEntity execution = this.getClonedExecution(activityInstance);
            this.validateDynamicResource(activityInstance, execution, bpmnModel);
        }
    }

    private void validateDynamicResource(HistoricActivityInstanceEntity activityInstance, ExecutionEntity execution, BpmnModel bpmnModel) {
        Long processInstanceId = activityInstance.getProcessInstanceId();
        Long activityInstId = activityInstance.getId();
        String activityId = activityInstance.getActivityId();
        if (!this.isProcessTerminal(activityInstance.getProcessInstanceId())) {
            DynamicResourceEntity dynamicResource = this.dynamicResourceManager.findByActivityId(processInstanceId, activityId);
            this.dynamicResourceValidator.validateDynamicResourceEntity(dynamicResource, execution, activityInstance, bpmnModel);
            HistoricDynamicResourceEntity hisDynamicResource = (HistoricDynamicResourceEntity)this.hisDynResourceManager.findById(dynamicResource.getId());
            this.dynamicResourceValidator.validateHistoricDynamicResourceEntityt(dynamicResource, hisDynamicResource);
        } else {
            DynamicResourceEntity dynamicResource = this.dynamicResourceManager.findByActivityId(processInstanceId, activityId);
            SequenceFlowValidator.assertNull((Object)dynamicResource);
            HistoricDynamicResourceEntity hisDynamicResource = this.hisDynResourceManager.findByActivityInstId(processInstanceId, activityInstId);
            this.dynamicResourceValidator.validateHistoricDynamicResourceEntity(hisDynamicResource, execution, activityInstance, bpmnModel);
        }
    }
}

