/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.validator.UserTaskValidator;

public class SkipNodeValidator
extends UserTaskValidator {
    @Override
    protected void validateHistoricActivityDatas(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem, ExecutionEntity execution, BpmnModel bpmnModel, Long taskId) {
        this.validateTerminalHistoricActivityEntity(bpmnModel, execution, pathItem);
    }

    @Override
    protected void validateTerminalHistoricActivityEntity(BpmnModel bpmnModel, ExecutionEntity execution, TestingPathEntity pathItem) {
        QFilter[] filters = new QFilter[]{new QFilter("executionId", "=", (Object)execution.getId()), new QFilter("activityId", "=", (Object)execution.getActivityId())};
        List entities = this.repositoryService.findEntitiesByFilters("wf_hiactinst", filters);
        HistoricActivityInstanceEntity hisActInst = (HistoricActivityInstanceEntity)entities.get(0);
        this.historicActivityValidator.validateTerminalHistoricActivityEntity(bpmnModel, execution, hisActInst, pathItem);
        this.validateTerminalHistoricActivitySpecProps(execution, bpmnModel, hisActInst);
    }

    @Override
    protected void validateTerminalHistoricActivitySpecProps(ExecutionEntity execution, BpmnModel bpmnModel, HistoricActivityInstanceEntity hisActInst) {
        this.validateEquals("skip", hisActInst.getExecutionType());
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(hisActInst.getActivityId());
        ParticipatantModel participantModel = userTask.getParticipant();
        List<Long> userIds = this.calcParticipants(execution);
        if (userIds.isEmpty() && participantModel != null && participantModel.isSkipNodeWithoutPart()) {
            this.validateEquals("NoParticipant", hisActInst.getSkipReason());
        } else if (userTask instanceof AuditTask && this.isSkippedByRepeaterApprove(execution, (AuditTask)userTask)) {
            this.validateEquals("SameParticipant", hisActInst.getSkipReason());
        } else {
            this.validateEquals("MeetSkipCondition", hisActInst.getSkipReason());
        }
        SkipNodeValidator.assertTrue((boolean)WfUtils.isEmpty((Long)hisActInst.getAssigneeId()));
        SkipNodeValidator.assertTrue((hisActInst.getAssignee() != null ? 1 : 0) != 0);
    }

    @Override
    protected void validateHistoricTaskAssignee(BpmnModel bpmnModel, HistoricTaskInstanceEntity hisTask) {
        super.validateHistoricTaskAssignee(bpmnModel, hisTask);
    }
}

