/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.validator.BaseBpmnNodeValidator;
import kd.bos.workflow.validator.FirstUserTaskValidator;
import kd.bos.workflow.validator.SkipNodeValidator;

public class UserTaskValidator
extends BaseBpmnNodeValidator {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    @Override
    protected void validate(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem) {
        ExecutionEntity execution = this.getClonedExecution(activityInstance);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(activityInstance.getActivityId());
        boolean isFirstUserTask = BpmnModelUtil.isSkipFirstUserTaskByPath((DelegateExecution)execution);
        if (isFirstUserTask) {
            new FirstUserTaskValidator().validateDatas(activityInstance, pathItem);
        } else if (this.isSkippedTask(execution, userTask)) {
            new SkipNodeValidator().validateDatas(activityInstance, pathItem);
        } else {
            this.validateDatas(activityInstance, pathItem);
        }
    }

    protected boolean isSkippedTask(ExecutionEntity execution, UserTask userTask) {
        boolean isSkip;
        ConditionalRuleEntity skipCondition = userTask.getSkipCondition();
        boolean bl = isSkip = DynamicFlowUtil.isSkipCurNode((DelegateExecution)execution) || skipCondition != null && ConditionUtil.hasTrueCondition((ConditionalRuleEntity)skipCondition, (VariableScope)execution, null);
        if (isSkip) {
            return true;
        }
        List<Long> userIds = this.calcParticipants(execution);
        ParticipatantModel participantModel = null;
        if ((userIds == null || userIds.isEmpty()) && (participantModel = userTask.getParticipant()) != null && participantModel.isSkipNodeWithoutPart()) {
            return true;
        }
        return isSkip;
    }

    protected void validateDatas(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem) {
        ExecutionEntity execution = (ExecutionEntity)this.repositoryService.findEntityById(activityInstance.getExecutionId(), "wf_execution");
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(activityInstance.getProcessDefinitionId(), activityInstance.getProcessInstanceId());
        Long taskId = activityInstance.getTaskId();
        if (execution != null && activityInstance.getActivityId().equals(execution.getActivityId())) {
            this.validateCurrentActivityDatas(pathItem, execution, bpmnModel, taskId);
        } else {
            execution = this.getClonedExecution(execution, activityInstance);
            this.validateHistoricActivityDatas(activityInstance, pathItem, execution, bpmnModel, taskId);
        }
    }

    protected void validateCurrentActivityDatas(TestingPathEntity pathItem, ExecutionEntity execution, BpmnModel bpmnModel, Long taskId) {
        this.validateHistoricActivity(bpmnModel, execution, pathItem);
        this.validateTask(bpmnModel, taskId, execution);
        this.validateParticipant(bpmnModel, execution, pathItem, taskId);
        this.validateHistoricUserActInstEntity(bpmnModel, execution);
    }

    protected void validateHistoricUserActInstEntity(BpmnModel bpmnModel, ExecutionEntity execution) {
        if (execution.getVariable("lastUserDealNode").equals("start")) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("proInstId", "=", (Object)execution.getProcessInstanceId()), new QFilter("currentActInstId", "=", (Object)execution.getCurrentActInstId())};
        List entities = this.repositoryService.findEntitiesByFilters("wf_hiuseractinst", filters);
        UserTaskValidator.assertTrue((entities != null && entities.size() == 1 ? 1 : 0) != 0);
        if (null != entities && entities.size() == 1) {
            HiUserActInstEntity hisUserActEntity = (HiUserActInstEntity)entities.get(0);
            this.historicUserActInstValidator.validateHistoricUserActEntity(bpmnModel, hisUserActEntity, execution);
            this.validateHistoricUserActSpecProps(hisUserActEntity, execution);
        }
    }

    protected void validateHistoricUserActSpecProps(HiUserActInstEntity hisUserActEntity, ExecutionEntity execution) {
        UserTaskValidator.assertNull((Object)hisUserActEntity.getEndTime());
    }

    protected void validateHistoricActivityDatas(HistoricActivityInstanceEntity activityInstance, TestingPathEntity pathItem, ExecutionEntity execution, BpmnModel bpmnModel, Long taskId) {
        this.validateTerminalHistoricActivityEntity(bpmnModel, execution, pathItem);
        this.validateHistoricTask(bpmnModel, taskId, execution, pathItem);
        this.validateHistoricParticipant(bpmnModel, taskId, execution, pathItem);
        this.validateHistoricVariables(taskId, pathItem);
        this.validateComment(bpmnModel, execution, taskId);
    }

    protected void validateComment(BpmnModel bpmnModel, ExecutionEntity execution, Long taskId) {
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(taskId, "wf_hitaskinst");
        List comments = this.taskService.getTaskComments(hisTask.getId());
        UserTaskValidator.assertNotNull((Object)comments);
        this.validateEquals(1, comments.size());
        CommentEntity comment = (CommentEntity)comments.get(0);
        this.commentEntityValidator.validateCommentEntity(hisTask, comment);
        this.validateCommentSpecProps(bpmnModel, execution, hisTask, comment);
    }

    protected void validateCommentSpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricTaskInstanceEntity hisTask, CommentEntity comment) {
        this.validateEquals(hisTask.getStarterId(), comment.getUserId());
    }

    protected void validateTask(BpmnModel bpmnModel, Long taskId, ExecutionEntity execution) {
        TaskEntity task = (TaskEntity)this.repositoryService.findEntityById(taskId, "wf_task");
        this.taskEntityValidator.validateTaskEntity(bpmnModel, task, execution);
        this.validateTaskSpecProps(bpmnModel, task, execution);
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(taskId, "wf_hitaskinst");
        this.taskEntityValidator.validateHistoricTaskEntity(task, hisTask, execution);
    }

    protected void validateHistoricTask(BpmnModel bpmnModel, Long taskId, ExecutionEntity execution, TestingPathEntity pathItem) {
        TaskEntity task = (TaskEntity)this.repositoryService.findEntityById(taskId, "wf_task");
        UserTaskValidator.assertNull((Object)task);
        HistoricTaskInstanceEntity hisTaskEntity = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(taskId, "wf_hitaskinst");
        TaskEntity taskEntity = this.getTaskEntityFromHistoricTask(hisTaskEntity);
        this.taskEntityValidator.validateHistoricTaskEntity(bpmnModel, hisTaskEntity, taskEntity, execution);
        this.validateHistoricTaskSpecProps(bpmnModel, hisTaskEntity, execution, pathItem);
    }

    protected void validateHistoricTaskSpecProps(BpmnModel bpmnModel, HistoricTaskInstanceEntity hisTask, ExecutionEntity execution, TestingPathEntity pathItem) {
        this.validateEquals("byHand", hisTask.getExecutionType());
        this.validateEquals("task complete", hisTask.getDeleteReason());
        this.validateHistoricTaskHandleState(hisTask, pathItem);
        this.validateHistoricTaskAssignee(bpmnModel, hisTask);
    }

    protected void validateHistoricTaskAssignee(BpmnModel bpmnModel, HistoricTaskInstanceEntity hisTask) {
        UserTaskValidator.assertNotNull((Object)hisTask.getAssignee());
        UserTaskValidator.assertNotNull((Object)hisTask.getAssigneeId());
    }

    protected void validateHistoricTaskHandleState(HistoricTaskInstanceEntity hisTask, TestingPathEntity pathItem) {
        this.validateEquals("handled", hisTask.getHandleState());
    }

    protected void validateTaskSpecProps(BpmnModel bpmnModel, TaskEntity taskEntity, ExecutionEntity execution) {
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey());
        this.validateTaskHandleState(execution, taskEntity, userTask);
    }

    protected void validateTaskHandleState(ExecutionEntity execution, TaskEntity taskEntity, UserTask userTask) {
        boolean isRejectTask = this.taskHelper.isRejectTask(execution.getProcessInstanceId(), execution.getCurrentActInstId(), userTask.getId());
        String handleState = isRejectTask ? "dismissed" : "willHandled";
        this.validateEquals(handleState, taskEntity.getHandleState());
    }

    protected void validateParticipant(BpmnModel bpmnModel, ExecutionEntity execution, TestingPathEntity pathItem, Long taskId) {
        TaskEntity task = (TaskEntity)this.repositoryService.findEntityById(taskId, "wf_task");
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(pathItem.getNodeId());
        List<Long> userIds = this.getParticipants(userTask, execution);
        UserTaskValidator.assertFalse((boolean)userIds.isEmpty());
        List participants = null;
        for (Long userId : userIds) {
            participants = this.taskService.getIdentityLinkEntitiesByTaskIdUserIdType(taskId, userId, "participant");
            UserTaskValidator.assertNotNull((Object)participants);
            this.validateEquals(1, participants.size());
            IdentityLinkEntity participant = (IdentityLinkEntity)participants.get(0);
            this.participantValidator.validateParticipantEntity(task, participant, userId);
            HistoricIdentityLinkEntity hisParticipant = (HistoricIdentityLinkEntity)this.repositoryService.findEntityById(participant.getId(), "wf_hiparticipant");
            this.participantValidator.validateHistoricParticipantEntity(participant, hisParticipant);
        }
    }

    protected void validateHistoricParticipant(BpmnModel bpmnModel, Long taskId, ExecutionEntity execution, TestingPathEntity pathItem) {
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(pathItem.getNodeId());
        this.validateHistoricParticipant(userTask, taskId, execution);
    }

    protected void validateHistoricParticipant(UserTask userTask, Long taskId, ExecutionEntity execution) {
        List<Long> userIds = this.getParticipants(userTask, execution);
        UserTaskValidator.assertFalse((boolean)userIds.isEmpty());
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(taskId, "wf_hitaskinst");
        HistoricIdentityLinkEntity hisParticipant = null;
        List participants = null;
        for (Long userId : userIds) {
            participants = this.taskService.getIdentityLinkEntitiesByTaskIdUserIdType(taskId, userId, "participant");
            UserTaskValidator.assertTrue((boolean)participants.isEmpty());
            hisParticipant = this.historyService.getHistoricIdentityLink(taskId, userId, "participant");
            this.participantValidator.validateHistoricParticipantEntity(hisParticipant, hisTask, userId);
        }
    }

    protected List<Long> getParticipants(UserTask userTask, ExecutionEntity execution) {
        List<Long> userIds = this.calcParticipants(execution);
        if (userIds.isEmpty() && BpmnModelUtil.isFirstNodeByModel((FlowNode)userTask)) {
            userIds.add(execution.getProcessInstance().getStartUserId());
        }
        return userIds;
    }

    protected void validateHistoricVariables(Long taskId, TestingPathEntity pathItem) {
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(taskId, "wf_hitaskinst");
        List hisVariables = this.historyService.getHistoricVariableInstanceEntityByTaskId(taskId);
        try {
            Map expectedVars = (Map)JSON.parse((String)pathItem.getVariables());
            UserTaskValidator.assertTrue((hisVariables != null && !hisVariables.isEmpty() ? 1 : 0) != 0);
            UserTaskValidator.assertNotNull((Object)pathItem);
            if (hisVariables != null) {
                this.validateEquals(hisVariables.size(), expectedVars.size());
                for (HistoricVariableInstanceEntity hisVariable : hisVariables) {
                    this.variableEntityValidator.validateHistoricVariableEntity(hisTask, hisVariable, expectedVars);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    protected void validateHistoricActivity(BpmnModel bpmnModel, ExecutionEntity execution, TestingPathEntity pathItem) {
        HistoricActivityInstanceEntity hisActInst = this.historyService.getHistoricActivityByTaskId(execution.getCurrentTaskId());
        this.historicActivityValidator.validateHistoricActivityEntity(bpmnModel, execution, hisActInst, pathItem);
        this.validateHistoricActivitySpecProps(bpmnModel, execution, hisActInst, pathItem);
    }

    protected void validateHistoricActivitySpecProps(BpmnModel bpmnModel, ExecutionEntity execution, HistoricActivityInstanceEntity hisActInst, TestingPathEntity pathItem) {
        this.validateEquals(pathItem.getStep(), String.valueOf(hisActInst.getStep()));
    }

    protected void validateTerminalHistoricActivityEntity(BpmnModel bpmnModel, ExecutionEntity execution, TestingPathEntity pathItem) {
        HistoricActivityInstanceEntity hisActInst = this.historyService.getHistoricActivityByTaskId(execution.getCurrentTaskId());
        this.historicActivityValidator.validateTerminalHistoricActivityEntity(bpmnModel, execution, hisActInst, pathItem);
        this.validateTerminalHistoricActivitySpecProps(execution, bpmnModel, hisActInst);
    }

    protected void validateTerminalHistoricActivitySpecProps(ExecutionEntity execution, BpmnModel bpmnModel, HistoricActivityInstanceEntity hisActInst) {
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(hisActInst.getTaskId(), "wf_hitaskinst");
        this.validateEquals(hisTask.getAssigneeId(), hisActInst.getAssigneeId());
        this.validateEquals(hisTask.getAssignee(), hisActInst.getAssignee());
    }

    protected List<Long> calcParticipants(ExecutionEntity execution) {
        return this.participantCalculator.getUserIds(execution.getProcessInstanceId(), execution.getCurrentActivityId(), execution.getBusinessKey(), (VariableScope)execution, true);
    }

    protected String getRepeaterApproveDecision(ExecutionEntity execution, AuditTask auditTask) {
        HistoricTaskInstanceEntity hisTask = (HistoricTaskInstanceEntity)this.repositoryService.findEntityById(execution.getCurrentTaskId(), "wf_hitaskinst");
        List<Long> participants = this.calcParticipants(execution);
        boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(participants);
        if (allowRepeaters && !hisTask.getHandleState().equals("dismissed")) {
            List repeaterApprovalInfo = TaskUtils.getRepeaterApprovalAuditNumber(participants, (Long)execution.getProcessInstanceId(), (Long)execution.getProcessDefinitionId(), (ExecutionEntity)execution);
            if (!repeaterApprovalInfo.isEmpty()) {
                return auditTask.getRepeaterModel();
            }
            return null;
        }
        return null;
    }

    protected boolean isSkippedByRepeaterApprove(ExecutionEntity execution, AuditTask auditTask) {
        return auditTask.isRepeaterbtn() && "skip".equals(this.getRepeaterApproveDecision(execution, auditTask));
    }

    protected boolean isAutoAuditByRepeaterApprove(ExecutionEntity execution, AuditTask auditTask) {
        if (auditTask.isRepeaterbtn()) {
            return "auto".equals(this.getRepeaterApproveDecision(execution, auditTask));
        }
        return false;
    }
}

