/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator.entity;

import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.validator.AbstractWorkflowValidator;

public class DynamicResourceEntityValidator
extends AbstractWorkflowValidator {
    private static final String TEMPLATE_NAME = "dyn.%s.bpmn20.json";

    public void validateDynamicResourceEntity(DynamicResourceEntity dynamicResource, ExecutionEntity execution, HistoricActivityInstanceEntity activityInstance, BpmnModel bpmnModel) {
        DynamicResourceEntityValidator.assertNotNull((Object)dynamicResource);
        DynamicResourceEntityValidator.assertNotNull((Object)dynamicResource.getId());
        String name = String.format(TEMPLATE_NAME, bpmnModel.getMainProcess().getId());
        this.validateEquals(name, dynamicResource.getName());
        this.validateEquals(execution.getProcessDefinitionId(), dynamicResource.getProcessDefineId());
        this.validateEquals(execution.getProcessInstanceId(), dynamicResource.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getFlowElement(activityInstance.getActivityId());
        this.validateEquals(flowElement.getId(), dynamicResource.getActivityId());
        DynamicResourceEntityValidator.assertNotNull((Object)dynamicResource.getContent());
        DynamicResourceEntityValidator.assertNotNull((Object)dynamicResource.getCreateDate());
        DynamicResourceEntityValidator.assertNotNull((Object)dynamicResource.getModifyDate());
    }

    public void validateHistoricDynamicResourceEntityt(DynamicResourceEntity dynamicResource, HistoricDynamicResourceEntity hisDynamicResource) {
        DynamicResourceEntityValidator.assertNotNull((Object)dynamicResource);
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource);
        this.validateEquals(dynamicResource.getId(), hisDynamicResource.getId());
        this.validateEquals(dynamicResource.getName(), hisDynamicResource.getName());
        this.validateEquals(dynamicResource.getContent(), hisDynamicResource.getContent());
        this.validateEquals(dynamicResource.getProcessInstanceId(), hisDynamicResource.getProcessInstanceId());
        this.validateEquals(dynamicResource.getProcessDefineId(), hisDynamicResource.getProcessDefinitionId());
        this.validateEquals(dynamicResource.getActivityId(), hisDynamicResource.getActivityId());
        this.validateEquals(dynamicResource.getActivityInstanceId(), hisDynamicResource.getActivityInstanceId());
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource.getCreateDate());
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource.getModifyDate());
    }

    public void validateHistoricDynamicResourceEntity(HistoricDynamicResourceEntity hisDynamicResource, ExecutionEntity execution, HistoricActivityInstanceEntity activityInstance, BpmnModel bpmnModel) {
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource);
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource.getId());
        String name = String.format(TEMPLATE_NAME, bpmnModel.getMainProcess().getName());
        this.validateEquals(name, hisDynamicResource.getName());
        this.validateEquals(execution.getProcessDefinitionId(), hisDynamicResource.getProcessDefinitionId());
        this.validateEquals(execution.getProcessInstanceId(), hisDynamicResource.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getFlowElement(activityInstance.getActivityId());
        this.validateEquals(flowElement.getId(), hisDynamicResource.getActivityId());
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource.getContent());
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource.getCreateDate());
        DynamicResourceEntityValidator.assertNotNull((Object)hisDynamicResource.getModifyDate());
    }
}

