/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator.entity;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.validator.AbstractWorkflowValidator;

public class ExecutionEntityValidator
extends AbstractWorkflowValidator {
    public void validateExecution(HistoricActivityInstanceEntity activityInstance, ExecutionEntity executionEntity, ExecutionEntity parentExecutionEntity) {
        String currentActivityId = executionEntity.getCurrentActivityId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getFlowElement(currentActivityId);
        boolean isMulti = this.isMultiInstanceActivity(flowElement);
        if (isMulti) {
            ExecutionEntityValidator.assertTrue((boolean)executionEntity.isMultiInstanceRoot());
        } else {
            ExecutionEntityValidator.assertFalse((boolean)executionEntity.isMultiInstanceRoot());
        }
        if (activityInstance.getActivityId().equals(currentActivityId)) {
            ExecutionEntityValidator.assertTrue((boolean)executionEntity.isActive());
        } else {
            ExecutionEntityValidator.assertTrue((boolean)(isMulti ? Boolean.FALSE.equals(executionEntity.isActive()) : Boolean.TRUE.equals(executionEntity.isActive())));
        }
        this.validateEquals(parentExecutionEntity.getRootProcessInstanceId(), executionEntity.getRootProcessInstanceId());
        this.validateEquals(parentExecutionEntity.getId(), executionEntity.getParentId());
        this.validateEquals(parentExecutionEntity.getProcessDefinitionId(), executionEntity.getProcessDefinitionId());
        this.validateEquals(parentExecutionEntity.getProcessDefinitionKey(), executionEntity.getProcessDefinitionKey());
        Long processInstanceId = parentExecutionEntity.getProcessInstanceId();
        this.validateEquals(processInstanceId != null ? processInstanceId : parentExecutionEntity.getId(), executionEntity.getProcessInstanceId());
        ExecutionEntityValidator.assertFalse((boolean)executionEntity.isScope());
        this.validateEquals(parentExecutionEntity.getEntityNumber(), executionEntity.getEntityNumber());
        this.validateEquals(parentExecutionEntity.getEntraBillName(), executionEntity.getEntraBillName());
        this.validateEquals(parentExecutionEntity.getBusinessKey(), executionEntity.getBusinessKey());
        this.validateEquals(parentExecutionEntity.getSchemeId(), executionEntity.getSchemeId());
        this.validateEquals(parentExecutionEntity.getTestingPlanId(), executionEntity.getTestingPlanId());
        this.validateEquals(parentExecutionEntity.getStartUserId(), executionEntity.getStartUserId());
    }

    public void validateProcessInstanceExecution(ExecutionEntity processInstance, TestingPlanEntity testingPlan) {
        ExecutionEntityValidator.assertNotNull((Object)processInstance.getId());
        ExecutionEntityValidator.assertNotNull((Object)processInstance.getProcessInstanceId());
        ExecutionEntityValidator.assertNotNull((Object)processInstance.getRootProcessInstanceId());
        ExecutionEntityValidator.assertNotNull((Object)processInstance.getProcessDefinitionId());
        ExecutionEntityValidator.assertTrue((boolean)processInstance.isScope());
        Long starterId = testingPlan.getStarterId();
        this.validateEquals(starterId, processInstance.getStartUserId());
        this.validateEquals(testingPlan.getId(), processInstance.getTestingPlanId());
        this.validateEquals(testingPlan.getNewSchemeId(), processInstance.getSchemeId());
        String entityNumber = testingPlan.getEntityNumber();
        String businessKey = testingPlan.getNewBusinesskey();
        this.validateEquals(businessKey, processInstance.getBusinessKey());
        this.validateEquals(entityNumber, processInstance.getEntityNumber());
        this.validateEquals(testingPlan.getEntityName(), processInstance.getEntraBillName());
        String billNo = "";
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
        try {
            billNo = obj.getString("billno");
            if (WfUtils.isEmpty((String)billNo)) {
                billNo = obj.getString("name");
            }
        }
        catch (Exception e) {
            this.log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        Long orgId = null;
        try {
            orgId = obj.getLong("org");
        }
        catch (Exception e) {
            this.log.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.validateEquals(orgId, processInstance.getMainOrgId());
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.repositoryService.findEntityById(testingPlan.getNewSchemeId(), "wf_processdynamicconfig");
        ExecutionEntityValidator.assertNotNull((Object)scheme);
        ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)this.repositoryService.findEntityById(processInstance.getProcessDefinitionId(), "wf_processdefinition");
        ExecutionEntityValidator.assertNotNull((Object)procDefEntity);
        String processName = String.format("%s/%s/%s/%s", billNo, procDefEntity.getKey(), procDefEntity.getVersion(), scheme.getName());
        this.validateEquals(processName, processInstance.getName());
        ExecutionEntityValidator.assertNotNull((Object)processInstance.getCreateDate());
        ExecutionEntityValidator.assertNotNull((Object)processInstance.getModifyDate());
    }
}

