/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator.entity;

import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.validator.AbstractWorkflowValidator;

public class HistoricActivityEntityValidator
extends AbstractWorkflowValidator {
    public void validateHistoricActivityEntity(BpmnModel bpmnModel, ExecutionEntity execution, HistoricActivityInstanceEntity hisActInst, TestingPathEntity pathItem) {
        this.validateEquals(execution.getCurrentActInstId(), hisActInst.getId());
        this.validateEquals(execution.getProcessDefinitionId(), hisActInst.getProcessDefinitionId());
        this.validateEquals(execution.getProcessInstanceId(), hisActInst.getProcessInstanceId());
        this.validateEquals(execution.getId(), hisActInst.getExecutionId());
        this.validateEquals(execution.getActivityId(), hisActInst.getActivityId());
        FlowElement flowElement = bpmnModel.getFlowElement(execution.getActivityId());
        this.validateEquals(flowElement.getType(), hisActInst.getActivityType());
        this.validateEquals(flowElement.getName(), hisActInst.getActivityName());
        this.validateEquals(execution.getCurrentTaskId(), hisActInst.getTaskId());
        HistoricActivityEntityValidator.assertNotNull((Object)hisActInst.getCreateDate());
        HistoricActivityEntityValidator.assertNotNull((Object)hisActInst.getSourceElementId());
        this.validateEquals(pathItem.getLevel(), hisActInst.getLevel());
        this.validateEquals(pathItem.getCycle(), hisActInst.getCycle());
    }

    public void validateTerminalHistoricActivityEntity(BpmnModel bpmnModel, ExecutionEntity execution, HistoricActivityInstanceEntity hisActInst, TestingPathEntity pathItem) {
        this.validateHistoricActivityEntity(bpmnModel, execution, hisActInst, pathItem);
        HistoricActivityEntityValidator.assertNotNull((Object)hisActInst.getTargetElementId());
        HistoricActivityEntityValidator.assertNotNull((Object)hisActInst.getModifyDate());
        HistoricActivityEntityValidator.assertNotNull((Object)hisActInst.getDurationInMillis());
    }
}

