/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator.entity;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.validator.AbstractWorkflowValidator;

public class HistoricUserActInstEntityValidator
extends AbstractWorkflowValidator {
    public void validateHistoricUserActEntity(BpmnModel bpmnModel, HiUserActInstEntity hisUserActInst, ExecutionEntity execution) {
        this.validateEquals(execution.getId(), hisUserActInst.getExecutionId());
        this.validateEquals(execution.getProcessInstanceId(), hisUserActInst.getProinstId());
        this.validateEquals(execution.getBusinessKey(), hisUserActInst.getBusinesskey());
        String activityId = execution.getActivityId();
        FlowElement flowElement = bpmnModel.getFlowElement(activityId);
        this.validateEquals(flowElement.getId(), hisUserActInst.getCurrentActId());
        this.validateEquals(flowElement.getName(), hisUserActInst.getCurrentNodeName());
        this.validateEquals(execution.getCurrentActInstId(), hisUserActInst.getCurrentActinstId());
        HistoricActivityInstanceEntity lastActivityInst = this.getPreviousNodeActInst(execution.getProcessInstanceId(), execution.getCurrentActInstId());
        HistoricUserActInstEntityValidator.assertNotNull((Object)lastActivityInst);
        if (!"YunzhijiaTask".equals(lastActivityInst.getActivityType())) {
            this.validateEquals(lastActivityInst.getId(), hisUserActInst.getLastNodeActinstId());
            QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)lastActivityInst.getProcessInstanceId()), new QFilter("taskId", "=", (Object)lastActivityInst.getTaskId())};
            List comments = this.configuration.getCommentEntityManager().findByQueryFilters(filters, "id", String.format("%s desc", "time"));
            if (lastActivityInst.getStep() == 1) {
                HistoricUserActInstEntityValidator.assertTrue((boolean)comments.isEmpty());
            } else {
                HistoricUserActInstEntityValidator.assertTrue((comments.size() == 1 ? 1 : 0) != 0);
                this.validateEquals(hisUserActInst.getLastNodeCid(), ((CommentEntity)comments.get(0)).getId());
            }
        }
        this.validateEquals(lastActivityInst.getActivityId(), hisUserActInst.getLastUserNodeActId());
        this.validateEquals(lastActivityInst.getActivityName(), hisUserActInst.getLastNodeName());
        HistoricUserActInstEntityValidator.assertNotNull((Object)hisUserActInst.getCreateDate());
        HistoricUserActInstEntityValidator.assertNotNull((Object)hisUserActInst.getModifyDate());
    }

    private HistoricActivityInstanceEntity getPreviousNodeActInst(Long procInstId, Long actInstId) {
        HistoricActivityInstanceEntityManager hisActInstManager = this.configuration.getHistoricActivityInstanceEntityManager();
        List activityInstances = hisActInstManager.findByTargetId(procInstId, actInstId);
        HistoricActivityInstanceEntity lastActivityInst = (HistoricActivityInstanceEntity)activityInstances.get(0);
        activityInstances = this.configuration.getHistoricActivityInstanceEntityManager().findByTargetId(procInstId, lastActivityInst.getId());
        if (activityInstances.isEmpty()) {
            return this.getStartEventHisActInstEntity(hisActInstManager, procInstId);
        }
        lastActivityInst = (HistoricActivityInstanceEntity)activityInstances.get(0);
        if ("".equals(lastActivityInst.getExecutionType()) || lastActivityInst.getStep() == 1) {
            return lastActivityInst;
        }
        return this.getPreviousNodeActInst(procInstId, lastActivityInst.getId());
    }

    private HistoricActivityInstanceEntity getStartEventHisActInstEntity(HistoricActivityInstanceEntityManager hisActInstManager, Long procInstId) {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)procInstId), new QFilter("step", "=", (Object)Character.valueOf('1'))};
        List actInstEntities = hisActInstManager.findByQueryFilters(filters);
        HistoricUserActInstEntityValidator.assertFalse((boolean)actInstEntities.isEmpty());
        return (HistoricActivityInstanceEntity)actInstEntities.get(0);
    }
}

