/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator.entity;

import java.util.Date;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.validator.AbstractWorkflowValidator;

public class TaskEntityValidator
extends AbstractWorkflowValidator {
    public void validateTaskEntity(BpmnModel bpmnModel, TaskEntity taskEntity, ExecutionEntity execution) {
        TaskEntityValidator.assertNotNull((Object)taskEntity);
        TaskEntityValidator.assertNotNull((Object)taskEntity.getTaskDefinitionKey());
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey());
        TaskEntityValidator.assertNotNull((Object)userTask);
        ILocaleString taskName = TaskBehaviorUtil.getTaskName((DelegateExecution)execution, (UserTask)userTask, (ExpressionManager)this.expressionManager);
        this.validateEquals(taskName, taskEntity.getName());
        String description = TaskBehaviorUtil.getTaskDescription((DelegateExecution)execution, (String)userTask.getDocumentation(), (ExpressionManager)this.expressionManager);
        this.validateEquals(description, taskEntity.getDescription());
        String businessKey = execution.getBusinessKey();
        ILocaleString subject = TaskBehaviorUtil.getTaskSubject((UserTask)userTask, (TaskEntity)taskEntity, (String)businessKey, (String)userTask.getEntityNumber());
        this.validateEquals(subject, taskEntity.getSubject());
        TaskEntityValidator.assertNotNull((Object)taskEntity.getId());
        this.validateEquals(execution.getId(), taskEntity.getExecutionId());
        this.validateEquals(execution.getProcessInstanceId(), taskEntity.getProcessInstanceId());
        this.validateEquals(execution.getProcessDefinitionId(), taskEntity.getProcessDefinitionId());
        this.validateEquals(userTask.getId(), taskEntity.getTaskDefinitionKey());
        int priority = TaskBehaviorUtil.getTaskPriority((DelegateExecution)execution, (ExpressionManager)this.expressionManager, (String)userTask.getPriority());
        this.validateEquals(priority, taskEntity.getPriority());
        Date dueDate = TaskBehaviorUtil.getTaskDueDate((DelegateExecution)execution, (UserTask)userTask, (ExpressionManager)this.expressionManager);
        this.validateEquals(dueDate, taskEntity.getDueDate());
        this.validateEquals(userTask.getType(), taskEntity.getCategory());
        BillSetting billSetting = userTask.getBillSetting();
        String formKey = TaskBehaviorUtil.getTaskFormKey((DelegateExecution)execution, (ExpressionManager)this.expressionManager, (String)billSetting.getFormKey());
        this.validateEquals(formKey, taskEntity.getFormKey());
        this.validateEquals(billSetting.getMobilFormKey(), taskEntity.getMobileFormKey());
        this.validateEquals(userTask.getProcessingPage(), taskEntity.getProcessingPage());
        this.validateEquals(userTask.getProcessingMobilePage(), taskEntity.getProcessingMobilePage());
        String entityNumber = taskEntity.getEntityNumber();
        this.validateEquals(businessKey, taskEntity.getBusinessKey());
        this.validateEquals(entityNumber, taskEntity.getEntityNumber());
        String billNo = TaskBehaviorUtil.getTaskBillNo((String)entityNumber, (String)businessKey);
        this.validateEquals(billNo, taskEntity.getBillNo());
        this.validateEquals(!userTask.isHideTaskInCenter(), taskEntity.isDisplay());
        this.validateEquals("WF", taskEntity.getSource());
        String endType = TaskBehaviorUtil.getTaskEndType((UserTask)userTask);
        this.validateEquals(endType, taskEntity.getEndType());
        this.validateEquals("0", taskEntity.getYzjGroupId());
        this.validateEquals("byHand", taskEntity.getExecutionType());
        Long startUserId = execution.getProcessInstance().getStartUserId();
        this.validateEquals(startUserId, taskEntity.getStarterId());
        ILocaleString startName = TaskBehaviorUtil.getUserName((long)startUserId);
        this.validateEquals(startName, taskEntity.getStartName());
        String senderIds = (String)this.lastAssigneeParser.parseMacro(execution);
        this.validateEquals(senderIds, taskEntity.getSenderId());
        ILocaleString senderNames = this.lastAssigneeParser.getAssigneeNames(execution);
        this.validateEquals(senderNames, taskEntity.getSenderName());
        TaskEntityValidator.assertNotNull((Object)taskEntity.getCreateDate());
        TaskEntityValidator.assertNotNull((Object)taskEntity.getModifyDate());
    }

    public void validateHistoricTaskEntity(TaskEntity task, HistoricTaskInstanceEntity hisTask, ExecutionEntity execution) {
        TaskEntityValidator.assertNotNull((Object)task);
        TaskEntityValidator.assertNotNull((Object)hisTask);
        this.validateEquals(task.getId(), hisTask.getId());
        this.validateEquals(execution.getProcessDefinitionId(), hisTask.getProcessDefinitionId());
        this.validateEquals(execution.getProcessInstanceId(), hisTask.getProcessInstanceId());
        this.validateEquals(execution.getId(), hisTask.getExecutionId());
        this.validateEquals(task.getName(), hisTask.getName());
        this.validateEquals(task.getParentTaskId(), hisTask.getParentTaskId());
        this.validateEquals(task.getDescription(), hisTask.getDescription());
        this.validateEquals(task.getOwner(), hisTask.getOwner());
        this.validateEquals(task.getTaskAssignee(), hisTask.getTaskAssignee());
        this.validateEquals(task.getTaskDefinitionKey(), hisTask.getTaskDefinitionKey());
        this.validateEquals(task.isDisplay(), hisTask.isDisplay());
        this.validateEquals(task.getStarterId(), hisTask.getStarterId());
        this.validateEquals(task.getSenderId(), hisTask.getSenderId());
        this.validateEquals(task.getSubject(), hisTask.getSubject());
        this.validateEquals(task.getAssigneeId(), hisTask.getAssigneeId());
        this.validateEquals(task.getOwnerId(), hisTask.getOwnerId());
        this.validateEquals(task.getExecutionType(), hisTask.getExecutionType());
        this.validateEquals(task.getEntityNumber(), hisTask.getEntityNumber());
        this.validateEquals(task.getEntityName(), hisTask.getEntityName());
        this.validateEquals(task.getStartName(), hisTask.getStartName());
        this.validateEquals(task.getSenderName(), hisTask.getSenderName());
        this.validateEquals(task.getBusinessKey(), hisTask.getBusinessKey());
        this.validateEquals(task.getBillNo(), hisTask.getBillNo());
        this.validateEquals(task.getDelegationState(), hisTask.getDelegationState());
        this.validateEquals(task.getFormKey(), hisTask.getFormKey());
        this.validateEquals(task.getMobileFormKey(), hisTask.getMobileFormKey());
        this.validateEquals(task.getYzjGroupId(), hisTask.getYzjGroupId());
        this.validateEquals(task.getProcessingPage(), hisTask.getProcessingPage());
        this.validateEquals(task.getProcessingMobilePage(), hisTask.getProcessingMobilePage());
        this.validateEquals(task.getHandleState(), hisTask.getHandleState());
        this.validateEquals(task.getPriority(), hisTask.getPriority());
        this.validateEquals(task.getDueDate(), hisTask.getDueDate());
        this.validateEquals(task.getCategory(), hisTask.getCategory());
        this.validateEquals(task.getParticipantName(), hisTask.getParticipantName());
        this.validateEquals(task.getSource(), hisTask.getSource());
        this.validateEquals(task.getEntityNumber(), hisTask.getEntityNumber());
        this.validateEquals(task.getBillNo(), hisTask.getBillNo());
        this.validateEquals(task.getCategory(), hisTask.getCategory());
        this.validateEquals(task.getEndType(), hisTask.getEndType());
        this.validateEquals(task.getParticipantName(), hisTask.getParticipantName());
        TaskEntityValidator.assertNotNull((Object)hisTask.getCreateDate());
    }

    public void validateHistoricTaskEntity(BpmnModel bpmnModel, HistoricTaskInstanceEntity hisTaskEntity, TaskEntity taskEntity, ExecutionEntity execution) {
        TaskEntityValidator.assertNotNull((Object)hisTaskEntity);
        TaskEntityValidator.assertNotNull((Object)hisTaskEntity.getTaskDefinitionKey());
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(hisTaskEntity.getTaskDefinitionKey());
        TaskEntityValidator.assertNotNull((Object)userTask);
        ILocaleString taskName = TaskBehaviorUtil.getTaskName((DelegateExecution)execution, (UserTask)userTask, (ExpressionManager)this.expressionManager);
        this.validateEquals(taskName, hisTaskEntity.getName());
        String description = TaskBehaviorUtil.getTaskDescription((DelegateExecution)execution, (String)userTask.getDocumentation(), (ExpressionManager)this.expressionManager);
        this.validateEquals(description, hisTaskEntity.getDescription());
        String businessKey = execution.getBusinessKey();
        ILocaleString subject = TaskBehaviorUtil.getTaskSubject((UserTask)userTask, (TaskEntity)taskEntity, (String)businessKey, (String)userTask.getEntityNumber());
        this.validateEquals(subject, hisTaskEntity.getSubject());
        TaskEntityValidator.assertNotNull((Object)hisTaskEntity.getId());
        this.validateEquals(execution.getId(), hisTaskEntity.getExecutionId());
        this.validateEquals(execution.getProcessInstanceId(), hisTaskEntity.getProcessInstanceId());
        this.validateEquals(execution.getProcessDefinitionId(), hisTaskEntity.getProcessDefinitionId());
        this.validateEquals(userTask.getId(), hisTaskEntity.getTaskDefinitionKey());
        int priority = TaskBehaviorUtil.getTaskPriority((DelegateExecution)execution, (ExpressionManager)this.expressionManager, (String)userTask.getPriority());
        this.validateEquals(priority, hisTaskEntity.getPriority());
        Date dueDate = TaskBehaviorUtil.getTaskDueDate((DelegateExecution)execution, (UserTask)userTask, (ExpressionManager)this.expressionManager);
        this.validateEquals(dueDate, hisTaskEntity.getDueDate());
        this.validateEquals(userTask.getType(), hisTaskEntity.getCategory());
        BillSetting billSetting = userTask.getBillSetting();
        String formKey = TaskBehaviorUtil.getTaskFormKey((DelegateExecution)execution, (ExpressionManager)this.expressionManager, (String)billSetting.getFormKey());
        this.validateEquals(formKey, hisTaskEntity.getFormKey());
        this.validateEquals(billSetting.getMobilFormKey(), hisTaskEntity.getMobileFormKey());
        this.validateEquals(userTask.getProcessingPage(), hisTaskEntity.getProcessingPage());
        this.validateEquals(userTask.getProcessingMobilePage(), hisTaskEntity.getProcessingMobilePage());
        String entityNumber = hisTaskEntity.getEntityNumber();
        this.validateEquals(businessKey, hisTaskEntity.getBusinessKey());
        this.validateEquals(entityNumber, hisTaskEntity.getEntityNumber());
        String billNo = TaskBehaviorUtil.getTaskBillNo((String)entityNumber, (String)businessKey);
        this.validateEquals(billNo, hisTaskEntity.getBillNo());
        this.validateEquals(!userTask.isHideTaskInCenter(), hisTaskEntity.isDisplay());
        this.validateEquals("WF", hisTaskEntity.getSource());
        String endType = TaskBehaviorUtil.getTaskEndType((UserTask)userTask);
        this.validateEquals(endType, hisTaskEntity.getEndType());
        this.validateEquals("0", hisTaskEntity.getYzjGroupId());
        Long startUserId = execution.getProcessInstance().getStartUserId();
        this.validateEquals(startUserId, hisTaskEntity.getStarterId());
        ILocaleString startName = TaskBehaviorUtil.getUserName((long)startUserId);
        this.validateEquals(startName, hisTaskEntity.getStartName());
        String senderIds = (String)this.lastAssigneeParser.parseMacro(execution);
        this.validateEquals(senderIds, hisTaskEntity.getSenderId());
        ILocaleString senderNames = this.lastAssigneeParser.getAssigneeNames(execution);
        this.validateEquals(senderNames, hisTaskEntity.getSenderName());
        TaskEntityValidator.assertNotNull((Object)hisTaskEntity.getEndTime());
        TaskEntityValidator.assertNotNull((Object)hisTaskEntity.getDurationInMillis());
    }
}

