/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.validator.entity;

import java.util.Map;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.variable.VariableType;
import kd.bos.workflow.validator.AbstractWorkflowValidator;

public class VariableEntityValidator
extends AbstractWorkflowValidator {
    public void validateHistoricVariableEntity(HistoricTaskInstanceEntity hisTask, HistoricVariableInstanceEntity hisVariable, Map<String, Object> expectedVars) {
        VariableEntityValidator.assertNotNull((Object)hisVariable);
        VariableEntityValidator.assertNotNull((Object)hisVariable.getId());
        this.validateEquals(hisTask.getId(), hisVariable.getTaskId());
        this.validateEquals(hisTask.getExecutionId(), hisVariable.getExecutionId());
        this.validateEquals(hisTask.getProcessInstanceId(), hisVariable.getProcessInstanceId());
        HistoricActivityInstanceEntity hisActivity = this.historyService.getHistoricActivityByTaskId(hisTask.getId());
        VariableEntityValidator.assertNotNull((Object)hisActivity);
        this.validateEquals(hisActivity.getId(), hisVariable.getActInstId());
        VariableEntityValidator.assertTrue((boolean)expectedVars.containsKey(hisVariable.getName()));
        Object value = expectedVars.get(hisVariable.getName());
        VariableType type = this.variableTypes.findVariableType(value);
        this.validateEquals(type.getTypeName(), hisVariable.getTypeName());
        this.validateEquals(value, hisVariable.getValue());
        VariableEntityValidator.assertNotNull((Object)hisVariable.getCreateDate());
        VariableEntityValidator.assertNotNull((Object)hisVariable.getModifyDate());
    }

    public void validateVariableEntity(ExecutionEntity execution, VariableInstanceEntity variable, Map<String, Object> expectedVars) {
        this.validateEquals(execution.getId(), variable.getExecutionId());
        this.validateEquals(execution.getProcessInstanceId(), variable.getProcessInstanceId());
        VariableEntityValidator.assertTrue((boolean)expectedVars.containsKey(variable.getName()));
        Object value = expectedVars.get(variable.getName());
        VariableType type = this.variableTypes.findVariableType(value);
        this.validateEquals(type.getTypeName(), variable.getTypeName());
        this.validateEquals(value, variable.getValue());
        VariableEntityValidator.assertNotNull((Object)variable.getCreateDate());
        VariableEntityValidator.assertNotNull((Object)variable.getModifyDate());
    }
}

