/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.wfplugin.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFErrorCode;

public class AutoGenerateMultiBills
extends AbstractOperationServicePlugIn {
    protected static Log logger = LogFactory.getLog(AutoGenerateMultiBills.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return;
        }
        DynamicObject obj = dynamicObjects[0];
        obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"pm_purorderbill");
        String comment = obj.getLocaleString("comment").getLocaleValue();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.parseLong(dynamicObjects[0].getPkValue().toString()));
        if (comment.contains("normal")) {
            this.doBotpConversion("pm_purorderbill", "pm_purorderbill", ids);
            this.doBotpConversion("pm_purorderbill", "sm_salorder", ids);
        } else if (comment.contains("skip")) {
            this.doBotpConversion("pm_purorderbill", "sm_salorder", ids);
            this.doBotpConversion("pm_purorderbill", "im_purinbill", ids);
        } else if (comment.contains("onlyone")) {
            this.doBotpConversion("pm_purorderbill", "sm_salorder", ids);
        } else {
            Map tmp = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"batchGenerateSettleBill", (Object[])new Object[]{ids, "pm_purorderbill"});
            if (tmp != null && tmp.size() > 0) {
                for (Map.Entry entry : tmp.entrySet()) {
                    logger.debug(String.format("result:  %s-%s", entry.getKey(), entry.getValue()));
                }
            }
        }
        System.out.println(obj);
    }

    protected void doBotpConversion(String srcEntityNumber, String targetEntityNumber, Collection<Long> aggregationPkCols) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setHasRight(true);
        pushArgs.setAutoSave(true);
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(aggregationPkCols.size());
        for (Long obj : aggregationPkCols) {
            ListSelectedRow row = new ListSelectedRow((Object)obj, Boolean.valueOf(true));
            rows.add(row);
        }
        pushArgs.setSelectedRows(rows);
        logger.debug(String.format("\u5f00\u59cb\u6267\u884cbotp\u5355\u636e\u8f6c\u5316\uff0c\u539f\u5355[%1$s]Pks[%2$s]\uff0c\u76ee\u6807\u5355[%3$s]", srcEntityNumber, WfUtils.listToString(aggregationPkCols, (String)","), targetEntityNumber));
        ConvertOperationResult convResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)convResult.getTargetEntityNumber());
        List targetBillObjList = convResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType, true);
        logger.debug(String.format("botp\u5355\u636e\u8f6c\u5316\u5b8c\u6210\uff0c\u751f\u6210\u76ee\u6807\u5355[%s]\u4e2a\uff0c\u51c6\u5907\u6267\u884c\u63d0\u4ea4\u3002", targetBillObjList.size()));
        if (targetBillObjList.isEmpty()) {
            throw new KDException(WFErrorCode.engineError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5355\u636eBOTP\u8f6c\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"BotpBillCalculator_4", (String)"bos-wf-unittest", (Object[])new Object[0]), convResult.getMessage())});
        }
        DynamicObject[] targetBillObjs = targetBillObjList.toArray(new DynamicObject[targetBillObjList.size()]);
        String entityNumber = targetBillObjs[0].getDataEntityType().getName();
        Operations targetOperations = EntityMetadataCache.getDataEntityOperations((String)convResult.getTargetEntityNumber());
        this.doOperation(entityNumber, targetBillObjs, targetOperations.getSave());
        logger.debug(String.format("\u6267\u884c\u64cd\u4f5c[%s]\u5b8c\u6bd5\uff01", "save"));
    }

    private OperationResult doOperation(String entityNumber, DynamicObject[] targetBillObjs, String opKey) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("WF", "TRUE");
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("mutex_ignoremodify", "true");
        options.setVariableValue("ignoreinteraction", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationResult ret = OperationServiceHelper.executeOperate((String)opKey, (String)entityNumber, (DynamicObject[])targetBillObjs, (OperateOption)options);
        if (!(ret == null || ret.isSuccess() && targetBillObjs.length == ret.getSuccessPkIds().size())) {
            StringBuilder ssb = new StringBuilder();
            List errs = ret.getAllErrorOrValidateInfo();
            if (errs != null && !errs.isEmpty()) {
                for (IOperateInfo info : errs) {
                    ssb.append("\n").append(info.getTitle()).append(":").append(info.getMessage());
                }
            }
            WFBizOperationException bizErr = new WFBizOperationException(null, WFErrorCode.businessBizOperationError(), new Object[]{ssb.toString()});
            bizErr.setOperationResult(ret);
            throw bizErr;
        }
        return ret;
    }
}

