/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.wfplugin.op;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.AggregateInfo;
import kd.bos.workflow.engine.extitf.AggregateResult;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;

public class BillsAggregatePlugin
implements IWorkflowPlugin {
    protected static Log logger = LogFactory.getLog(BillsAggregatePlugin.class);

    public AggregateResult aggregateBills(AgentExecution execution, AggregateInfo info) {
        String entityNumber;
        logger.debug("aggregateBills");
        Map infos = info.getBills();
        HashMap<String, HashSet<String>> sourceBills = new HashMap<String, HashSet<String>>(16);
        HashSet allPks = new HashSet();
        AggregateResult ret = new AggregateResult();
        for (Map.Entry entry : infos.entrySet()) {
            entityNumber = (String)entry.getKey();
            Set pks = (Set)entry.getValue();
            allPks.addAll(pks);
            Set<String> srcIds = this.getDirectSourceBillIds(entityNumber, pks);
            Iterator iter = pks.iterator();
            Long[] targetPks = new Long[pks.size()];
            int i = 0;
            while (iter.hasNext()) {
                targetPks[i++] = Long.valueOf((String)iter.next());
            }
            Map sources = BFTrackerServiceHelper.findSourceBills((String)entityNumber, (Long[])targetPks);
            for (Map.Entry e : sources.entrySet()) {
                HashSet sourcePks = (HashSet)e.getValue();
                String sourceEntityNumber = (String)e.getKey();
                for (Long pk : sourcePks) {
                    String spk = String.valueOf(pk);
                    if (!srcIds.contains(spk)) continue;
                    HashSet<String> spkSet = (HashSet<String>)sourceBills.get(sourceEntityNumber);
                    if (spkSet == null) {
                        spkSet = new HashSet<String>(16);
                        sourceBills.put(sourceEntityNumber, spkSet);
                    }
                    spkSet.add(spk);
                }
            }
        }
        logger.debug(WfUtils.mapToString(sourceBills));
        logger.debug(WfUtils.listToString(allPks, (String)","));
        block4: for (Map.Entry entry : sourceBills.entrySet()) {
            entityNumber = (String)entry.getKey();
            Set spks = (Set)entry.getValue();
            ArrayList<Long> closedBills = new ArrayList<Long>();
            for (String spk : spks) {
                if (!this.isClosed(spk, entityNumber)) continue;
                closedBills.add(Long.valueOf(spk));
            }
            Map targetBills = BFTrackerServiceHelper.findDirtTargetBills((String)entityNumber, (Long[])closedBills.toArray(new Long[0]));
            ret.setEntityNumber(entityNumber);
            for (Map.Entry ety : targetBills.entrySet()) {
                BFRow row;
                String tpk;
                List rows = (List)ety.getValue();
                boolean flag = true;
                HashSet<String> groupPks = new HashSet<String>();
                Iterator iterator = rows.iterator();
                while (iterator.hasNext() && (flag = allPks.contains(tpk = String.valueOf((row = (BFRow)iterator.next()).getId().getBillId())))) {
                    groupPks.add(tpk);
                }
                if (!flag) continue;
                ret.setOver(true);
                ret.setBillPks(groupPks);
                ret.setSrcPk(String.valueOf(ety.getKey()));
                continue block4;
            }
        }
        return ret;
    }

    private boolean isClosed(String businesskey, String entityNumber) {
        DynamicObjectCollection dc;
        DynamicObject d = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(businesskey), (String)entityNumber);
        if (d != null && (dc = d.getDynamicObjectCollection("accountentry")) != null && !dc.isEmpty()) {
            for (DynamicObject dyn : dc) {
                String status = dyn.getString("billstatusfield");
                if (!WfUtils.isEmpty((String)status)) continue;
                return false;
            }
        }
        return true;
    }

    private Set<String> getDirectSourceBillIds(String entityNumber, Set<String> billIds) {
        HashSet<String> srcIds = new HashSet<String>(1);
        DynamicObject entity = WfUtils.findBusinessObject((String)billIds.iterator().next(), (String)entityNumber);
        Object[] pks = new Object[billIds.size()];
        int i = 0;
        for (String id : billIds) {
            pks[i] = Long.valueOf(id);
            ++i;
        }
        if (entity == null) {
            return srcIds;
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
        MainEntityType entityType = null;
        IDataEntityType dataEntityType = entity.getDataEntityType();
        entityType = dataEntityType instanceof MainEntityType ? (MainEntityType)dataEntityType : EntityMetadataCache.getDataEntityType((String)entityNumber);
        dataEntitySet.Parse(BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)entityType), entityType);
        for (LinkSetItemElement itemElement : linkSet.getItems()) {
            ExtendedDataEntity[] linkRows = dataEntitySet.FindByEntityKey(itemElement.getLinkEntityKey());
            if (linkRows == null) continue;
            for (ExtendedDataEntity linkRow : linkRows) {
                Object srcId = linkRow.getValue(itemElement.getLinkEntityKey() + "_sbillid");
                srcIds.add(String.valueOf(srcId));
            }
        }
        return srcIds;
    }

    public Set<Long> getTargetBills(String srcEntityNumber, String srcBusinesskey, String destEntityNumber) {
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(1528323775701998592L);
        return ids;
    }
}

