/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.workcalendar.cmd;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class RepairApprovedDurationCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = -5329033463089841179L;
    private static Log logger = LogFactory.getLog(RepairApprovedDurationCmd.class);
    private static final String FCREATEDATE = "FCREATEDATE";
    private static final String FENDTIME = "FENDTIME";
    private static final String WF_CONF_REAL_KEY = "workflow.isCompleteRepairApproveDuration";
    private static final Long TOTAL_NUM = 50000L;
    private static final Integer BATCHNUM = 1000;
    private static final List<String> TABLES = Arrays.asList("T_WF_HIPROCINST", "T_WF_HITASKINST");
    private static final String CLASS_NAME = "RepairDurationExecutor";
    private static final String KEY_WF_ISREPAIR_DURATION = "workflow.isrepairduration";
    private static final String CREATE_DATE = "createDate";
    private static final String END_DATE = "endDate";
    private static final Integer THREAD_NUMBER = 4;
    private Date beginDate;
    private Date endDate;

    public RepairApprovedDurationCmd(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public Boolean execute(CommandContext arg0) {
        logger.debug("execute task begin");
        Boolean isRepairDuration = WfConfigurationUtil.getIsOpenWorkCalendar();
        if (isRepairDuration.booleanValue()) {
            try {
                return this.executeRepair(this.beginDate, this.endDate);
            }
            catch (Exception e) {
                logger.debug(String.format("execute task occured exception -{%s}", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        return Boolean.FALSE;
    }

    private Boolean executeRepair(Date beginDate, Date endDate) {
        Map<Date, Object> dateMap = RepairApprovedDurationCmd.getBetweenDate(beginDate, endDate);
        for (String table : TABLES) {
            List<Long> ids = this.getIdListByDate(beginDate, endDate, table);
            Long dataNum = ids == null ? 0L : (long)ids.size();
            if (dataNum >= TOTAL_NUM) {
                this.executeMultiThreadTask(ids, THREAD_NUMBER, beginDate, endDate, table, dateMap);
                continue;
            }
            if (dataNum <= 0L) continue;
            this.executeTask(beginDate, endDate, table, ids, dateMap);
        }
        return Boolean.TRUE;
    }

    public List<Long> executeMultiThreadTask(List<Long> list, int nThreads, Date beginDate, Date endDate, String table, Map<Date, Object> dateMap) {
        if (list == null || list.size() < 1) {
            logger.debug("the collection is null");
            return Collections.EMPTY_LIST;
        }
        int capactiy = list.size() % nThreads > 0 ? list.size() / nThreads : list.size() / nThreads + 1;
        List partions = Lists.partition(list, (int)capactiy);
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads + 1);
        ArrayList<Future<List<Long>>> futures = new ArrayList<Future<List<Long>>>(partions.size());
        for (int i = 0; i < partions.size(); ++i) {
            CallableRepairDuration callTask = new CallableRepairDuration((List)partions.get(i), table, beginDate, endDate, dateMap);
            futures.add(executorService.submit(callTask));
        }
        executorService.shutdown();
        ArrayList<Long> result = new ArrayList<Long>();
        for (Future future : futures) {
            try {
                if (!future.isDone()) {
                    logger.debug(String.format("\u5f53\u524d\u5b50\u7ebf\u7a0b\u672a\u5b8c\u6210-\u540d\u79f0[%s]", Thread.currentThread().getName()));
                    Thread.sleep(2000L);
                }
                List subResult = (List)future.get();
                logger.debug("\u5f53\u524d\u5b50\u7ebf\u7a0b\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)subResult);
                result.addAll(subResult);
            }
            catch (InterruptedException e) {
                logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            }
            catch (ExecutionException e) {
                logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        logger.debug(String.format("\u4e3b\u7ebf\u7a0b\u7ed3\u675f-\u540d\u79f0[%s]", Thread.currentThread().getName()));
        return result;
    }

    private Long executeTask(Date beginDate, Date endDate, String table, List<Long> dataLists, Map<Date, Object> dateMap) {
        logger.debug(String.format("execute business logical, current thread:[%s]", Thread.currentThread().getName()));
        ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>();
        if (WfUtils.isNotEmptyForCollection(dataLists)) {
            for (Long id : dataLists) {
                Map<String, Date> tempMap = RepairApprovedDurationCmd.getRecordByFId(id, table);
                Long duration = RepairApprovedDurationCmd.getDuration(dateMap, tempMap.get(CREATE_DATE), tempMap.get(END_DATE));
                updateParamsList.add(new Object[]{id, duration});
            }
            RepairApprovedDurationCmd.executeUpdate(updateParamsList, table);
        }
        return dataLists.size();
    }

    private static Map<Date, Object> getBetweenDate(Date beginDate, Date endDate) {
        HashMap<Date, Object> resultMap = new HashMap<Date, Object>();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        logger.debug("getWorkCalendar request param:beginDate-{},endDate-{},rootOrgId-{}", new Object[]{beginDate, endDate, rootOrgId});
        BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
        try {
            DynamicObjectCollection dynamicObjectCollection;
            DynamicObject dynamicObject = baseDataServiceHelper.getWorkCalendar(Long.valueOf(rootOrgId), beginDate, endDate);
            if (null != dynamicObject && (dynamicObjectCollection = (DynamicObjectCollection)dynamicObject.get("dateentry")) != null) {
                for (DynamicObject dynamicDate : dynamicObjectCollection) {
                    Long entryid = Long.parseLong(String.valueOf(dynamicDate.get(0)));
                    Integer seq = Integer.parseInt(String.valueOf(dynamicDate.get(1)));
                    Integer datetype = Integer.parseInt(String.valueOf(dynamicDate.get(2)));
                    Date workdate = (Date)dynamicDate.get(3);
                    resultMap.put(workdate, datetype);
                }
            }
        }
        catch (Exception e) {
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        logger.debug("getWorkCalendar:{}", resultMap);
        return resultMap;
    }

    private List<Long> getIdListByDate(Date startDate, Date endDate, String tableName) {
        StringBuilder querySql = new StringBuilder("SELECT FID  FROM ");
        querySql.append(tableName).append(" WHERE  FCREATEDATE >= ? AND FCREATEDATE < ? ");
        ArrayList<Date> paramList = new ArrayList<Date>(2);
        paramList.add(startDate);
        paramList.add(endDate);
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql.toString(), (Object[])paramList.toArray(), (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                ArrayList<Object[]> ret = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] t = new Object[]{rs.getLong("FID")};
                    ret.add(t);
                }
                return ret;
            }
        });
        return RepairApprovedDurationCmd.getList(ids);
    }

    private static List<Long> getList(List<Object[]> temp) {
        ArrayList<Long> dataList = new ArrayList<Long>(temp.size());
        for (Object[] objects : temp) {
            dataList.add((Long)objects[0]);
        }
        return dataList;
    }

    private static Map<String, Date> getRecordByFId(Long fid, String tableName) {
        HashMap<String, Date> result = new HashMap<String, Date>(2);
        Date createDate = null;
        Date enDate = null;
        StringBuilder querySql = new StringBuilder("SELECT FCREATEDATE,FENDTIME FROM ");
        querySql.append(tableName).append(" WHERE FID=").append(fid);
        DataSet dataset = DB.queryDataSet((String)WfUtils.createAlgoKey((String)CLASS_NAME), (DBRoute)DBRoute.workflow, (String)querySql.toString(), (Object[])new Object[0]);
        Iterator iterator = dataset.iterator();
        if (iterator != null && iterator.hasNext()) {
            Row row = (Row)iterator.next();
            createDate = (Date)row.get(FCREATEDATE);
            enDate = (Date)row.get(FENDTIME);
        }
        result.put(CREATE_DATE, createDate);
        result.put(END_DATE, enDate);
        return result;
    }

    private static Long getDuration(Map<Date, Object> subDateMap, Date recordStartDate, Date recordEndDate) {
        Integer flag = 0;
        Long beginTimes = recordStartDate.getTime();
        Long endTimes = recordEndDate.getTime();
        if (null != subDateMap && subDateMap.size() > 0) {
            for (Map.Entry<Date, Object> tempDate : subDateMap.entrySet()) {
                Long temp = tempDate.getKey().getTime();
                if (temp - beginTimes < 0L || temp - endTimes >= 0L || Integer.parseInt(tempDate.getValue().toString()) == 1) continue;
                Integer n = flag;
                Integer n2 = flag = Integer.valueOf(flag + 1);
            }
        }
        if (endTimes - beginTimes - (long)(flag * 24 * 60 * 60 * 1000) <= 0L) {
            return 0L;
        }
        return endTimes - beginTimes - (long)(flag * 24 * 60 * 60 * 1000);
    }

    private static void executeUpdate(List<Object[]> updateParamsList, String table) {
        if (WfUtils.isNotEmptyForCollection(updateParamsList)) {
            StringBuilder batchSql = new StringBuilder();
            batchSql.append("UPDATE ").append(table).append(" SET FDURATION=?  WHERE FID=? ");
            WfUtils.executeBatch((String)batchSql.toString(), updateParamsList, (Integer)BATCHNUM);
        }
    }

    public class CallableRepairDuration
    implements Callable<List<Long>> {
        private List<Long> list;
        private String table;
        private Date beginDate;
        private Date endDate;
        private Map<Date, Object> dateMap;

        public CallableRepairDuration(List<Long> list, String table, Date beginDate, Date endDate, Map<Date, Object> dateMap) {
            this.list = list;
            this.table = table;
            this.beginDate = beginDate;
            this.endDate = endDate;
            this.dateMap = dateMap;
        }

        @Override
        public List<Long> call() throws Exception {
            logger.debug(Thread.currentThread().getName() + "Callable \u5b50\u7ebf\u7a0b\u5f00\u59cb...");
            List<Long> resultList = Collections.synchronizedList(new ArrayList());
            Long flag = RepairApprovedDurationCmd.this.executeTask(this.beginDate, this.endDate, this.table, this.list, this.dateMap);
            resultList.add(flag);
            logger.debug(Thread.currentThread().getName() + " Callable \u5b50\u7ebf\u7a0b\u7ed3\u675f...");
            return resultList;
        }
    }
}

