/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.workcalendar.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class WorkCalendarInfoUtil {
    private static Log logger = LogFactory.getLog(WorkCalendarInfoUtil.class);
    private static final String DATE_TYPE_WORKDAY = "1";
    private static final String MAX_DATE_STR = "2199-12-31 23:59:59";
    public static final String EXPIRING_FORM_YEARANDMONTH = "EXPIRING_FORM_YEARANDMONTH";
    public static final String EXPIRING_TO_YEARANDMONTH = "EXPIRING_TO_YEARANDMONTH";

    public static boolean getIsHavingWorkCalendarForGroup() {
        BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        DynamicObject dynamicObject = baseDataServiceHelper.getWorkCalendar(Long.valueOf(rootOrgId));
        if (null == dynamicObject) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isWorkDay(Date day) {
        Long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        return BaseDataServiceHelper.isWorkDay((Long)rootOrgId, (Date)day);
    }

    public static Date getFormatDate(Date startDate) {
        startDate = (Date)startDate.clone();
        startDate.setHours(0);
        startDate.setMinutes(0);
        startDate.setSeconds(0);
        return startDate;
    }

    public static Date getFormatEndDate(Date endDate) {
        endDate = (Date)endDate.clone();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        return endDate;
    }

    public static Map<String, Date> getFormatDate(String startYear, String startMonth, String endYear, String endMonth) {
        HashMap<String, Date> result = new HashMap<String, Date>(2);
        result.put(EXPIRING_FORM_YEARANDMONTH, WorkCalendarInfoUtil.getFirstDayOfMonth(Integer.parseInt(startYear), Integer.parseInt(startMonth)));
        result.put(EXPIRING_TO_YEARANDMONTH, WorkCalendarInfoUtil.getLastDayOfMonth(Integer.parseInt(endYear), Integer.parseInt(endMonth)));
        return result;
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static String getFirstDayOfMonthStr(Date firstDayOfMonth) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(firstDayOfMonth);
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static String getLastDayOfMonthStr(Date lastDayOfMonth) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(lastDayOfMonth);
    }

    public static Long getRealDuration(String startTime, String endTime, List<String> lawHolidayList, String workTimeStr) {
        try {
            if (endTime.compareTo(startTime) <= 0) {
                return 0L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
            String startTimeH = formatter.format(sdf.parse(startTime));
            String endTimeH = formatter.format(sdf.parse(endTime));
            String[] workingTimes = workTimeStr.split(",");
            String morning = workingTimes[0];
            String afternoon = workingTimes[1];
            String[] mornings = morning.split("-");
            String[] afternoons = afternoon.split("-");
            String startTimems = startTime.substring(16, startTime.length());
            String endTimems = endTime.substring(16, endTime.length());
            startTime = WorkCalendarInfoUtil.resetTimeInWorkTime(startTime, startTimeH, mornings, afternoons);
            endTime = WorkCalendarInfoUtil.resetTimeInWorkTime(endTime, endTimeH, mornings, afternoons);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startTimeLocal = LocalDateTime.parse(startTime, dateTimeFormatter);
            LocalDateTime endTimeLocal = LocalDateTime.parse(endTime, dateTimeFormatter);
            while (lawHolidayList.contains(startTimeLocal.format(dateTimeFormatter).substring(0, 10))) {
                startTimeLocal = startTimeLocal.plusDays(1L);
                startTime = startTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(":00");
                if (!(startTimeLocal = LocalDateTime.parse(startTime, dateTimeFormatter)).isAfter(endTimeLocal)) continue;
                return 0L;
            }
            while (lawHolidayList.contains(endTimeLocal.format(dateTimeFormatter).substring(0, 10))) {
                endTimeLocal = endTimeLocal.minusDays(1L);
                endTime = endTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(afternoons[1]).concat(":00");
                endTimeLocal = LocalDateTime.parse(endTime, dateTimeFormatter);
            }
            startTimeH = formatter.format(sdf.parse(startTime));
            endTimeH = formatter.format(sdf.parse(endTime));
            long holidayCount = 0L;
            long holidaySumCount = 0L;
            while (startTimeLocal.isBefore(endTimeLocal)) {
                String dateStr = startTimeLocal.format(dateTimeFormatter);
                if (lawHolidayList.contains(dateStr.substring(0, 10))) {
                    ++holidayCount;
                    ++holidaySumCount;
                }
                startTimeLocal = startTimeLocal.plusDays(1L);
            }
            long startTimeL = sdf.parse(startTime).getTime();
            long endTimeL = sdf.parse(endTime).getTime();
            long minTime = endTimeL - startTimeL;
            long dayTime = minTime / 86400000L;
            startTime = startTimeLocal.format(dateTimeFormatter);
            long startMinute = sdf.parse(startTime.substring(0, 11).concat(afternoons[1]).concat(":00")).getTime();
            LocalDateTime nextStartTimeLocal = startTimeLocal;
            nextStartTimeLocal = nextStartTimeLocal.plusDays(1L);
            long endTMinute = sdf.parse(nextStartTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(":00")).getTime();
            long nexTime = endTMinute - startMinute;
            long startTimeMinute = sdf.parse(startTime.substring(0, 11).concat(mornings[1]).concat(startTimems)).getTime();
            long endTimeMinute = sdf.parse(startTime.substring(0, 11).concat(afternoons[0]).concat(endTimems)).getTime();
            nexTime += endTimeMinute - startTimeMinute;
            if (startTimeH.compareTo(endTimeH) > 0) {
                ++dayTime;
            }
            long timeDifference = holidayCount == 0L ? minTime - dayTime * nexTime : minTime - (dayTime - holidayCount) * nexTime - holidaySumCount * 24L * 60L * 60L * 1000L;
            if (startTimeH.compareTo(mornings[1]) <= 0 && endTimeH.compareTo(afternoons[0]) >= 0) {
                timeDifference -= endTimeMinute - startTimeMinute;
            } else if (startTimeH.compareTo(afternoons[0]) >= 0 && endTimeH.compareTo(mornings[1]) <= 0) {
                timeDifference += endTimeMinute - startTimeMinute;
            }
            return timeDifference;
        }
        catch (ParseException e) {
            logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            return 0L;
        }
    }

    private static String resetTimeInWorkTime(String startTime, String startTimeH, String[] mornings, String[] afternoons) {
        if (startTimeH.compareTo("00:00") >= 0 && startTimeH.compareTo(mornings[0]) < 0) {
            startTime = startTime.substring(0, 11).concat(mornings[0]).concat(":00");
        } else if (startTimeH.compareTo(mornings[1]) > 0 && startTimeH.compareTo(afternoons[0]) <= 0) {
            startTime = startTime.substring(0, 11).concat(mornings[1]).concat(":00");
        } else if (startTimeH.compareTo(afternoons[0]) > 0 && startTimeH.compareTo(afternoons[1]) <= 0) {
            startTime = startTime.substring(0, 11).concat(mornings[1]).concat(":00");
        } else if (startTimeH.compareTo(afternoons[1]) > 0) {
            startTime = startTime.substring(0, 11).concat(afternoons[1]).concat(":00");
        }
        return startTime;
    }
}

